/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.template;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.HashMap;
import miworkplace.ui.editor.template.TemplateVariable;

public class TemplateParser {
    TemplateVariable[] parse(String s) throws IOException {
        if (s == null || s.length() == 0) {
            return null;
        }
        HashMap<String, TemplateVariable> variables = new HashMap<String, TemplateVariable>();
        PushbackReader reader = new PushbackReader(new BufferedReader(new StringReader(s)), 2);
        int i = 0;
        int rawChar = reader.read();
        StringBuilder nameBuilder = new StringBuilder();
        do {
            char c = (char)rawChar;
            switch (c) {
                case '$': {
                    nameBuilder.append(c);
                    break;
                }
                case '{': {
                    if (nameBuilder.length() == 1) {
                        nameBuilder.append(c);
                        break;
                    }
                    if (nameBuilder.length() <= 0) break;
                    nameBuilder.delete(0, nameBuilder.length());
                    break;
                }
                case '}': {
                    if (nameBuilder.length() > 2) {
                        String name = nameBuilder.substring(2);
                        int offset = i - nameBuilder.length();
                        TemplateVariable var = (TemplateVariable)variables.get(name);
                        if (var == null) {
                            var = new TemplateVariable(name, offset);
                            variables.put(name, var);
                        } else {
                            var.addOffset(offset);
                        }
                        nameBuilder.delete(0, nameBuilder.length());
                        break;
                    }
                    if (nameBuilder.length() <= 0) break;
                    nameBuilder.delete(0, nameBuilder.length());
                    break;
                }
                default: {
                    if (nameBuilder.length() <= 1) break;
                    nameBuilder.append(c);
                }
            }
            rawChar = reader.read();
            ++i;
        } while (rawChar != -1);
        return variables.values().toArray(new TemplateVariable[variables.size()]);
    }
}

