/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.template;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import miworkplace.i18n.Messages;
import miworkplace.ui.editor.ITemplateService;
import miworkplace.ui.editor.Template;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeColumnViewerLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.service.event.Event;

public class SnippetsPart {
    @Inject
    private ITemplateService templateService;
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;
    private IResourcePool imagePool;
    private Composite noSnippetsLabel;
    private TreeViewer viewer;
    private StackLayout mainLayout;
    private Composite parentComposite;
    private EMenuService menuService;

    @Inject
    public SnippetsPart() {
    }

    @PostConstruct
    public void postConstruct(Composite parent, IResourcePool imagePool, EMenuService menuService, final ESelectionService selectionService) {
        this.imagePool = imagePool;
        this.menuService = menuService;
        this.parentComposite = parent;
        this.mainLayout = new StackLayout();
        parent.setLayout((Layout)this.mainLayout);
        this.noSnippetsLabel = this.buildNoSnippetsLabel(parent);
        this.viewer = this.buildViewer(parent);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                selectionService.setSelection((Object)event.getSelection());
                if (!event.getSelection().isEmpty() && event.getSelection() instanceof ITreeSelection) {
                    ITreeSelection selection = (ITreeSelection)event.getSelection();
                    Object element = selection.getFirstElement();
                    if (element == null) {
                        SnippetsPart.this.registerNoContextMenu();
                    } else if (element instanceof Template) {
                        SnippetsPart.this.registerContextMenu();
                    } else {
                        SnippetsPart.this.registerNoContextMenu();
                    }
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                String commandId = "miworkplace.ui.editor.command.insertsnippet";
                ParameterizedCommand command = SnippetsPart.this.commandService.createCommand(commandId, null);
                if (SnippetsPart.this.handlerService.canExecute(command)) {
                    SnippetsPart.this.handlerService.executeHandler(command);
                }
            }
        });
        this.showComponents();
    }

    private void registerContextMenu() {
        this.menuService.registerContextMenu((Object)this.viewer.getControl(), "miworkplace.ui.editor.popupmenu.snippets");
    }

    private void registerNoContextMenu() {
        this.menuService.registerContextMenu((Object)this.viewer.getControl(), "miworkplace.ui.editor.popupmenu.snippets.none");
    }

    private Composite buildNoSnippetsLabel(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        RowLayout layout = new RowLayout();
        form.getBody().setLayout((Layout)layout);
        toolkit.createLabel(form.getBody(), Messages.editor_template_snippets_nosnippets);
        return form;
    }

    private TreeViewer buildViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, 768);
        viewer.setSorter(new ViewerSorter());
        viewer.setLabelProvider((IBaseLabelProvider)new TreeColumnViewerLabelProvider((IBaseLabelProvider)new TreeLabelProvider()));
        viewer.setContentProvider((IContentProvider)new ContentProvider());
        return viewer;
    }

    private void showComponents() {
        List<Template> templates = this.templateService.get();
        if (templates == null || templates.isEmpty() || !this.hasSnippets(templates)) {
            this.mainLayout.topControl = this.noSnippetsLabel;
            this.parentComposite.layout();
        } else {
            this.viewer.setInput(templates);
            this.mainLayout.topControl = this.viewer.getControl();
            this.parentComposite.layout();
            this.viewer.expandAll();
        }
    }

    private boolean hasSnippets(List<Template> templates) {
        for (Template template : templates) {
            if (!template.getContext().equals("Snippets")) continue;
            return true;
        }
        return false;
    }

    @Inject
    @Optional
    public void notifiedTemplatesPersisted(@UIEventTopic(value="miworkplace/ui/editor/template/persisted") Event event) {
        this.showComponents();
    }

    class ContentProvider
    implements ITreeContentProvider {
        private final Object[] NO_ELEMENTS = new Object[0];
        private List<String> categories = new ArrayList<String>();
        private List<Template> templates = new LinkedList<Template>();
        private Map<String, List<Template>> templateMap = new HashMap<String, List<Template>>();

        ContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement == SnippetsPart.this.viewer.getInput()) {
                return this.categories.toArray(new String[this.categories.size()]);
            }
            if (parentElement instanceof String) {
                List<Template> templates = this.templateMap.get(parentElement.toString());
                return templates.toArray(new Template[templates.size()]);
            }
            return this.NO_ELEMENTS;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object getParent(Object element) {
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null) {
                this.categories.clear();
                this.templates.clear();
                this.templateMap.clear();
            } else {
                this.templates = (List)newInput;
                this.buildCategories(this.templates);
                this.buildTemplateMap(this.templates);
            }
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        private void buildCategories(List<Template> templates) {
            this.categories.clear();
            for (Template t : templates) {
                if (!StringUtils.isNotBlank((CharSequence)t.getCategory()) || this.categories.contains(t.getCategory())) continue;
                this.categories.add(t.getCategory());
            }
        }

        private void buildTemplateMap(List<Template> templates) {
            this.templateMap.clear();
            for (Template t : templates) {
                if (!t.getContext().equals("Snippets")) continue;
                List<Template> tlist = this.templateMap.get(t.getCategory());
                if (tlist == null) {
                    tlist = new ArrayList<Template>();
                    this.templateMap.put(t.getCategory(), tlist);
                }
                tlist.add(t);
            }
        }
    }

    class TreeLabelProvider
    extends LabelProvider {
        TreeLabelProvider() {
        }

        public String getText(Object obj) {
            return obj.toString();
        }

        public Image getImage(Object obj) {
            if (obj instanceof Template) {
                return SnippetsPart.this.imagePool.getImageUnchecked("IMAGE_TEMPLATE");
            }
            if (obj instanceof String) {
                return SnippetsPart.this.imagePool.getImageUnchecked("IMAGE_CATEGORY");
            }
            return null;
        }
    }
}

