/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.pref;

import java.net.URI;
import java.util.List;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.editor.ITemplateService;
import miworkplace.ui.editor.Template;
import miworkplace.ui.editor.pref.TemplatesSyncPreferenceNode;
import miworkplace.ui.editor.template.sync.FileTemplateLoader;
import miworkplace.ui.editor.template.sync.FtpTemplateLoader;
import miworkplace.ui.editor.template.sync.HttpTemplateLoader;
import miworkplace.ui.editor.template.sync.HttpsTemplateLoader;
import miworkplace.ui.pref.api.PreferencePage;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.service.prefs.Preferences;

class TemplatesSyncPreferencePage
extends PreferencePage {
    private TemplatesSyncPreferenceNode node;
    private ITemplateService templateService;
    private Button syncStartup;
    private Text txtResourceUrl;

    public TemplatesSyncPreferencePage(Composite parent, TemplatesSyncPreferenceNode node, ITemplateService templateService) {
        super(parent, 0);
        this.node = node;
        this.templateService = templateService;
        this.setLayout((Layout)new FillLayout());
        this.init((Composite)this);
    }

    private void init(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 20;
        layout.marginWidth = 25;
        form.getBody().setLayout((Layout)layout);
        form.setText(this.node.getName());
        toolkit.decorateFormHeading(form);
        Label description = toolkit.createLabel(form.getBody(), this.node.getDescription(), 64);
        FormData layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)description, 15);
        layoutData.left = new FormAttachment(0);
        Label l1 = toolkit.createLabel(form.getBody(), Messages.editor_pref_template_sync_url);
        l1.setLayoutData((Object)layoutData);
        layoutData = new FormData();
        layoutData.bottom = new FormAttachment((Control)l1, 2, 1024);
        layoutData.right = new FormAttachment(100);
        layoutData.width = 80;
        Button sync = toolkit.createButton(form.getBody(), Messages.editor_pref_template_sync_action, 8);
        sync.setLayoutData((Object)layoutData);
        sync.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String path = TemplatesSyncPreferencePage.this.txtResourceUrl.getText();
                if (StringUtils.isNotBlank((CharSequence)path)) {
                    try {
                        List<Template> loadedTemplates = null;
                        URI uri = URI.create(path);
                        String scheme = uri.getScheme().toLowerCase();
                        if (scheme.equals("file")) {
                            loadedTemplates = new FileTemplateLoader(TemplatesSyncPreferencePage.this.templateService).load(uri);
                        } else if (scheme.equals("http")) {
                            loadedTemplates = new HttpTemplateLoader(TemplatesSyncPreferencePage.this.templateService).load(uri);
                        } else if (scheme.equals("https")) {
                            loadedTemplates = new HttpsTemplateLoader(TemplatesSyncPreferencePage.this.templateService).load(uri);
                        } else if (scheme.equals("ftp")) {
                            loadedTemplates = new FtpTemplateLoader(TemplatesSyncPreferencePage.this.templateService).load(uri);
                        } else {
                            Notifier.info((String)Messages.editor_pref_template_sync_notify, (String)String.format(Messages.editor_pref_template_sync_nosupported, scheme));
                        }
                        if (loadedTemplates != null) {
                            loadedTemplates.isEmpty();
                        }
                    }
                    catch (Exception e) {
                        Notifier.error((String)Messages.editor_pref_template_sync_notify, (String)e.getMessage());
                    }
                }
            }
        });
        layoutData = new FormData();
        layoutData.bottom = new FormAttachment((Control)l1, 0, 1024);
        layoutData.left = new FormAttachment((Control)l1, 20, 131072);
        layoutData.right = new FormAttachment((Control)sync, -15, 16384);
        this.txtResourceUrl = toolkit.createText(form.getBody(), null);
        this.txtResourceUrl.setLayoutData((Object)layoutData);
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)l1, 15);
        layoutData.left = new FormAttachment((Control)l1, 0, 16384);
        Label l2 = toolkit.createLabel(form.getBody(), Messages.editor_pref_template_sync_startup);
        l2.setLayoutData((Object)layoutData);
        layoutData = new FormData();
        layoutData.bottom = new FormAttachment((Control)l2, 0, 1024);
        layoutData.left = new FormAttachment((Control)this.txtResourceUrl, 0, 16384);
        this.syncStartup = toolkit.createButton(form.getBody(), null, 32);
        this.syncStartup.setLayoutData((Object)layoutData);
        this.txtResourceUrl.setText(this.getPreferenceNode().get("url", ""));
        this.syncStartup.setSelection(this.getPreferenceNode().getBoolean("syncStartup", false));
        toolkit.paintBordersFor(form.getBody());
    }

    public boolean isValid() {
        return true;
    }

    public void save(IEclipsePreferences preferences) {
        Preferences node = this.getPreferenceNode();
        node.put("url", StringUtils.defaultString((String)this.txtResourceUrl.getText()));
        node.putBoolean("syncStartup", this.syncStartup.getSelection());
    }

    private Preferences getPreferenceNode() {
        return this.node.getPreferenceStore().node("templates").node("sync");
    }
}

