/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.ifs;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.text.MessageFormat;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.ui.editor.IDocumentReceiver;
import miworkplace.ui.editor.MemberRule;
import miworkplace.ui.editor.RemoteEditor;
import miworkplace.ui.editor.SaveStreamFileJob;
import miworkplace.ui.editor.SourceContentLoader;
import miworkplace.ui.editor.StreamFileContentLoader;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class StreamFileEditor
extends RemoteEditor {
    private static final String MIWORKPLACE_UI_EDITOR_POPUPMENU_IFS_DEFAULT = "miworkplace.ui.editor.popupmenu.ifs.default";
    private static final String SOURCE_CODE = "sourceCode";
    private static final String IFS_PATH = "ifsPath";

    @Inject
    public StreamFileEditor(MPart part, IResourcePool imagePool) {
        super(part, imagePool);
    }

    @Override
    protected void registerContextMenu() {
        this.menuService.registerContextMenu((Object)this.getViewer().getTextWidget(), MIWORKPLACE_UI_EDITOR_POPUPMENU_IFS_DEFAULT);
    }

    @Override
    public void load() {
        IConnection connection = this.connectionManager.get(this.connectionName);
        IEclipseContext additionalContext = EclipseContextFactory.create((String)SourceContentLoader.class.getName());
        additionalContext.set(IConnection.class, (Object)connection);
        additionalContext.set("inputUri", (Object)this.inputUri);
        additionalContext.set(IDocumentReceiver.class, (Object)this);
        additionalContext.set("miworkplace.editor.readonly", (Object)this.isReadOnly());
        StreamFileContentLoader loader = (StreamFileContentLoader)ContextInjectionFactory.make(StreamFileContentLoader.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext);
        this.stackLayout.topControl = this.defaultComposite;
        BusyIndicator.showWhile((Display)this.display, (Runnable)loader);
    }

    @Override
    public void save(@Named(value="activeShell") Shell shell) {
        this.logger.debug((Option)miworkplace.ui.editor.debug.Option.saving, MessageFormat.format("Saving {0}", this.getTitle()));
        IConnection connection = this.connectionManager.get(this.connectionName);
        IEclipseContext additionalContext = EclipseContextFactory.create((String)SaveStreamFileJob.class.getName());
        additionalContext.set(IConnection.class, (Object)connection);
        additionalContext.set(IFS_PATH, (Object)this.memberPath);
        additionalContext.set(SOURCE_CODE, (Object)this.getViewer().getDocument().get());
        SaveStreamFileJob job = (SaveStreamFileJob)((Object)ContextInjectionFactory.make(SaveStreamFileJob.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext));
        job.setRule(new MemberRule(connection.getName(), this.memberPath));
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent pEvent) {
                if (!pEvent.getResult().isOK()) {
                    StreamFileEditor.this.setDirty(true);
                } else {
                    StreamFileEditor.this.postFileSaved();
                }
            }
        });
        job.schedule();
        this.setDirty(false);
    }

    @Override
    public String getTitle() {
        return FilenameUtils.getName((String)this.memberPath);
    }
}

