/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.history;

import jakarta.inject.Inject;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import miworkplace.common.model.IRemoteObject;
import miworkplace.i18n.Messages;
import miworkplace.ui.editor.history.LocalHistoryPersistenceService;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.nebula.widgets.pgroup.AbstractGroupStrategy;
import org.eclipse.nebula.widgets.pgroup.PGroup;
import org.eclipse.nebula.widgets.pgroup.SimpleGroupStrategy;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.log.LogService;

public class LocalHistoryWizardPage
extends WizardPage {
    private static final String title = Messages.editor_history_title;
    @Inject
    private IResourcePool imagePool;
    @Inject
    private LogService logger;
    @Inject
    private LocalHistoryPersistenceService historyService;
    private boolean complete = false;
    private String text = "";
    private Text code = null;
    private SashForm sashForm = null;
    private Collection<RevisionGroup> root;
    private SimpleDateFormat datefmt = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat timefmt = new SimpleDateFormat("HH:mm:ss");
    private IRemoteObject remoteObject;

    @Inject
    public LocalHistoryWizardPage(IRemoteObject remoteObject) {
        super(title);
        this.remoteObject = remoteObject;
        this.setTitle(title);
        this.setDescription(String.format(Messages.editor_history_desc, remoteObject.getPath()));
    }

    public void createControl(Composite parent) {
        Composite controls = new Composite(parent, 0);
        controls.setLayout((Layout)new FillLayout());
        this.sashForm = new SashForm(controls, 66048);
        this.sashForm.setLayout((Layout)new FillLayout());
        PGroup group = new PGroup((Composite)this.sashForm, 65536);
        group.setStrategy((AbstractGroupStrategy)new SimpleGroupStrategy(group));
        group.setToggleRenderer(null);
        group.setLinePosition(1024);
        group.setText(Messages.editor_history_revtime);
        group.setImage(this.imagePool.getImageUnchecked("IMAGE_DATES"));
        group.setImagePosition(16384);
        group.setExpanded(true);
        group.setLayout((Layout)new FillLayout());
        this.createRevisionTree((Composite)group);
        group.pack();
        this.code = new Text((Composite)this.sashForm, 2826);
        this.code.setFont(JFaceResources.getTextFont());
        this.sashForm.setWeights(new int[]{1, 1});
        this.setControl((Control)controls);
    }

    public void dispose() {
        this.text = this.code.getText();
        super.dispose();
    }

    private Collection<RevisionGroup> loadRevisions() {
        TreeMap<Date, RevisionGroup> revMap = new TreeMap<Date, RevisionGroup>();
        File[] files = this.historyService.listHistoryFiles(this.remoteObject.getConnection(), this.remoteObject.getPath());
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile()) {
                Date d = new Date(files[i].lastModified());
                Date key = new Date(d.getYear(), d.getMonth(), d.getDate());
                if (!revMap.containsKey(key)) {
                    revMap.put(key, new RevisionGroup(d));
                }
                RevisionGroup rg = (RevisionGroup)revMap.get(key);
                rg.add(files[i]);
            }
            ++i;
        }
        return revMap.values();
    }

    private void createRevisionTree(Composite parent) {
        this.root = this.loadRevisions();
        TreeViewer treeViewer = new TreeViewer(parent, 2820);
        treeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selection instanceof RevisionGroup) {
                    LocalHistoryWizardPage.this.code.setText("");
                    LocalHistoryWizardPage.this.complete = false;
                    LocalHistoryWizardPage.this.getWizard().getContainer().updateButtons();
                } else if (selection instanceof Revision) {
                    LocalHistoryWizardPage.this.code.setText(LocalHistoryWizardPage.this.loadSource(((Revision)selection).getFile()));
                    LocalHistoryWizardPage.this.complete = true;
                    LocalHistoryWizardPage.this.getWizard().getContainer().updateButtons();
                }
            }
        });
        treeViewer.setInput(this.root);
        treeViewer.expandAll();
        treeViewer.setComparator((ViewerComparator)new TreeSorter());
    }

    private boolean isToday(Date date) {
        Date today = new Date();
        return date.getYear() == today.getYear() && date.getMonth() == today.getMonth() && date.getDate() == today.getDate();
    }

    private boolean isYesterday(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.roll(5, -1);
        Date yesterday = new Date(calendar.getTimeInMillis());
        return date.getYear() == yesterday.getYear() && date.getMonth() == yesterday.getMonth() && date.getDate() == yesterday.getDate();
    }

    private String loadSource(File file) {
        try {
            List lines = IOUtils.readLines((Reader)new FileReader(file));
            String code = StringUtils.join((Iterable)lines, (String)"\n");
            return code;
        }
        catch (Exception e) {
            this.logger.log(1, "Could not read content of history file " + file.getAbsolutePath(), (Throwable)e);
            return "";
        }
    }

    public boolean isPageComplete() {
        return this.complete;
    }

    public String getSelectedSourceCode() {
        return this.text;
    }

    class Revision {
        private File file;
        private String time;
        private RevisionGroup parent;

        Revision(RevisionGroup parent, File file) {
            this.parent = parent;
            this.file = file;
            Date d = new Date(file.lastModified());
            this.time = LocalHistoryWizardPage.this.timefmt.format(d);
        }

        RevisionGroup getParent() {
            return this.parent;
        }

        File getFile() {
            return this.file;
        }

        public String toString() {
            return this.time;
        }
    }

    class RevisionGroup {
        private String date;
        private Vector<Revision> files = new Vector();

        RevisionGroup(Date date) {
            this.date = LocalHistoryWizardPage.this.isToday(date) ? LocalHistoryWizardPage.this.datefmt.format(date) + " (Today)" : (LocalHistoryWizardPage.this.isYesterday(date) ? LocalHistoryWizardPage.this.datefmt.format(date) + " (Yesterday)" : LocalHistoryWizardPage.this.datefmt.format(date));
        }

        void add(Revision revision) {
            this.files.add(revision);
        }

        void add(File file) {
            this.files.add(new Revision(this, file));
        }

        Revision[] getRevisions() {
            return this.files.toArray(new Revision[this.files.size()]);
        }

        public String toString() {
            return this.date;
        }
    }

    class TreeContentProvider
    implements ITreeContentProvider {
        private Object[] noElements = new Object[0];

        TreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement == LocalHistoryWizardPage.this.root) {
                return LocalHistoryWizardPage.this.root.toArray(new RevisionGroup[LocalHistoryWizardPage.this.root.size()]);
            }
            if (parentElement instanceof RevisionGroup) {
                return ((RevisionGroup)parentElement).getRevisions();
            }
            if (parentElement instanceof Revision) {
                return this.noElements;
            }
            return this.noElements;
        }

        public Object getParent(Object element) {
            if (element instanceof RevisionGroup) {
                return LocalHistoryWizardPage.this.root;
            }
            if (element instanceof Revision) {
                return ((Revision)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TreeSorter
    extends ViewerComparator {
        TreeSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return e1.toString().compareTo(e2.toString()) * -1;
        }
    }
}

