/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.history;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Collection;
import java.util.HashMap;
import miworkplace.common.EditorInputUriUtil;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.ui.api.IRemoteEditor;
import miworkplace.ui.editor.history.LocalHistoryWizard;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class LocalHistoryUiHandler {
    private static final String OPEN_MEMBER_COMMAND_ID = "miworkplace.ui.command.openSourceMember";
    private static final String OPEN_STREAMFILE_COMMAND_ID = "miworkplace.ui.command.ifs.open";
    private ECommandService commandService;
    private EHandlerService handlerService;
    private EPartService partService;
    @Inject
    private IEclipseContext context;
    @Inject
    private LogService logger;
    @Inject
    private MApplication application;

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, IEclipseContext context, EPartService partService, ECommandService commandService, EHandlerService handlerService) {
        this.partService = partService;
        this.commandService = commandService;
        this.handlerService = handlerService;
        LocalHistoryWizard wizard = (LocalHistoryWizard)((Object)ContextInjectionFactory.make(LocalHistoryWizard.class, (IEclipseContext)context));
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.setMinimumPageSize(400, 600);
        IEclipseContext activeWindowContext = this.application.getContext().getActiveChild();
        if (dialog.open() == 0) {
            activeWindowContext.activate();
            IRemoteObject remoteObject = wizard.getTarget();
            IConnection connection = remoteObject.getConnection();
            IRemoteEditor editor = this.getEditor(connection, remoteObject);
            if (editor == null) {
                String commandId = remoteObject.getPath().startsWith("/QSYS.LIB") ? OPEN_MEMBER_COMMAND_ID : OPEN_STREAMFILE_COMMAND_ID;
                this.open(connection, remoteObject, commandId);
                editor = this.getEditor(connection, remoteObject);
            }
            if (editor != null && !editor.isReadOnly()) {
                editor.getDocument().set(wizard.getLocalHistoryCode());
            }
        }
    }

    private IRemoteEditor getEditor(IConnection connection, IRemoteObject object) {
        MPart part = this.getPart(object);
        return part == null ? null : (IRemoteEditor)part.getObject();
    }

    private MPart getPart(IRemoteObject source) {
        String inputUri = EditorInputUriUtil.buildInputUri((String)source.getConnection().getName(), (String)source.getPath());
        Collection parts = this.partService.getParts();
        for (MPart part : parts) {
            if (!part.getProperties().containsKey("miworkplace.editor") || !part.getProperties().containsKey("miworkplace.editor.inputUri") || !((String)part.getProperties().get("miworkplace.editor.inputUri")).equals(inputUri) || part.getObject() == null || !(part.getObject() instanceof IRemoteEditor)) continue;
            this.partService.activate(part, true);
            return part;
        }
        return null;
    }

    private void open(IConnection connection, IRemoteObject source, String commandId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("miworkplace.ui.editor.command.parameter.connection", connection.getName());
        parameters.put("miworkplace.ui.editor.command.parameter.selection", source.getPath());
        ParameterizedCommand command = this.commandService.createCommand(commandId, parameters);
        if (!command.getCommand().isDefined()) {
            this.logger.log(1, "Command " + commandId + " is not available. Could not open member " + source.getPath() + ".");
            return;
        }
        if (!this.handlerService.canExecute(command)) {
            this.logger.log(1, "Open Member Handler cannot execute for member " + source.getPath() + ".");
        } else {
            IEclipseContext handlerContext = this.context.createChild(this.getClass().getName());
            this.handlerService.executeHandler(command, handlerContext);
            handlerContext.dispose();
        }
    }
}

