/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import miworkplace.ui.api.IEditor;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.adapter.Adapter;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.osgi.service.log.LogService;

public class ShiftRightHandler {
    @Inject
    private Adapter adapter;
    @Inject
    private LogService logger;

    @CanExecute
    public boolean canExecute(@Named(value="e4ActivePart") MPart part) {
        boolean canDoOperation = part.getObject() instanceof IEditor;
        if (canDoOperation) {
            boolean bl = canDoOperation = !((IEditor)part.getObject()).isReadOnly();
        }
        if (canDoOperation) {
            boolean bl = canDoOperation = this.adapter.adapt(part.getObject(), IRewriteTarget.class) != null;
        }
        if (canDoOperation) {
            String[] positionCategories;
            String[] stringArray = positionCategories = ((IEditor)part.getObject()).getDocument().getPositionCategories();
            int n = positionCategories.length;
            int n2 = 0;
            while (n2 < n) {
                String category = stringArray[n2];
                if (category.equals("miworkplace.template.proposal.category")) {
                    return false;
                }
                ++n2;
            }
        }
        return canDoOperation;
    }

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part, @Preference(nodePath="miworkplace.application") IEclipsePreferences applicationPreferences) {
        block12: {
            Integer tabWidth = applicationPreferences.getInt("miworkplace.ui.editor.tabwidth", 4);
            boolean tabsToSpaces = applicationPreferences.getBoolean("miworkplace.ui.editor.spacesfortabs", true);
            String shiftPrefix = tabsToSpaces ? StringUtils.repeat((String)" ", (int)tabWidth) : "\t";
            ITextViewer viewer = ((IEditor)part.getObject()).getViewer();
            IDocument document = viewer.getDocument();
            IRewriteTarget target = (IRewriteTarget)this.adapter.adapt(part.getObject(), IRewriteTarget.class);
            TextSelection selection = (TextSelection)viewer.getSelectionProvider().getSelection();
            try {
                if (selection.getLength() == 0) {
                    document.replace(selection.getOffset(), 0, shiftPrefix);
                    viewer.setSelectedRange(selection.getOffset() + shiftPrefix.length(), 0);
                    break block12;
                }
                if (selection.getStartLine() == selection.getEndLine()) {
                    int lineStart = document.getLineOffset(selection.getStartLine());
                    int lineLength = document.getLineLength(selection.getStartLine());
                    if (selection.getOffset() == lineStart && selection.getLength() == lineLength - 1) {
                        target.beginCompoundChange();
                        try {
                            target.getDocument().replace(document.getLineOffset(selection.getStartLine()), 0, shiftPrefix);
                            viewer.setSelectedRange(lineStart, selection.getLength() + shiftPrefix.length());
                            break block12;
                        }
                        finally {
                            target.endCompoundChange();
                        }
                    }
                    document.replace(selection.getOffset(), 0, shiftPrefix);
                    viewer.setSelectedRange(selection.getOffset() + shiftPrefix.length(), selection.getLength());
                    break block12;
                }
                int lineIndex = selection.getStartLine();
                int endLineIndex = selection.getEndLine();
                boolean selectedWholeLine = document.getLineOffset(lineIndex) == selection.getOffset();
                int paddedCharsCount = 0;
                target.beginCompoundChange();
                try {
                    while (lineIndex <= endLineIndex) {
                        int lineStart = document.getLineOffset(lineIndex);
                        target.getDocument().replace(lineStart, 0, shiftPrefix);
                        ++lineIndex;
                        paddedCharsCount += shiftPrefix.length();
                    }
                    paddedCharsCount = selectedWholeLine ? paddedCharsCount : paddedCharsCount - shiftPrefix.length();
                    int newSelectionOffset = selectedWholeLine ? selection.getOffset() : selection.getOffset() + shiftPrefix.length();
                    viewer.setSelectedRange(newSelectionOffset, selection.getLength() + paddedCharsCount);
                }
                finally {
                    target.endCompoundChange();
                }
            }
            catch (BadLocationException e) {
                this.logger.log(1, "Could not shift line right. Error: " + e.getMessage());
            }
        }
    }
}

