/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import miworkplace.ui.api.IEditor;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.osgi.service.log.LogService;

public class MoveLineUpHandler {
    @Inject
    private LogService logger;

    @CanExecute
    public boolean canExecute(@Named(value="e4ActivePart") MPart part) {
        boolean canDoOperation;
        ITextViewer viewer = ((IEditor)part.getObject()).getViewer();
        TextSelection selection = (TextSelection)viewer.getSelectionProvider().getSelection();
        boolean bl = canDoOperation = selection.getStartLine() != 0;
        if (canDoOperation) {
            canDoOperation = part.getObject() instanceof IEditor && !((IEditor)part.getObject()).isReadOnly();
        }
        return canDoOperation;
    }

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part) {
        ITextViewer viewer = ((IEditor)part.getObject()).getViewer();
        TextSelection selection = (TextSelection)viewer.getSelectionProvider().getSelection();
        if (selection.getStartLine() == 0) {
            return;
        }
        try {
            int startOffset = viewer.getDocument().getLineOffset(selection.getStartLine());
            int endOffset = viewer.getDocument().getLineOffset(selection.getEndLine()) + viewer.getDocument().getLineLength(selection.getEndLine());
            int targetOffset = viewer.getDocument().getLineOffset(selection.getStartLine() - 1);
            int totalLength = endOffset - targetOffset;
            String text = viewer.getDocument().get(targetOffset, totalLength);
            text = this.switchLines(text);
            viewer.getTextWidget().replaceTextRange(targetOffset, totalLength, text);
            viewer.revealRange(targetOffset, 1);
            viewer.setSelectedRange(targetOffset, endOffset - startOffset);
        }
        catch (BadLocationException e) {
            this.logger.log(4, "Could not move line up. Cause: " + e.getMessage());
        }
    }

    private String switchLines(String text) {
        String[] strings = text.split("\n", 2);
        if (strings[1].endsWith("\n")) {
            return strings[1] + strings[0] + "\n";
        }
        return strings[1] + "\n" + strings[0];
    }
}

