/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.handler;

import jakarta.inject.Named;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import miworkplace.common.debug.Debug;
import miworkplace.ui.api.IEditor;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Point;

public class ContinueComment {
    private static final String SEP = "\n";
    private Debug logger = Debug.getInstance();
    Pattern fPattern = Pattern.compile("^(.*?[\\*\\/]+\\s?).*?$");

    @CanExecute
    public boolean canExecute(@Named(value="e4ActivePart") MPart part) {
        return part.getObject() instanceof IEditor && !((IEditor)part.getObject()).isReadOnly();
    }

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part) {
        ITextViewer viewer = ((IEditor)part.getObject()).getViewer();
        Point selectedRange = viewer.getSelectedRange();
        if (selectedRange.y > 0) {
            return;
        }
        try {
            IDocument document = viewer.getDocument();
            int startLine = document.getLineOfOffset(selectedRange.x);
            int lineStartOffset = document.getLineOffset(startLine);
            int lineLength = document.getLineLength(startLine);
            String part1 = document.get(lineStartOffset, selectedRange.x - lineStartOffset);
            Object part2 = document.get(selectedRange.x, lineLength + lineStartOffset - selectedRange.x);
            Matcher matcher = this.fPattern.matcher(part1);
            if (matcher.matches()) {
                String comment = matcher.group(1);
                part2 = SEP + comment + (String)part2;
                document.replace(selectedRange.x, lineLength + lineStartOffset - selectedRange.x, (String)part2);
            }
        }
        catch (BadLocationException e) {
            this.logger.error("Could not duplicate comment line.", (Throwable)e);
        }
    }
}

