/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.api.IEditor;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.swt.graphics.Point;
import org.osgi.service.log.LogService;

public class AlternateInsertLineHandler {
    @Inject
    private UISynchronize sync;
    @Inject
    private LogService logger;

    @CanExecute
    public boolean canExecute(@Named(value="e4ActivePart") MPart part) {
        return part.getObject() instanceof IEditor && !((IEditor)part.getObject()).isReadOnly();
    }

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part) {
        ITextViewer viewer = ((IEditor)part.getObject()).getViewer();
        IDocument document = viewer.getDocument();
        Point selectedRange = viewer.getSelectedRange();
        try {
            IRegion region = document.getLineInformationOfOffset(selectedRange.x);
            int indentationLength = this.getIndentationLength(document, region);
            int insertionOffset = region.getOffset() + region.getLength();
            String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
            String insertionString = lineDelimiter + StringUtils.repeat((String)" ", (int)indentationLength);
            document.replace(insertionOffset, 0, insertionString);
            int newCaretPosition = insertionOffset + insertionString.length();
            viewer.setSelectedRange(newCaretPosition, 0);
            viewer.revealRange(newCaretPosition, 0);
        }
        catch (BadLocationException ble) {
            this.sync.syncExec(new Runnable(){

                @Override
                public void run() {
                    AlternateInsertLineHandler.this.logger.log(1, "Could not insert new line below current position.", (Throwable)ble);
                    Notifier.error((String)Messages.editor_handler_altinsert_title, (String)Messages.editor_handler_altinsert_error);
                }
            });
        }
    }

    private int getIndentationLength(IDocument document, IRegion line) throws BadLocationException {
        int pos = line.getOffset();
        int max = pos + line.getLength();
        while (pos < max) {
            if (!Character.isWhitespace(document.getChar(pos))) break;
            ++pos;
        }
        return pos - line.getOffset();
    }
}

