/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.diff;

import java.util.List;
import miworkplace.ui.editor.diff.Chunk;
import miworkplace.ui.editor.diff.Delta;
import miworkplace.ui.editor.diff.PatchFailedException;

public class InsertDelta
extends Delta {
    public InsertDelta(Chunk original, Chunk revised) {
        super(original, revised);
    }

    @Override
    public void applyTo(List<Object> target) throws PatchFailedException {
        this.verify(target);
        int position = this.getOriginal().getPosition();
        List<?> lines = this.getRevised().getLines();
        int i = 0;
        while (i < lines.size()) {
            target.add(position + i, lines.get(i));
            ++i;
        }
    }

    @Override
    public void restore(List<Object> target) {
        int position = this.getRevised().getPosition();
        int size = this.getRevised().size();
        int i = 0;
        while (i < size) {
            target.remove(position);
            ++i;
        }
    }

    @Override
    public void verify(List<?> target) throws PatchFailedException {
        if (this.getOriginal().getPosition() > target.size()) {
            throw new PatchFailedException("Incorrect patch for delta: delta original position > target size");
        }
    }

    @Override
    public Delta.TYPE getType() {
        return Delta.TYPE.INSERT;
    }

    public String toString() {
        return "[InsertDelta, position: " + this.getOriginal().getPosition() + ", lines: " + String.valueOf(this.getRevised().getLines()) + "]";
    }
}

