/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.diff;

import java.util.List;
import miworkplace.ui.editor.diff.Chunk;
import miworkplace.ui.editor.diff.Delta;
import miworkplace.ui.editor.diff.PatchFailedException;

public class ChangeDelta
extends Delta {
    public ChangeDelta(Chunk original, Chunk revised) {
        super(original, revised);
    }

    @Override
    public void applyTo(List<Object> target) throws PatchFailedException {
        this.verify(target);
        int position = this.getOriginal().getPosition();
        int size = this.getOriginal().size();
        int i = 0;
        while (i < size) {
            target.remove(position);
            ++i;
        }
        i = 0;
        for (Object line : this.getRevised().getLines()) {
            target.add(position + i, line);
            ++i;
        }
    }

    @Override
    public void restore(List<Object> target) {
        int position = this.getRevised().getPosition();
        int size = this.getRevised().size();
        int i = 0;
        while (i < size) {
            target.remove(position);
            ++i;
        }
        i = 0;
        for (Object line : this.getOriginal().getLines()) {
            target.add(position + i, line);
            ++i;
        }
    }

    @Override
    public void verify(List<?> target) throws PatchFailedException {
        this.getOriginal().verify(target);
        if (this.getOriginal().getPosition() > target.size()) {
            throw new PatchFailedException("Incorrect patch for delta: delta original position > target size");
        }
    }

    public String toString() {
        return "[ChangeDelta, position: " + this.getOriginal().getPosition() + ", lines: " + String.valueOf(this.getOriginal().getLines()) + " to " + String.valueOf(this.getRevised().getLines()) + "]";
    }

    @Override
    public Delta.TYPE getType() {
        return Delta.TYPE.CHANGE;
    }
}

