/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import miworkplace.ui.editor.CursorVariableResolver;
import miworkplace.ui.editor.DateVariableResolver;
import miworkplace.ui.editor.ITemplateVariableResolver;
import miworkplace.ui.editor.TemplateBuffer;
import miworkplace.ui.editor.TemplateVariable;

public class TemplateContext {
    private List<ITemplateVariableResolver> resolvers = new ArrayList<ITemplateVariableResolver>();

    public TemplateContext() {
        this.resolvers.add(new DateVariableResolver());
        this.resolvers.add(new CursorVariableResolver());
    }

    public TemplateBuffer evaluate(TemplateBuffer templateBuffer) throws Exception {
        TemplateVariable cursor = null;
        TemplateVariable[] templateVariableArray = templateBuffer.getVariables();
        int n = templateVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateVariable v = templateVariableArray[n2];
            if ("cursor".equals(v.getName())) {
                cursor = v;
            }
            for (ITemplateVariableResolver resolver : this.resolvers) {
                String resolvedValue = resolver.resolve(v.getName());
                if (resolvedValue == null) continue;
                v.setValue(resolvedValue);
                v.setResolved(true);
            }
            ++n2;
        }
        StringBuilder buffer = new StringBuilder(templateBuffer.getContent());
        TreeMap<Integer, TemplateVariable> evaluatedValues = new TreeMap<Integer, TemplateVariable>();
        TemplateVariable[] templateVariableArray2 = templateBuffer.getVariables();
        int resolver = templateVariableArray2.length;
        int n3 = 0;
        while (n3 < resolver) {
            TemplateVariable v = templateVariableArray2[n3];
            if (v.isResolved()) {
                int[] nArray = v.getOffsets();
                int n4 = nArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    Integer offset = nArray[n5];
                    evaluatedValues.put(offset, v);
                    ++n5;
                }
            }
            ++n3;
        }
        for (Map.Entry entry : evaluatedValues.descendingMap().entrySet()) {
            int offset = (Integer)entry.getKey();
            int end = offset + ((TemplateVariable)entry.getValue()).getLength();
            buffer.replace(offset, end, ((TemplateVariable)entry.getValue()).getValue());
            int diffLength = ((TemplateVariable)entry.getValue()).getValue().length() - ((TemplateVariable)entry.getValue()).getLength();
            if (diffLength == 0 || cursor == null || cursor.getOffset(0) <= offset) continue;
            cursor.modifyOffset(0, diffLength);
        }
        return new TemplateBuffer(buffer.toString(), cursor);
    }

    public void addResolver(ITemplateVariableResolver resolver) {
        this.resolvers.add(resolver);
    }
}

