/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.FieldDescription;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.HashMap;
import miworkplace.common.debug.Debug;
import miworkplace.ui.editor.debug.Option;
import org.osgi.framework.FrameworkUtil;

public class SourceUtil {
    private static final int MAX_CHARS = 31;
    private static Debug logger;
    public static final int UNICODE_OFFSET = 8770;
    static final int[] fEbcdicCodes;
    static final String[] fSpecialChars;

    static {
        fEbcdicCodes = new int[31];
        fSpecialChars = new String[31];
        if (FrameworkUtil.getBundle(SourceUtil.class) != null) {
            logger = Debug.getInstance();
        }
        int ix = 0;
        int i = 0;
        while (i < 31) {
            SourceUtil.fSpecialChars[i] = new String(Character.toChars(8770 + ix));
            if (logger != null && logger.isOn((miworkplace.common.debug.Option)Option.loading)) {
                logger.debug((miworkplace.common.debug.Option)Option.loading, MessageFormat.format("SourceUtil EBCDIC Replacement: {0} - {1} - {2} - {3}", i, fSpecialChars[i], Character.valueOf(fSpecialChars[i].charAt(0)), fEbcdicCodes[i]));
            }
            ++ix;
            ++i;
        }
    }

    public static void main(String[] args) {
        int i = 30;
        while (i < 70) {
            SourceUtil.getControlChar(-i, i);
            ++i;
        }
        i = 0;
        while (i < 31) {
            System.out.println(MessageFormat.format("SourceUtil EBCDIC Replacement: {0} - {1} - {2} - {3}", i, fSpecialChars[i], ("\\U" + String.format("%04x", fSpecialChars[i].charAt(0))).toUpperCase(), fEbcdicCodes[i]));
            ++i;
        }
    }

    private static String getControlChar(int pOrig, int pCode) {
        if (pCode < 32 || pCode > 62) {
            return "?";
        }
        SourceUtil.fEbcdicCodes[pCode - 31 - 1] = pOrig;
        return fSpecialChars[pCode - 31 - 1];
    }

    private static int getControlCode(char pChar) {
        int ix = pChar - 8770;
        if (ix < 0 || ix > 32) {
            return 0;
        }
        return fEbcdicCodes[ix];
    }

    public static String convertToString(byte[] pLine, FieldDescription pFieldDescription) {
        HashMap<Integer, String> convertMap = new HashMap<Integer, String>();
        int i = 0;
        while (i < pLine.length) {
            byte b2 = pLine[i];
            if ((b2 & 0xFF) >= 32 && (b2 & 0xFF) <= 62) {
                convertMap.put(i, SourceUtil.getControlChar(b2, b2 & 0xFF));
            }
            ++i;
        }
        String line = pFieldDescription.getDataType().toObject(pLine).toString().stripTrailing() + "\n";
        StringBuilder result = new StringBuilder(line);
        convertMap.forEach((ix, b) -> result.replace((int)ix, ix + 1, (String)b));
        return result.toString();
    }

    public static Object convertToServer(String pLine, FieldDescription pFieldDescription) {
        ConvTable convTable;
        AS400Text text = (AS400Text)pFieldDescription.getDataType();
        try {
            convTable = ConvTable.getTable((int)text.getCcsid(), null);
        }
        catch (UnsupportedEncodingException e) {
            if (logger != null && logger.isOn((miworkplace.common.debug.Option)Option.loading)) {
                logger.debug((miworkplace.common.debug.Option)Option.loading, e.getMessage(), (Throwable)e);
            }
            throw new RuntimeException(e);
        }
        StringBuilder builder = new StringBuilder(pLine);
        HashMap<Integer, Integer> convertMap = new HashMap<Integer, Integer>();
        int len = builder.length();
        int i = 0;
        while (i < len) {
            int controlCode = SourceUtil.getControlCode(builder.charAt(i));
            if (controlCode > 0) {
                convertMap.put(i, controlCode);
            }
            ++i;
        }
        byte[] nativeBytes = convTable.stringToByteArray(pLine);
        convertMap.forEach((ix, b) -> {
            byArray[ix.intValue()] = b.byteValue();
        });
        return convTable.byteArrayToString(nativeBytes, 0, nativeBytes.length);
    }
}

