/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileWriter;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.StreamFile;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.editor.debug.Option;
import miworkplace.ui.editor.history.LocalHistoryPersistenceService;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;

public class SaveStreamFileJob
extends Job {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IConnection connection;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    private UISynchronize sync;
    private Debug logger = Debug.getInstance();
    @Inject
    @Named(value="ifsPath")
    private String ifsPath;
    @Inject
    @Named(value="sourceCode")
    private String editorContent;
    @Inject
    private LocalHistoryPersistenceService localHistorySaver;

    public SaveStreamFileJob() {
        super(Messages.editor_save_stmf_title);
    }

    protected IStatus run(final IProgressMonitor monitor) {
        this.logger.debug((miworkplace.common.debug.Option)Option.saving, "Saving source " + this.ifsPath);
        monitor.beginTask(String.format(Messages.editor_save_stmf_task1, this.ifsPath), 3);
        try {
            StreamFile streamFile = (StreamFile)this.workspaceStore.get(this.connection, this.ifsPath);
            this.editorContent = this.normalizeLineSeparators(this.editorContent);
            monitor.subTask(Messages.editor_save_stmf_task2);
            File file = streamFile.getLocalResource().getLocation().toFile();
            try {
                FileWriter out = new FileWriter(file);
                IOUtils.write((String)this.editorContent, (Writer)out);
                ((Writer)out).flush();
                ((Writer)out).close();
                monitor.worked(1);
            }
            catch (IOException ioe) {
                this.logger.debug((miworkplace.common.debug.Option)Option.saving, "Could not save editor content to local file " + file.getAbsolutePath() + ". Error: " + ioe.getMessage());
                throw new RuntimeException(Messages.editor_save_stmf_error);
            }
            monitor.subTask(Messages.editor_save_stmf_task3);
            this.localHistorySaver.save(this.connection, this.ifsPath, this.editorContent);
            monitor.worked(1);
            try {
                monitor.subTask(Messages.editor_save_stmf_task4);
                IFSFile remoteFile = new IFSFile(this.connection.getSystem(), this.ifsPath);
                if (!remoteFile.exists()) {
                    this.logger.error((miworkplace.common.debug.Option)Option.saving, "File " + this.ifsPath + " does not exist on remote server.");
                    this.logger.info((miworkplace.common.debug.Option)Option.saving, "Trying to create file " + this.ifsPath + "on remote server");
                    remoteFile.createNewFile();
                    if (!remoteFile.exists()) {
                        this.logger.error((miworkplace.common.debug.Option)Option.saving, "This file does not exist " + this.ifsPath + ".");
                        throw new RuntimeException(String.format(Messages.editor_save_stmf_error_notexist, this.ifsPath));
                    }
                } else if (!remoteFile.canWrite()) {
                    this.logger.error((miworkplace.common.debug.Option)Option.saving, "No write permisson on remote file " + this.ifsPath + ".");
                    throw new RuntimeException(String.format(Messages.editor_save_stmf_error_noperm, this.ifsPath));
                }
                BufferedWriter out = new BufferedWriter((Writer)new IFSFileWriter(remoteFile));
                IOUtils.write((String)this.editorContent, (Writer)out);
                try {
                    ((Writer)out).flush();
                    ((Writer)out).close();
                }
                catch (ConnectionDroppedException cde) {
                    this.logger.error((miworkplace.common.debug.Option)Option.saving, "Error on flushing and closing streams to " + this.ifsPath + ".", (Throwable)cde);
                }
                monitor.worked(1);
            }
            catch (Exception e) {
                this.logger.error((miworkplace.common.debug.Option)Option.saving, "Could not save source " + this.ifsPath + ".", (Throwable)e);
                throw new RuntimeException(Messages.editor_save_stmf_error);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("connection", this.connection.getName());
            map.put("memberPath", this.ifsPath);
            map.put("org.eclipse.e4.data", this.ifsPath);
            this.eventBroker.post("miworkplace/ui/editor/save/finished", map);
            Status status = new Status(0, "miworkplace.ui.editor", String.format(Messages.editor_save_stmf_status_success, this.ifsPath));
            return status;
        }
        catch (Exception e) {
            this.sync.syncExec(new Runnable(){

                @Override
                public void run() {
                    Notifier.error((String)Messages.editor_save_stmf_notify, (String)e.getMessage());
                    monitor.setCanceled(true);
                }
            });
            Status status = new Status(4, "miworkplace.ui.editor", String.format(Messages.editor_save_stmf_status_failed, this.ifsPath));
            return status;
        }
        finally {
            monitor.done();
        }
    }

    private String normalizeLineSeparators(String code) {
        StringBuilder sb = new StringBuilder(code);
        int x = sb.indexOf("\r\n");
        while (x > -1) {
            sb.replace(x, x + 2, "\n");
            x = sb.indexOf("\r\n", x);
        }
        return sb.toString();
    }

    public boolean belongsTo(Object family) {
        if (this.connection.getName().equals(family)) {
            return true;
        }
        String uri = this.connection.getName() + "://" + this.ifsPath;
        return uri.equals(family);
    }
}

