/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import miworkplace.ui.editor.ISourceViewerExtension;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class FormatLine
extends Composite
implements ControlListener {
    private ISourceViewerExtension editorExtention;
    private FormData layoutData;
    private StyledText formatText;
    private Color backgroundColor;
    private Color foregroundColor;

    public FormatLine(ISourceViewerExtension editorExtention, Composite parent) {
        super(parent, 0);
        this.editorExtention = editorExtention;
        this.backgroundColor = parent.getBackground();
        this.foregroundColor = parent.getForeground();
        this.setLayout((Layout)new FormLayout());
        this.layoutData = new FormData();
        this.layoutData.left = new FormAttachment(0);
        this.layoutData.right = new FormAttachment(100);
        this.formatText = new StyledText((Composite)this, 12);
        this.formatText.setLayoutData((Object)this.layoutData);
        this.formatText.setBackground(this.backgroundColor);
        this.formatText.setForeground(this.foregroundColor);
    }

    public void setFont(Font font) {
        this.formatText.setFont(font);
    }

    private void reposition() {
        this.layoutData.left = new FormAttachment((Control)this, this.getFormatFieldOffset());
        this.layoutData.right = new FormAttachment(100);
    }

    private int getFormatFieldOffset() {
        int offset = this.editorExtention.getSourceViewerOffset();
        return offset;
    }

    public void updateFormatLabel(String text, int position) {
        this.formatText.setStyleRange(null);
        if (text != null) {
            this.formatText.setText(text);
            if (position < text.length()) {
                this.formatText.setStyleRange(new StyleRange(position, 1, this.backgroundColor, this.foregroundColor));
            }
            this.update();
        } else {
            this.formatText.setText("");
            this.update();
        }
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        this.reposition();
        this.layout();
    }
}

