/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import miworkplace.common.debug.Debug;
import miworkplace.i18n.Messages;
import miworkplace.ui.api.IFindReplaceSupport;
import miworkplace.ui.editor.FindSearchData;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;

public class FindReplaceDialog
extends Dialog {
    private static final int HISTORY_MAX_ENTRIES = 10;
    private static final String HISTORY_ENTRIES_SEPARATOR = "\u00b6";
    private static final String HISTORY_FINDS = "finds";
    private static final String HISTORY_REPLACES = "replaces";
    private Debug logger = Debug.getInstance();
    @Inject
    private IEclipseContext context;
    @Inject
    @Optional
    @Named(value="org.eclipse.ui.selection")
    TextSelection textSelection;
    @Inject
    @Preference(nodePath="miworkplace.ui.findreplace")
    private IEclipsePreferences preferences;
    private FindSearchData findData;
    private MPart activePart;
    private Button replace;
    private Button replaceFind;
    private Deque<String> finds = new LinkedList<String>();
    private Deque<String> replaces = new LinkedList<String>();
    private Combo txtSearchValue;
    private Combo txtReplaceValue;
    private int newLocationX;
    private int newLocationY;
    private Label fMessage;
    private boolean fControlPressed;

    @Inject
    public FindReplaceDialog(@Named(value="activeShell") Shell parentShell, @Named(value="e4ActivePart") MPart part) {
        super(parentShell);
        this.setShellStyle(0xC70 | FindReplaceDialog.getDefaultOrientation());
        this.activePart = part;
    }

    @Inject
    private void setActivePart(@Optional @Named(value="e4ActivePart") MPart part) {
        if (part != null) {
            this.activePart = part;
        }
    }

    @PostConstruct
    public void postConstruct() {
        this.findData = (FindSearchData)this.context.get(FindSearchData.class);
        if (this.findData == null) {
            this.findData = new FindSearchData();
            this.context.set(FindSearchData.class, (Object)this.findData);
        }
        this.loadUserInput();
        int offsetX = this.preferences.getInt("x", 350);
        int offsetY = this.preferences.getInt("y", 100);
        Rectangle parentWindowBounds = this.getParentShell().getBounds();
        this.newLocationX = parentWindowBounds.x + parentWindowBounds.width - offsetX;
        this.newLocationY = parentWindowBounds.y + offsetY;
        this.newLocationX = offsetX;
        this.newLocationY = offsetY;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        switch (id) {
            case 0: {
                return null;
            }
            case 1: {
                return super.createButton(parent, id, "Close", false);
            }
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText(Messages.editor_find_title);
        Composite p = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(p, 0);
        container.setLayout((Layout)new GridLayout(3, true));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lblSearchString = new Label(container, 0);
        lblSearchString.setText(Messages.editor_find_form_find);
        this.txtSearchValue = new Combo(container, 2048);
        this.txtSearchValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        if (this.textSelection != null && this.textSelection.getLength() > 0) {
            String sel = this.textSelection.getText();
            if (this.finds.contains(sel)) {
                this.finds.remove(sel);
            }
            this.finds.addFirst(sel);
            this.findData.searchValue = sel;
        }
        if (!(this.textSelection != null && this.textSelection.getLength() != 0 || this.finds.isEmpty())) {
            this.findData.searchValue = this.finds.getFirst();
        }
        this.txtSearchValue.setItems(this.finds.toArray(new String[this.finds.size()]));
        if (!this.finds.isEmpty()) {
            this.txtSearchValue.select(0);
            this.txtSearchValue.setSelection(new Point(0, this.finds.peek().length()));
        }
        this.txtSearchValue.addListener(24, e -> {
            String string = this.findData.searchValue = this.txtSearchValue.getText();
        });
        Label lblReplace = new Label(container, 0);
        lblReplace.setText(Messages.editor_find_form_replace);
        this.txtReplaceValue = new Combo(container, 2048);
        this.txtReplaceValue.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.txtReplaceValue.setItems(this.replaces.toArray(new String[this.replaces.size()]));
        if (!this.replaces.isEmpty()) {
            this.txtReplaceValue.select(0);
        }
        this.txtReplaceValue.addListener(24, e -> {
            String string = this.findData.replaceValue = this.txtReplaceValue.getText();
        });
        Group directionGroup = new Group(container, 32);
        directionGroup.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        directionGroup.setLayout((Layout)new RowLayout(512));
        directionGroup.setText(Messages.common_direction);
        Button directionForward = new Button((Composite)directionGroup, 16);
        directionForward.setText(Messages.common_forward);
        directionForward.setSelection(this.getDirection() == FindSearchData.Direction.forward);
        directionForward.addListener(13, e -> {
            FindSearchData.Direction direction = this.findData.direction = directionForward.getSelection() ? FindSearchData.Direction.forward : FindSearchData.Direction.backward;
        });
        Button directionBackward = new Button((Composite)directionGroup, 16);
        directionBackward.setText(Messages.common_backward);
        directionBackward.setSelection(this.getDirection() == FindSearchData.Direction.backward);
        directionBackward.addListener(13, e -> {
            FindSearchData.Direction direction = this.findData.direction = directionBackward.getSelection() ? FindSearchData.Direction.backward : FindSearchData.Direction.forward;
        });
        Group optionsGroup = new Group(container, 32);
        optionsGroup.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        optionsGroup.setLayout((Layout)new RowLayout(512));
        optionsGroup.setText(Messages.common_options);
        Button optionCase = new Button((Composite)optionsGroup, 32);
        optionCase.setText(Messages.common_case);
        optionCase.setSelection(this.findData.caseSensitive);
        optionCase.addListener(13, e -> {
            boolean bl = this.findData.caseSensitive = optionCase.getSelection();
        });
        Button optionWrap = new Button((Composite)optionsGroup, 32);
        optionWrap.setText(Messages.editor_find_form_wrap);
        optionWrap.setSelection(this.findData.wrapSearch);
        optionWrap.addListener(13, e -> {
            boolean bl = this.findData.wrapSearch = optionWrap.getSelection();
        });
        Button optionRegex = new Button((Composite)optionsGroup, 32);
        optionRegex.setText("Regular Expression");
        optionRegex.setSelection(this.findData.regex);
        optionRegex.addListener(13, e -> {
            boolean bl = this.findData.regex = optionRegex.getSelection();
        });
        Group scopeGroup = new Group(container, 32);
        scopeGroup.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        scopeGroup.setLayout((Layout)new RowLayout(512));
        scopeGroup.setText("Scope");
        Button scopeAll = new Button((Composite)scopeGroup, 16);
        scopeAll.setText("All");
        scopeAll.setSelection(this.findData.scopeAll || this.findData.scopeSelected ? this.findData.scopeAll : true);
        scopeAll.addListener(13, e -> {
            boolean bl = this.findData.scopeAll = optionCase.getSelection();
        });
        Button scopeSelected = new Button((Composite)scopeGroup, 16);
        scopeSelected.setText("Selected Lines");
        scopeSelected.setSelection(this.findData.scopeSelected);
        scopeSelected.addListener(13, e -> {
            boolean bl = this.findData.scopeSelected = scopeSelected.getSelection();
        });
        this.fMessage = new Label(container, 0);
        this.fMessage.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        new Label(container, 0);
        Composite buttonGrid = new Composite(container, 0);
        buttonGrid.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        buttonGrid.setLayout((Layout)new GridLayout(2, true));
        Button find = new Button(buttonGrid, 8);
        find.setText(Messages.editor_find_action_find);
        find.setLayoutData((Object)new GridData(4, 1, true, false));
        find.addListener(13, e -> {
            this.addUserInput();
            this.reverseDirection(e);
            this.find();
        });
        this.replaceFind = new Button(buttonGrid, 8);
        this.replaceFind.setText(Messages.editor_find_action_replacefind);
        this.replaceFind.setEnabled(false);
        this.replaceFind.setLayoutData((Object)new GridData(4, 1, true, false));
        this.replaceFind.addListener(13, e -> {
            this.reverseDirection(e);
            this.replaceFind();
        });
        this.replace = new Button(buttonGrid, 8);
        this.replace.setText(Messages.editor_find_action_replace);
        this.replace.setEnabled(false);
        this.replace.setLayoutData((Object)new GridData(4, 1, false, false));
        this.replace.addListener(13, e -> {
            this.reverseDirection(e);
            this.replace();
        });
        Button replaceAll = new Button(buttonGrid, 8);
        replaceAll.setEnabled(this.getActiveViewer().isEditable());
        replaceAll.setText(Messages.editor_find_action_replace_all);
        replaceAll.setLayoutData((Object)new GridData(4, 1, false, false));
        replaceAll.addListener(13, e -> {
            this.reverseDirection(e);
            this.replaceAll();
        });
        this.getShell().setDefaultButton(find);
        this.getShell().addListener(27, e -> this.setReplaceButtonsEnabled(false));
        return p;
    }

    private void reverseDirection(Event e) {
        this.fControlPressed = (e.stateMask & 0x40000) == 262144;
    }

    private void find() {
        this.fMessage.setText("");
        ITextViewer viewer = this.getActiveViewer();
        if (viewer == null) {
            return;
        }
        IDocument document = viewer.getDocument();
        FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter(document);
        try {
            IRegion region;
            Point selectedRange = viewer.getSelectedRange();
            int startOffset = viewer.getTextWidget().getCaretOffset();
            String currentlySelectedText = null;
            if (selectedRange != null) {
                startOffset = selectedRange.x;
                if (this.getDirection() == FindSearchData.Direction.backward && startOffset > 0) {
                    --startOffset;
                }
                currentlySelectedText = document.get(selectedRange.x, selectedRange.y);
            }
            if (this.matches(currentlySelectedText) && this.getDirection() == FindSearchData.Direction.forward) {
                startOffset += selectedRange.y;
            }
            if ((region = adapter.find(startOffset, this.findData.searchValue, this.getDirection() == FindSearchData.Direction.forward, this.findData.caseSensitive, false, this.findData.regex)) == null && this.findData.wrapSearch) {
                startOffset = this.getDirection() == FindSearchData.Direction.forward ? 0 : document.getLength();
                region = adapter.find(startOffset, this.findData.searchValue, this.getDirection() == FindSearchData.Direction.forward, this.findData.caseSensitive, false, this.findData.regex);
            }
            if (region == null) {
                this.fMessage.setText("String not found");
            } else {
                if (!this.findData.scopeSelected) {
                    viewer.setSelectedRange(region.getOffset(), region.getLength());
                }
                viewer.revealRange(region.getOffset(), region.getLength());
                if (viewer.isEditable()) {
                    this.setReplaceButtonsEnabled(true);
                }
            }
        }
        catch (BadLocationException e) {
            this.logger.error("Find Next action resulted in error,", (Throwable)e);
        }
    }

    private FindSearchData.Direction getDirection() {
        if (this.fControlPressed) {
            return this.findData.direction == FindSearchData.Direction.forward ? FindSearchData.Direction.backward : FindSearchData.Direction.forward;
        }
        return this.findData.direction;
    }

    private boolean matches(String pTextToSearch) {
        if (this.findData.regex) {
            if (this.findData.caseSensitive) {
                return pTextToSearch.matches(this.findData.searchValue);
            }
            return pTextToSearch.matches("(?i)" + this.findData.searchValue);
        }
        if (this.findData.caseSensitive) {
            return this.findData.searchValue.equals(pTextToSearch);
        }
        return this.findData.searchValue.equalsIgnoreCase(pTextToSearch);
    }

    private void setReplaceButtonsEnabled(boolean enabled) {
        this.replace.setEnabled(enabled);
        this.replaceFind.setEnabled(enabled);
    }

    private void replaceFind() {
        this.replace();
        this.find();
    }

    private void replace() {
        ITextViewer viewer = this.getActiveViewer();
        if (viewer == null) {
            return;
        }
        IDocument document = viewer.getDocument();
        try {
            Point selectedRange = viewer.getSelectedRange();
            if (selectedRange.y <= 0) {
                return;
            }
            String textToReplace = document.get(selectedRange.x, selectedRange.y);
            document.replace(selectedRange.x, selectedRange.y, this.getReplaceText(textToReplace));
            this.setReplaceButtonsEnabled(false);
        }
        catch (BadLocationException e) {
            this.logger.error("Replace All resulted in error.", (Throwable)e);
        }
    }

    private String getReplaceText(String pTextToReplace) {
        if (this.findData.regex) {
            return pTextToReplace.replaceAll(this.findData.searchValue, this.findData.replaceValue);
        }
        return this.findData.replaceValue;
    }

    private void replaceAll() {
        ITextViewer viewer = this.getActiveViewer();
        if (viewer == null) {
            return;
        }
        IDocument document = viewer.getDocument();
        try {
            int start = 0;
            int end = document.getLength();
            if (this.findData.scopeSelected) {
                Point selectedRange = viewer.getSelectedRange();
                start = selectedRange.x;
                end = selectedRange.y;
            }
            String text = document.get(start, end);
            if (this.findData.regex) {
                String replacedText = this.getReplaceText(text);
                document.replace(start, end, replacedText);
            } else {
                String replacedText = text.replace(this.findData.searchValue, this.findData.replaceValue);
                document.replace(start, end, replacedText);
            }
            this.setReplaceButtonsEnabled(false);
        }
        catch (BadLocationException e) {
            this.logger.error("Replace All resulted in error.", (Throwable)e);
        }
    }

    public ITextViewer getActiveViewer() {
        if (this.activePart.getObject() == null) {
            return null;
        }
        if (!(this.activePart.getObject() instanceof IFindReplaceSupport)) {
            return null;
        }
        return ((IFindReplaceSupport)this.activePart.getObject()).getViewer();
    }

    protected Control createContents(Composite parent) {
        Control content = super.createContents(parent);
        parent.pack();
        return content;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Point location = new Point(this.newLocationX, this.newLocationY);
        int width = this.preferences.getInt("w", this.getParentShell().getBounds().width / 4);
        int height = this.preferences.getInt("h", this.getParentShell().getBounds().height / 4);
        Rectangle r = new Rectangle(location.x, location.y, width, height);
        if (!this.getShell().getMonitor().getBounds().intersects(r)) {
            r.x = this.getShell().getMonitor().getBounds().x + 100;
            r.y = this.getShell().getMonitor().getBounds().y + 100;
        }
        this.getShell().setBounds(r);
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean close() {
        this.saveUserInput();
        return super.close();
    }

    private void addUserInput() {
        if (this.txtSearchValue.getText() != null && !this.finds.contains(this.txtSearchValue.getText())) {
            this.finds.addFirst(this.txtSearchValue.getText());
            if (this.finds.size() > 10) {
                this.finds.pollLast();
            }
            this.txtSearchValue.setItems(this.finds.toArray(new String[this.finds.size()]));
            this.txtSearchValue.select(0);
        }
        if (this.txtReplaceValue.getText() != null && !this.replaces.contains(this.txtReplaceValue.getText())) {
            this.replaces.addFirst(this.txtReplaceValue.getText());
            if (this.replaces.size() > 10) {
                this.replaces.pollLast();
            }
            this.txtReplaceValue.setItems(this.replaces.toArray(new String[this.replaces.size()]));
            this.txtReplaceValue.select(0);
        }
    }

    private void loadUserInput() {
        String historyReplaces;
        String historyFinds = this.preferences.get(HISTORY_FINDS, null);
        if (historyFinds != null) {
            this.finds.addAll(Arrays.asList(historyFinds.split(HISTORY_ENTRIES_SEPARATOR)));
        }
        if ((historyReplaces = this.preferences.get(HISTORY_REPLACES, null)) != null) {
            this.replaces.addAll(Arrays.asList(historyReplaces.split(HISTORY_ENTRIES_SEPARATOR)));
        }
    }

    private void saveUserInput() {
        this.preferences.put(HISTORY_FINDS, StringUtils.join(this.finds, (String)HISTORY_ENTRIES_SEPARATOR));
        this.preferences.put(HISTORY_REPLACES, StringUtils.join(this.replaces, (String)HISTORY_ENTRIES_SEPARATOR));
        Rectangle parentWindowBounds = this.getParentShell().getBounds();
        Rectangle bounds = this.getShell().getBounds();
        int cfr_ignored_0 = parentWindowBounds.x;
        int cfr_ignored_1 = parentWindowBounds.width;
        int cfr_ignored_2 = bounds.x;
        int cfr_ignored_3 = bounds.y;
        int cfr_ignored_4 = parentWindowBounds.y;
        this.preferences.putInt("x", bounds.x);
        this.preferences.putInt("y", bounds.y);
        this.preferences.putInt("w", bounds.width);
        this.preferences.putInt("h", bounds.height);
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException bse) {
            this.logger.error("Could not save preferences for find/replace dialog.", (Throwable)bse);
        }
    }
}

