/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import java.util.HashMap;
import java.util.List;
import miworkplace.common.model.ContentType;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.SourceMember;
import miworkplace.common.model.StreamFile;
import miworkplace.services.api.IContentTypeRegistry;
import miworkplace.services.api.IDoubleClickExecutor;
import miworkplace.services.api.IDoubleClickServiceProvider;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.osgi.service.log.LogService;

public abstract class AbstractDoubleClickExecutor
implements IDoubleClickExecutor {
    protected LogService logger;
    protected IContentTypeRegistry contentTypeRegistry;

    public void bindContentTypeRegistry(IContentTypeRegistry registry) {
        this.contentTypeRegistry = registry;
    }

    public void unbindContentTypeRegistry(IContentTypeRegistry registry) {
        this.contentTypeRegistry = null;
    }

    public void bindLogService(LogService logger) {
        this.logger = logger;
    }

    public void unbindLogService(LogService logger) {
        this.logger = null;
    }

    public void bindDoubleClickProvider(IDoubleClickServiceProvider service) {
        service.register((IDoubleClickExecutor)this);
    }

    public void unbindDoubleClickProvider(IDoubleClickServiceProvider service) {
        service.deregister((IDoubleClickExecutor)this);
    }

    public void execute(Object obj, EHandlerService handlerService, ECommandService commandService) {
        if (obj instanceof SourceMember || obj instanceof StreamFile) {
            IRemoteObject sourceObject = (IRemoteObject)obj;
            Command command = this.determineCommand(sourceObject, commandService);
            if (command.isDefined()) {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("miworkplace.ui.editor.command.parameter.selection", sourceObject.getPath());
                parameters.put("miworkplace.ui.editor.command.parameter.connection", sourceObject.getConnection().getName());
                parameters.put("miworkplace.ui.editor.command.parameter.readonly", Boolean.FALSE.toString());
                ParameterizedCommand cmd = commandService.createCommand(command.getId(), parameters);
                if (handlerService.canExecute(cmd)) {
                    this.logger.log(4, "Opening source " + sourceObject.getPath() + " with the command " + command.getId());
                    handlerService.executeHandler(cmd);
                } else {
                    this.logger.log(1, "Cannot execute command open source member. Command Id: " + command.getId());
                }
            } else {
                this.logger.log(1, "Command for opening source member is not defined. Command Id: " + command.getId());
            }
        }
    }

    private Command determineCommand(IRemoteObject sourceObject, ECommandService commandService) {
        String commandId = null;
        List contentTypes = this.contentTypeRegistry.getContentType(sourceObject);
        for (ContentType ct : contentTypes) {
            if (!ct.getId().equals(this.getContentTypeId())) continue;
            if (sourceObject instanceof SourceMember) {
                commandId = ct.getCommandId();
                break;
            }
            if (!(sourceObject instanceof StreamFile)) break;
            commandId = ct.getIfsCommandId();
            break;
        }
        if (commandId == null) {
            return null;
        }
        Command command = commandService.getCommand(commandId);
        return command;
    }

    public boolean canExecute(ECommandService commandService, Object object) {
        if (object instanceof SourceMember || object instanceof StreamFile) {
            Command command = this.determineCommand((IRemoteObject)object, commandService);
            if (command == null) {
                return false;
            }
            return command.isDefined();
        }
        return false;
    }

    protected abstract String getContentTypeId();

    public Integer getRanking() {
        return 10;
    }
}

