/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import miworkplace.ui.themes.Colors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

public abstract class AbstractCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
ICompletionProposalExtension4,
ICompletionProposalExtension5,
ICompletionProposalExtension6 {
    protected String code;
    protected String description;
    protected int replacementOffset;
    protected String replacementString;
    protected int cursorPosition;
    private static String cssStyles;
    private String typedValue;

    public AbstractCompletionProposal(String code) {
        this(code, null);
    }

    public AbstractCompletionProposal(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public AbstractCompletionProposal(String code, String description, String typedValue) {
        this.code = code;
        this.description = description;
        this.typedValue = typedValue;
    }

    public String getCode() {
        return this.code;
    }

    public void apply(IDocument document) {
    }

    public String getAdditionalProposalInfo() {
        return this.description;
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        if (this.description == null || this.description.length() == 0) {
            return null;
        }
        RGB foreground = Colors.instance().get(Colors.ColorDefinition.DefaultFont).getRGB();
        RGB background = Colors.instance().get(Colors.ColorDefinition.DefaultBackground).getRGB();
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (RGB)foreground, (RGB)background, (String)this.getCSSStyles());
        buffer.append(this.description);
        HTMLPrinter.addPageEpilog((StringBuffer)buffer);
        String info = buffer.toString();
        return info;
    }

    protected String getCSSStyles() {
        if (cssStyles == null) {
            RGB foreground = Colors.instance().get(Colors.ColorDefinition.DefaultFont).getRGB();
            RGB background = Colors.instance().get(Colors.ColorDefinition.DefaultBackground).getRGB();
            StringBuilder sb = new StringBuilder();
            sb.append("html, body, h1, h2, h3, h4, h5, h6, p, table, td, caption, th, ul, ol, dl, li, dd, dt, pre { ");
            sb.append("background-color: ");
            sb.append(String.format("#%02X%02X%02X; ", background.red, background.green, background.blue));
            sb.append("color: ");
            sb.append(String.format("#%02X%02X%02X; ", foreground.red, foreground.green, foreground.blue));
            sb.append("} ");
            sb.append("pre { font-family: monospace; } ");
            sb.append("div { margin-bottom: 2em; } ");
            cssStyles = sb.toString();
        }
        return cssStyles;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public abstract String getDisplayString();

    public abstract Image getImage();

    public Point getSelection(IDocument document) {
        return new Point(this.getReplacementOffset() + this.getCursorPosition(), 0);
    }

    protected int getCursorPosition() {
        return this.cursorPosition - this.replacementString.length() + this.getApplyString().length();
    }

    protected int getReplacementOffset() {
        return this.replacementOffset;
    }

    public boolean isAutoInsertable() {
        return false;
    }

    public StyledString getStyledDisplayString() {
        return new StyledString(this.getCode());
    }

    public void apply(IDocument document, char trigger, int offset) {
        String currentValue;
        String string = currentValue = this.typedValue == null ? this.computeCurrentValue(document, offset) : this.typedValue;
        if (currentValue != null) {
            try {
                document.replace(offset - currentValue.length(), currentValue.length(), this.getApplyString());
                this.cursorPosition = offset;
                this.replacementString = currentValue;
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        this.apply(viewer.getDocument(), trigger, offset);
    }

    protected String getApplyString() {
        return this.code;
    }

    public int getContextInformationPosition() {
        return -1;
    }

    public char[] getTriggerCharacters() {
        return new char[0];
    }

    public boolean isValidFor(IDocument document, int offset) {
        String currentValue = this.computeCurrentValue(document, offset);
        return this.code.toLowerCase().startsWith(currentValue);
    }

    protected String computeCurrentValue(IDocument document, int offset) {
        try {
            int lineNumber = document.getLineOfOffset(offset);
            int lineOffset = document.getLineOffset(lineNumber);
            String line = document.get(lineOffset, offset - lineOffset);
            int lineLength = line.length();
            int i = lineLength - 1;
            while (i >= 0) {
                char c = line.charAt(i);
                switch (c) {
                    case ' ': 
                    case '(': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '/': 
                    case ':': 
                    case '=': {
                        int valueOffset = i + 1;
                        return lineLength > valueOffset ? line.substring(valueOffset) : "";
                    }
                }
                --i;
            }
            if (lineOffset == offset - line.length()) {
                return line;
            }
        }
        catch (BadLocationException badLocationException) {}
        return "";
    }

    public String toString() {
        return this.code;
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        return this.isValidFor(document, offset);
    }
}

