/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.common.clips;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import miworkplace.common.clips.Clip;
import miworkplace.common.clips.ClipHandler;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.event.Event;

public class ClipsAddon {
    private static final String URL = "https://miworkplace.com/clips.json?cacheFrom=now";
    @Inject
    @Preference(nodePath="miworkplace.application")
    private IEclipsePreferences applicationPreferences;
    private static boolean fIsProcessed;
    private String fIconUri = "platform:/plugin/miworkplace.images/icons/clip.png";
    private boolean fIsProcessing;
    private static Map<String, List<Clip>> fParts;

    private Map<String, List<Clip>> convertData(String data) throws JsonMappingException, JsonProcessingException {
        JsonNode[] nodes;
        HashMap<String, List<Clip>> parts = new HashMap<String, List<Clip>>();
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode[] jsonNodeArray = nodes = (JsonNode[])objectMapper.readValue(data, JsonNode[].class);
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            JsonNode node = jsonNodeArray[n2];
            String key = "";
            Iterator fields = node.fields();
            while (fields.hasNext()) {
                Map.Entry entry = (Map.Entry)fields.next();
                Clip[] px = (Clip[])objectMapper.readValue(((JsonNode)entry.getValue()).toString(), Clip[].class);
                key = (String)entry.getKey();
                parts.put(key, Arrays.asList(px));
            }
            ++n2;
        }
        return parts;
    }

    private String getData() {
        try {
            HttpURLConnection connection;
            if (this.applicationPreferences.getBoolean("miworkplace.ui.general.network.http.proxy", false)) {
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.applicationPreferences.get("miworkplace.ui.general.network.http.proxy.host", "localhost"), this.applicationPreferences.getInt("miworkplace.ui.general.network.http.proxy.port", 3128)));
                connection = (HttpURLConnection)new URL(URL).openConnection(proxy);
            } else {
                connection = (HttpURLConnection)new URL(URL).openConnection();
            }
            connection.setDefaultUseCaches(false);
            connection.setUseCaches(false);
            connection.setRequestProperty("Cache-Control", "no-cache");
            return new String(connection.getInputStream().readAllBytes());
        }
        catch (Exception e) {
            Debug.getInstance().error("Could not read clips from website.", (Throwable)e);
            return null;
        }
    }

    @Inject
    @Optional
    public void partActivated(@EventTopic(value="org/eclipse/e4/ui/LifeCycle/bringToTop") Event event) {
        if (this.fIsProcessing || fIsProcessed && fParts == null) {
            return;
        }
        this.processPart(event);
    }

    private void processPart(Event event) {
        if (event.getProperty("ChangedElement") instanceof MPart) {
            MPart part = (MPart)event.getProperty("ChangedElement");
            if (!fIsProcessed) {
                this.fIsProcessing = true;
                this.fetchLazy(part);
            }
            if (fParts != null) {
                this.processPartToolbar(part);
            }
        }
    }

    private void processPartToolbar(MPart pPart) {
        List<Clip> partClips = fParts.get(pPart.getElementId());
        if (partClips == null) {
            return;
        }
        Debug.getInstance().debug((Option)miworkplace.ui.debug.Option.general, "ClipsAddon started for part toolbar " + pPart.getElementId());
        MDirectToolItem toolItem = null;
        if (pPart.getToolbar() == null) {
            return;
        }
        for (MToolBarElement element : pPart.getToolbar().getChildren()) {
            if (!"clipmenu".equals(element.getElementId())) continue;
            toolItem = (MDirectToolItem)element;
            break;
        }
        if (toolItem != null) {
            pPart.getToolbar().getChildren().remove(toolItem);
        }
        if (fParts == null) {
            return;
        }
        toolItem = this.getToolItemMenu();
        for (Clip clip : partClips) {
            if (!clip.isOnLocation("toolbar")) continue;
            toolItem.getMenu().getChildren().add(this.getItem(clip));
        }
        if (!toolItem.getMenu().getChildren().isEmpty()) {
            pPart.getToolbar().getChildren().add(toolItem);
        }
    }

    private void processPartPopUp(MPart pPart) {
        Debug.getInstance().debug((Option)miworkplace.ui.debug.Option.general, "ClipsAddon started for part popup " + pPart.getElementId());
        if (pPart.getMenus() == null || pPart.getMenus().isEmpty()) {
            return;
        }
        List<MMenu> popupMenus = this.removeClipMenuFromPopup(pPart);
        if (popupMenus == null || popupMenus.size() == 0 || fParts == null || fParts.isEmpty()) {
            return;
        }
        List<Clip> partClips = fParts.get(pPart.getElementId());
        if (partClips != null) {
            for (MMenu popMenu : popupMenus) {
                MMenu clipMenu = this.getMenu();
                for (Clip clip : partClips) {
                    if (!clip.isOnLocation("popup") || !clip.isOnMenu(popMenu.getElementId())) continue;
                    clipMenu.getChildren().add(this.getItem(clip));
                }
                if (clipMenu.getChildren().isEmpty()) continue;
                popMenu.getChildren().add(clipMenu);
            }
        }
    }

    private List<MMenu> removeClipMenuFromPopup(MPart pPart) {
        ArrayList<MMenu> result = new ArrayList<MMenu>();
        for (MMenu popupMenu : pPart.getMenus()) {
            Debug.getInstance().debug((Option)miworkplace.ui.debug.Option.general, "ClipsAddon - removeClipFromPopup" + popupMenu.getElementId() + " popup: " + (popupMenu instanceof MPopupMenu));
            if (popupMenu.getElementId() != null && popupMenu instanceof MPopupMenu && popupMenu.getChildren() != null) {
                while (this.removeClipItems(popupMenu)) {
                }
            }
            result.add(popupMenu);
        }
        return result;
    }

    private boolean removeClipItems(MMenu popupMenu) {
        MMenuElement toolItem = null;
        for (MMenuElement element : popupMenu.getChildren()) {
            if (!"clipmenu".equals(element.getElementId())) continue;
            toolItem = element;
            break;
        }
        if (toolItem != null) {
            popupMenu.getChildren().remove(toolItem);
            return true;
        }
        return false;
    }

    private void fetchLazy(final MPart pPart) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    String data = ClipsAddon.this.getData();
                    fParts = ClipsAddon.this.convertData(data);
                    ((MApplication)pPart.getContext().get(MApplication.class)).getPersistedState().put("miworkplace.common.clips", data);
                }
                catch (Exception e) {
                    Debug.getInstance().error("Could not parse clips from website. Getting local data.", (Throwable)e);
                    String data = (String)((MApplication)pPart.getContext().get(MApplication.class)).getPersistedState().get("miworkplace.common.clips");
                    try {
                        fParts = ClipsAddon.this.convertData(data);
                    }
                    catch (Exception exception) {
                        Debug.getInstance().error("Could not parse clips from local data.", (Throwable)e);
                        fParts = null;
                    }
                }
                fIsProcessed = true;
                ClipsAddon.this.fIsProcessing = false;
            }
        };
        Thread t = new Thread(r, "Fetching Video Clips for part " + pPart.getLabel());
        t.start();
    }

    private MDirectToolItem getToolItemMenu() {
        MDirectToolItem dti = MMenuFactory.INSTANCE.createDirectToolItem();
        dti.setLabel("Clips");
        String symbolicName = FrameworkUtil.getBundle(this.getClass()).getSymbolicName();
        dti.setContributorURI("platform:/plugin/" + symbolicName);
        dti.setContributionURI(MessageFormat.format("bundleclass://{0}/{1}", symbolicName, ClipHandler.class.getName()));
        dti.setElementId("clipmenu");
        dti.setIconURI(this.fIconUri);
        MMenu menu = MMenuFactory.INSTANCE.createMenu();
        menu.setElementId("clipmenu.menu");
        dti.setMenu(menu);
        return dti;
    }

    private MMenu getMenu() {
        MMenu menu = MMenuFactory.INSTANCE.createMenu();
        menu.setLabel("Clips");
        String symbolicName = FrameworkUtil.getBundle(this.getClass()).getSymbolicName();
        menu.setContributorURI("platform:/plugin/" + symbolicName);
        menu.setElementId("clipmenu");
        menu.setIconURI(this.fIconUri);
        return menu;
    }

    private MDirectMenuItem getItem(Clip clip) {
        Debug.getInstance().debug((Option)miworkplace.ui.debug.Option.general, "ClipsAddon - item added for clip " + clip.description);
        MDirectMenuItem item = MMenuFactory.INSTANCE.createDirectMenuItem();
        item.setLabel(clip.description);
        String symbolicName = FrameworkUtil.getBundle(this.getClass()).getSymbolicName();
        item.setContributorURI("platform:/plugin/" + symbolicName);
        item.setContributionURI(MessageFormat.format("bundleclass://{0}/{1}", symbolicName, ClipHandler.class.getName()));
        item.setIconURI(this.fIconUri);
        item.getTransientData().put("clip", clip);
        return item;
    }
}

