/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.script.handler;

import jakarta.inject.Inject;
import java.util.List;
import miworkplace.i18n.Messages;
import miworkplace.ui.editor.script.RecentScriptsListService;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;

public class RecentScriptContributionHandler {
    private final String OPEN_COMMAND_ID = "miworkplace.ui.editor.script.command.open";
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    @Inject
    private RecentScriptsListService recentScriptService;

    @AboutToShow
    public void aboutToShow(List<MMenuElement> items, ESelectionService selectionService) {
        List<String> scriptFilePaths = this.recentScriptService.get();
        if (scriptFilePaths.isEmpty()) {
            MDirectMenuItem item = this.createNoScriptsItem();
            items.add((MMenuElement)item);
        } else {
            MCommand command = this.getCommandInstance("miworkplace.ui.editor.script.command.open");
            for (String filePath : scriptFilePaths) {
                MHandledMenuItem dynamicItem = (MHandledMenuItem)this.modelService.createModelElement(MHandledMenuItem.class);
                dynamicItem.setLabel(FilenameUtils.getName((String)filePath));
                dynamicItem.setCommand(command);
                dynamicItem.getTransientData().put("path", filePath);
                dynamicItem.setTooltip(filePath);
                items.add((MMenuElement)dynamicItem);
            }
        }
    }

    private MCommand getCommandInstance(String commandId) {
        List commands = this.application.getCommands();
        for (MCommand command : commands) {
            if (!command.getElementId().equals(commandId)) continue;
            return command;
        }
        return null;
    }

    private MDirectMenuItem createNoScriptsItem() {
        MDirectMenuItem item = MMenuFactory.INSTANCE.createDirectMenuItem();
        item.setLabel(Messages.editor_script_noscripts);
        item.setEnabled(false);
        item.setVisible(true);
        return item;
    }
}

