/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.script.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import miworkplace.common.ui.ListDialog;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.api.ConsoleEntryType;
import miworkplace.ui.api.IEditor;
import miworkplace.ui.editor.IAstProvider;
import miworkplace.ui.editor.script.EditorLabelProvider;
import miworkplace.ui.editor.script.ScriptView;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class ExecuteScriptHandler {
    @Inject
    private LogService logger;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IResourcePool imagePool;
    private final IEditor NO_EDITOR_SELECTED = new IEditor(){

        public IDocument getDocument() {
            return new Document();
        }

        public ITextViewer getViewer() {
            return null;
        }

        public String getInputUri() {
            return "";
        }

        public boolean isReadOnly() {
            return false;
        }
    };

    @CanExecute
    public boolean canExecute(EPartService partService) {
        ScriptView scriptEditor = this.getScriptView(partService);
        return scriptEditor != null && !this.getVisibleEditorParts(partService).isEmpty();
    }

    @Execute
    public void execute(MPart part, EPartService partService, @Named(value="activeShell") Shell shell) {
        ScriptView scriptEditor = this.getScriptView(partService);
        if (scriptEditor == null) {
            return;
        }
        IEditor activeEditor = this.getActiveEditor(partService, shell);
        if (activeEditor == null) {
            Notifier.info((String)Messages.editor_script_execute, (String)Messages.editor_script_noeditor);
            return;
        }
        if (activeEditor == this.NO_EDITOR_SELECTED) {
            return;
        }
        try {
            this.executeScript(scriptEditor, activeEditor);
        }
        catch (Exception e) {
            this.logger.log(1, "Could not execute script.", (Throwable)e);
            Notifier.error((String)Messages.editor_script_execute, (String)Messages.editor_script_execute_error);
        }
    }

    private ScriptView getScriptView(EPartService partService) {
        Collection parts = partService.getParts();
        for (MPart part : parts) {
            if (part.getObject() == null || !(part.getObject() instanceof ScriptView)) continue;
            return (ScriptView)part.getObject();
        }
        return null;
    }

    private void executeScript(ScriptView scriptEditor, IEditor activeEditor) throws Exception {
        String scriptCode = "";
        Point selectedRange = scriptEditor.getViewer().getSelectedRange();
        scriptCode = selectedRange.y == 0 ? scriptEditor.getEditorContent() : scriptEditor.getDocument().get(selectedRange.x, selectedRange.y);
        StringWriter outputWriter = new StringWriter();
        StringWriter errorWriter = new StringWriter();
        ScriptEngineManager scriptManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptManager.getEngineByName("nashorn");
        scriptEngine.getContext().setWriter(outputWriter);
        scriptEngine.getContext().setErrorWriter(errorWriter);
        try {
            scriptEngine.eval(this.wrapScript(scriptCode));
            final AtomicBoolean documentChanged = new AtomicBoolean(false);
            Object ast = this.getAst(activeEditor);
            Point selection = activeEditor.getViewer().getSelectedRange();
            Document targetCode = new Document(activeEditor.getDocument().get());
            targetCode.addDocumentListener(new IDocumentListener(){

                public void documentChanged(DocumentEvent event) {
                    documentChanged.set(true);
                }

                public void documentAboutToBeChanged(DocumentEvent event) {
                }
            });
            Invocable invocable = (Invocable)((Object)scriptEngine);
            invocable.invokeFunction("main", targetCode, selection, ast);
            if (documentChanged.get()) {
                activeEditor.getDocument().set(targetCode.get());
            }
            HashMap<String, String> eventData = new HashMap<String, String>();
            eventData.put("process", "Script Editor");
            eventData.put("org.eclipse.e4.data", outputWriter.toString());
            eventData.put("type", (String)ConsoleEntryType.Output);
            this.eventBroker.send("miworkplace/ui/console/new", eventData);
            if (errorWriter.getBuffer().length() > 0) {
                eventData = new HashMap();
                eventData.put("process", "Script Editor");
                eventData.put("org.eclipse.e4.data", errorWriter.toString());
                eventData.put("type", (String)ConsoleEntryType.Error);
                this.eventBroker.send("miworkplace/ui/console/new", eventData);
            }
        }
        catch (Exception e) {
            this.logger.log(1, "Could not execute script successfully.", (Throwable)e);
            HashMap<String, Object> eventData = new HashMap<String, Object>();
            eventData.put("process", "Script Editor");
            eventData.put("org.eclipse.e4.data", e.getMessage() + "\n");
            eventData.put("type", ConsoleEntryType.Error);
            this.eventBroker.send("miworkplace/ui/console/new", eventData);
        }
    }

    private Object getAst(IEditor activeEditor) {
        if (activeEditor instanceof IAdaptable) {
            return ((IAdaptable)activeEditor).getAdapter(IAstProvider.class);
        }
        return null;
    }

    private String wrapScript(String script) {
        return "var main = function(document, selection, ast) { " + script + "\n};";
    }

    private IEditor getActiveEditor(EPartService partService, Shell shell) {
        List<IEditor> editorParts = this.getVisibleEditorParts(partService);
        if (editorParts.isEmpty()) {
            return null;
        }
        if (editorParts.size() == 1) {
            return editorParts.get(0);
        }
        return this.selectEditor(shell, editorParts);
    }

    private IEditor selectEditor(Shell shell, List<IEditor> editorParts) {
        IEditor selectedEditor = null;
        ListDialog dialog = new ListDialog(shell);
        dialog.setTitle(Messages.editor_script_select_title);
        dialog.setMessage(Messages.editor_script_select_message);
        dialog.setLabelProvider((ILabelProvider)new EditorLabelProvider(this.imagePool));
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setInput(editorParts);
        if (dialog.open() == 0) {
            Object[] objects = dialog.getResult();
            IEditor iEditor = selectedEditor = objects.length > 0 ? (IEditor)objects[0] : null;
        }
        if (selectedEditor == null) {
            selectedEditor = this.NO_EDITOR_SELECTED;
        }
        return selectedEditor;
    }

    private List<IEditor> getVisibleEditorParts(EPartService partService) {
        ArrayList<IEditor> editors = new ArrayList<IEditor>();
        Collection parts = partService.getParts();
        for (MPart part : parts) {
            if (!part.getProperties().containsKey("miworkplace.editor") || part.getObject() == null || !(part.getObject() instanceof IEditor) || part.getObject() instanceof ScriptView || !partService.isPartVisible(part)) continue;
            editors.add((IEditor)part.getObject());
        }
        return editors;
    }
}

