/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.script;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import miworkplace.common.model.TextAttribute;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.services.api.ITextAttributeService;
import miworkplace.ui.api.IEditor;
import miworkplace.ui.api.Position;
import miworkplace.ui.api.WorkspaceUtil;
import miworkplace.ui.editor.script.RecentScriptsListService;
import miworkplace.ui.themes.Colors;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextOperationTargetExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.json.JSONArray;
import org.json.JSONException;
import org.osgi.service.log.LogService;

public class ScriptView
implements IAdaptable,
IEditor {
    @Inject
    private LogService logger;
    @Inject
    protected UISynchronize sync;
    @Inject
    protected IEventBroker eventBroker;
    @Inject
    protected IEclipseContext context;
    @Inject
    @Preference(nodePath="miworkplace.application")
    protected IEclipsePreferences applicationPreferences;
    @Inject
    private IStylingEngine stylingEngine;
    @Inject
    private ITextAttributeService textAttributeService;
    @Inject
    private MDirtyable dirtyable;
    @Inject
    private RecentScriptsListService recentScriptService;
    private CursorPositionChangedListener cursorPositionChangedListener;
    private Caret defaultCaret;
    private Caret overwriteCaret;
    private SourceViewer viewer;
    private boolean overwriteMode;
    private File scriptFile;
    private MPart part;

    @PostConstruct
    public void postConstruct(Composite parent, MPart part, EMenuService menuService) {
        this.part = part;
        parent.setLayout((Layout)new GridLayout());
        CompositeRuler compositeRuler = new CompositeRuler();
        LineNumberRulerColumn lineNumberRuler = new LineNumberRulerColumn();
        compositeRuler.addDecorator(0, (IVerticalRulerColumn)lineNumberRuler);
        lineNumberRuler.setBackground(Colors.instance().get(Colors.ColorDefinition.SecondaryContent));
        lineNumberRuler.setForeground(Colors.instance().get(Colors.ColorDefinition.Comment));
        int styles = 66306;
        this.viewer = new SourceViewer(parent, (IVerticalRuler)compositeRuler, styles);
        this.setNewDocument();
        this.viewer.getTextWidget().setFont(this.buildFont(this.viewer.getTextWidget().getFont(), parent.getDisplay()));
        this.stylingEngine.setClassname((Object)this.viewer.getTextWidget(), "miworkplace-editor-text");
        this.defaultCaret = this.createDefaultCaret(this.viewer.getTextWidget());
        this.overwriteCaret = this.createOverwriteCaret(this.viewer.getTextWidget());
        this.viewer.getTextWidget().setCaret(this.defaultCaret);
        this.cursorPositionChangedListener = new CursorPositionChangedListener(this.eventBroker);
        this.viewer.getTextWidget().addKeyListener((KeyListener)this.cursorPositionChangedListener);
        this.viewer.getTextWidget().addMouseListener((MouseListener)this.cursorPositionChangedListener);
        EditModeListener editModeListener = new EditModeListener(this.eventBroker);
        this.viewer.getTextWidget().addKeyListener((KeyListener)editModeListener);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.viewer.getControl());
        WorkspaceUtil.setHelp((Widget)parent, (String)"miworkplace.help.MIW: Script Editor");
        menuService.registerContextMenu((Object)this.viewer.getTextWidget(), "miworkplace.ui.editor.script.popupmenu");
    }

    private Caret createDefaultCaret(StyledText textWidget) {
        Caret caret = new Caret((Canvas)textWidget, 0);
        GC graphicsContext = new GC((Drawable)textWidget);
        FontMetrics fontMetrics = graphicsContext.getFontMetrics();
        caret.setBounds(caret.getLocation().x, caret.getLocation().y, 2, fontMetrics.getHeight());
        textWidget.addDisposeListener(e -> caret.dispose());
        graphicsContext.dispose();
        return caret;
    }

    private Caret createOverwriteCaret(StyledText textWidget) {
        Caret caret = new Caret((Canvas)textWidget, 0);
        GC graphicsContext = new GC((Drawable)textWidget);
        FontMetrics fontMetrics = graphicsContext.getFontMetrics();
        caret.setBounds(caret.getLocation().x, caret.getLocation().y, fontMetrics.getAverageCharWidth(), fontMetrics.getHeight());
        graphicsContext.dispose();
        textWidget.addDisposeListener(e -> caret.dispose());
        return caret;
    }

    private Font buildFont(Font defaultFont, Display display) {
        TextAttribute ta = this.textAttributeService.get("miworkplace.ui.pref.text.basic.editor.font");
        try {
            String s;
            if (ta != null && (s = ta.getValue()) != null) {
                JSONArray array = new JSONArray(s);
                FontData[] fontList = new FontData[array.length()];
                int i = 0;
                while (i < array.length()) {
                    fontList[i] = new FontData(array.getString(i));
                    ++i;
                }
                Font f = new Font((Device)display, fontList);
                return f;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return defaultFont;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ITextOperationTarget.class) {
            return this.viewer;
        }
        if (adapter == ITextOperationTargetExtension.class) {
            return this.viewer;
        }
        if (adapter == IRewriteTarget.class) {
            return this.viewer.getRewriteTarget();
        }
        return null;
    }

    private Document setNewDocument() {
        return this.setNewDocument("");
    }

    private Document setNewDocument(String code) {
        Document document = new Document(code);
        document.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                ScriptView.this.dirtyable.setDirty(true);
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        if (this.viewer.getUndoManager() != null) {
            this.viewer.getUndoManager().disconnect();
        }
        TextViewerUndoManager undoManager = new TextViewerUndoManager(1000);
        undoManager.connect((ITextViewer)this.viewer);
        this.viewer.setUndoManager((IUndoManager)undoManager);
        this.viewer.setDocument((IDocument)document);
        return document;
    }

    @Persist
    public void persist(final @Named(value="activeShell") Shell shell) {
        this.sync.syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (ScriptView.this.getScriptFile() == null) {
                        FileDialog saveDialog = new FileDialog(shell, 8192);
                        saveDialog.setText("Save Script");
                        String saveFilePath = saveDialog.open();
                        if (saveFilePath != null) {
                            ScriptView.this.setScriptFile(new File(saveFilePath));
                            FileUtils.write((File)ScriptView.this.scriptFile, (CharSequence)ScriptView.this.getEditorContent());
                        }
                    } else {
                        FileUtils.write((File)ScriptView.this.getScriptFile(), (CharSequence)ScriptView.this.getEditorContent());
                    }
                }
                catch (Exception e) {
                    ScriptView.this.logger.log(1, "Could not save script to file " + String.valueOf(ScriptView.this.getScriptFile()), (Throwable)e);
                    Notifier.error((String)Messages.editor_script_save, (String)Messages.editor_script_save_error);
                }
                ScriptView.this.dirtyable.setDirty(false);
            }
        });
    }

    public String getEditorContent() {
        return this.viewer.getDocument().get();
    }

    public void setEditorContent(File scriptFile, String content) {
        this.setScriptFile(scriptFile);
        this.setNewDocument(content);
        this.dirtyable.setDirty(false);
    }

    public void newScript() {
        this.setEditorContent(null, "");
        this.part.setTooltip(null);
        this.dirtyable.setDirty(false);
    }

    public ITextViewer getViewer() {
        return this.viewer;
    }

    public String getInputUri() {
        if (this.scriptFile != null) {
            return this.scriptFile.getAbsolutePath();
        }
        return "miworkplace.ui.editor.script";
    }

    public boolean isReadOnly() {
        return false;
    }

    public IDocument getDocument() {
        return this.viewer.getDocument();
    }

    public boolean isOverwriteMode() {
        return this.overwriteMode;
    }

    public void setScriptFile(File file) {
        this.scriptFile = file;
        if (this.scriptFile != null) {
            this.recentScriptService.add(this.scriptFile.getAbsolutePath());
            this.part.setTooltip(file.getAbsolutePath());
        }
    }

    public File getScriptFile() {
        return this.scriptFile;
    }

    public void setOverwriteMode(boolean overwriteMode) {
        this.overwriteMode = overwriteMode;
    }

    class CursorPositionChangedListener
    implements KeyListener,
    MouseListener {
        private IEventBroker eventBroker;

        public CursorPositionChangedListener(IEventBroker eventBroker) {
            this.eventBroker = eventBroker;
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            StyledText source = (StyledText)e.getSource();
            this.sendPositionUpdate(source);
        }

        public void mouseUp(MouseEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            StyledText source = (StyledText)e.getSource();
            this.sendPositionUpdate(source);
        }

        public void keyReleased(KeyEvent e) {
        }

        public void sendPositionUpdate(StyledText widget) {
            Point selection = widget.getSelection();
            if (selection != null) {
                int x = selection.x;
                int y = widget.getLineAtOffset(x);
                int offsetAtLine = widget.getOffsetAtLine(y);
                this.sendEvent((x -= offsetAtLine) + 1, y + 1);
            }
        }

        private void sendEvent(int x, int y) {
            this.eventBroker.post("miworkplace/ui/editor/position/changed", (Object)new Position(x, y));
        }
    }

    class EditModeListener
    implements KeyListener {
        private final IEventBroker eventBroker;

        public EditModeListener(IEventBroker eventBroker) {
            this.eventBroker = eventBroker;
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 0x1000009) {
                ScriptView.this.setOverwriteMode(!ScriptView.this.isOverwriteMode());
                this.eventBroker.post("miworkplace/ui/editor/overwrite/changed", (Object)(ScriptView.this.isOverwriteMode() ? Boolean.TRUE : Boolean.FALSE));
                this.changeCaretPresentation(ScriptView.this.isOverwriteMode());
            }
        }

        private void changeCaretPresentation(boolean overwriteMode) {
            if (overwriteMode) {
                ScriptView.this.viewer.getTextWidget().setCaret(ScriptView.this.overwriteCaret);
            } else {
                ScriptView.this.viewer.getTextWidget().setCaret(ScriptView.this.defaultCaret);
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }
}

