/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.text;

import jakarta.inject.Inject;
import java.util.Vector;
import miworkplace.ui.editor.rpg.Activator;
import miworkplace.ui.editor.rpg.text.TagRule;
import miworkplace.ui.editor.rpg.text.TodoRule;
import miworkplace.ui.themes.Colors;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;

public class MultiLineScanner
extends RuleBasedScanner {
    private static final String ILEDOCS_TAG_PREFIX = "miworkplace.iledocs.pref.prefix";
    private static final String TASK_TAGS = "miworkplace.ui.editor.tasktags";
    private static final String TASK_TAGS_CASE = "miworkplace.ui.editor.tasktags.casesensitive";

    @Inject
    public MultiLineScanner(@Preference(nodePath="miworkplace.application") IEclipsePreferences applicationPreferences) {
        String iledocsPrefix = applicationPreferences.get(ILEDOCS_TAG_PREFIX, "@");
        boolean taskTagsCaseSensitive = applicationPreferences.getBoolean(TASK_TAGS_CASE, false);
        String[] taskTags = applicationPreferences.get(TASK_TAGS, "").split(",");
        Token iledocsToken = new Token((Object)new TextAttribute(Colors.instance().get(Colors.ColorDefinition.IledocsBlock)));
        Token htmlToken = new Token((Object)new TextAttribute(Colors.instance().get(Colors.ColorDefinition.Html)));
        PreferenceStore prefs = Activator.getDefault().getSyntaxHighlightingPreferenceStore();
        Vector<Object> rules = new Vector<Object>();
        rules.add(new SingleLineRule("<", ">", (IToken)htmlToken));
        rules.add((Object)new TagRule(iledocsPrefix, (IPreferenceStore)prefs));
        rules.add((Object)new TodoRule(taskTags, taskTagsCaseSensitive));
        this.setRules(rules.toArray(new IRule[rules.size()]));
        this.setDefaultReturnToken((IToken)iledocsToken);
    }
}

