/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.pref;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import miworkplace.i18n.Messages;
import miworkplace.ui.editor.rpg.pref.IncludePathEditingSupport;
import miworkplace.ui.pref.api.PreferenceNode;
import miworkplace.ui.pref.api.PreferencePage;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

class IncludePathPreferencePage
extends PreferencePage {
    private List<String> paths = new ArrayList<String>();
    private PreferenceNode node;
    private TableViewer viewer;

    public IncludePathPreferencePage(Composite parent, PreferenceNode node, IEclipsePreferences preferences) {
        super(parent, 0);
        this.node = node;
        this.loadPreferences(preferences);
        this.setLayout((Layout)new FillLayout());
        this.init((Composite)this);
    }

    private void init(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 20;
        layout.marginWidth = 25;
        form.getBody().setLayout((Layout)layout);
        form.setText(this.node.getName());
        FormData layoutData = new FormData();
        Label l1 = toolkit.createLabel(form.getBody(), this.node.getName() + ":");
        l1.setLayoutData((Object)layoutData);
        layoutData = new FormData();
        layoutData.left = new FormAttachment((Control)l1, 0, 16384);
        layoutData.bottom = new FormAttachment(100, -15);
        Button addPath = toolkit.createButton(form.getBody(), Messages.editor_pref_include_path_add, 8);
        addPath.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String path;
                InputDialog dialog = new InputDialog(IncludePathPreferencePage.this.getShell(), Messages.editor_pref_include_path_add, Messages.editor_pref_include_path_add_desc, null, null);
                if (dialog.open() == 0 && !IncludePathPreferencePage.this.paths.contains(path = dialog.getValue())) {
                    IncludePathPreferencePage.this.paths.add(path);
                    IncludePathPreferencePage.this.viewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        addPath.setLayoutData((Object)layoutData);
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)l1, 10);
        layoutData.left = new FormAttachment((Control)l1, 0, 16384);
        layoutData.right = new FormAttachment(100);
        layoutData.bottom = new FormAttachment((Control)addPath, -15, 128);
        this.viewer = new TableViewer(form.getBody(), 2560);
        this.viewer.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.viewer.getTable().setHeaderVisible(false);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider());
        this.viewer.setInput(this.paths);
        this.viewer.getTable().setLayoutData((Object)layoutData);
        TableViewerColumn c = new TableViewerColumn(this.viewer, 0);
        c.getColumn().setWidth(200);
        c.getColumn().setText(Messages.editor_pref_task_tag);
        c.setEditingSupport((EditingSupport)new IncludePathEditingSupport(this.viewer, this.paths));
        c.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(cell.getElement().toString());
            }
        });
        toolkit.paintBordersFor(form.getBody());
    }

    private void loadPreferences(IEclipsePreferences preferences) {
        String paths = preferences.get("miworkplace.ui.editor.include.path", "");
        if (StringUtils.isNotEmpty((CharSequence)paths)) {
            this.paths.addAll(Arrays.asList(paths.split(":")));
        }
    }

    public boolean isValid() {
        return true;
    }

    public void save(IEclipsePreferences preferences) {
        preferences.put("miworkplace.ui.editor.include.path", StringUtils.join(this.paths, (String)":"));
    }
}

