/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Arrays;
import java.util.LinkedList;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.StreamFile;
import miworkplace.services.api.ILastUsedEditorService;
import miworkplace.ui.explorer.api.AbstractOpenStreamFileHandler;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.IStructuredSelection;

public class OpenWithRpgStreamfileEditorHandler
extends AbstractOpenStreamFileHandler {
    private static final String OPEN_COMMAND_ID = "miworkplace.ui.editor.rpg.command.ifs.open.with";
    @Inject
    private ILastUsedEditorService lastUsedEditorService;
    private EPartService partService;
    private MApplication application;
    private ESelectionService selectionService;
    private EModelService modelService;

    @Execute
    public void execute(EPartService partService, MApplication application, ESelectionService selectionService, EModelService modelService, @Optional @Named(value="miworkplace.ui.editor.command.parameter.selection") String ifsPath, @Optional @Named(value="miworkplace.ui.editor.command.parameter.connection") String connectionName, @Optional @Named(value="miworkplace.ui.editor.command.parameter.readonly") String sReadOnly) {
        this.partService = partService;
        this.application = application;
        this.selectionService = selectionService;
        this.modelService = modelService;
        if (ifsPath != null) {
            boolean readOnly = sReadOnly == null ? false : Boolean.valueOf(sReadOnly);
            IConnection connection = this.getConnectionManager().get(connectionName);
            StreamFile streamFile = (StreamFile)this.getWorkspaceStore().get(connection, ifsPath);
            this.open(Arrays.asList(streamFile), !readOnly);
            this.lastUsedEditorService.setCommandId(streamFile.getConnection().getName(), streamFile.getPath(), OPEN_COMMAND_ID);
        } else {
            Object selection = selectionService.getSelection();
            if (selection != null) {
                LinkedList<StreamFile> files = new LinkedList<StreamFile>();
                IStructuredSelection ss = (IStructuredSelection)selection;
                for (Object obj : ss) {
                    if (!(obj instanceof StreamFile)) continue;
                    StreamFile streamFile = (StreamFile)obj;
                    files.add(streamFile);
                    this.lastUsedEditorService.setCommandId(streamFile.getConnection().getName(), streamFile.getPath(), OPEN_COMMAND_ID);
                }
                this.open(files);
            }
        }
    }

    protected String getContributionURI() {
        return "bundleclass://miworkplace.ui.editor.rpg/miworkplace.ui.editor.rpg.RpgStreamFileEditor";
    }

    public String getEditorPartDescriptorId() {
        return "miworkplace.ui.editor.rpg.partdescriptor.stmf";
    }

    protected EPartService getPartService() {
        return this.partService;
    }

    protected EModelService getModelService() {
        return this.modelService;
    }

    protected MApplication getApplication() {
        return this.application;
    }

    protected ESelectionService getSelectionService() {
        return this.selectionService;
    }
}

