/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.free;

import miworkplace.ui.editor.IToggleCommentAdapter;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.graphics.Point;

public class ToggleCommentAdapter
implements IToggleCommentAdapter {
    public void toggleComment(TextViewer viewer) throws Exception {
        IRewriteTarget rewriteTarget = viewer.getRewriteTarget();
        IDocument document = viewer.getDocument();
        Point selectedRange = viewer.getSelectedRange();
        int startOffet = selectedRange.x;
        int endOffset = selectedRange.x + selectedRange.y;
        int startLine = document.getLineOfOffset(startOffet);
        int endLine = document.getLineOfOffset(endOffset);
        rewriteTarget.beginCompoundChange();
        try {
            ToggleOperation op = this.determineToggleOperation(document, startLine, endLine);
            int line = startLine;
            do {
                IRegion lineInformation = document.getLineInformation(line);
                String lineText = document.get(lineInformation.getOffset(), lineInformation.getLength());
                String newLine = null;
                newLine = op == ToggleOperation.comment ? this.commentLine(lineText) : this.uncomment(lineText);
                if (newLine == null) continue;
                document.replace(lineInformation.getOffset(), lineInformation.getLength(), newLine);
            } while (++line <= endLine);
        }
        finally {
            rewriteTarget.endCompoundChange();
        }
    }

    private String uncomment(String lineText) {
        int x = lineText.indexOf("//");
        if (x == -1) {
            return lineText;
        }
        StringBuilder sb = new StringBuilder(lineText);
        if (x == 0) {
            sb.delete(0, 2);
            if (sb.length() > 0 && sb.charAt(0) == ' ') {
                sb.deleteCharAt(0);
            }
        } else {
            sb.delete(x, x + 2);
        }
        return sb.toString();
    }

    private String commentLine(String lineText) {
        return "// " + lineText;
    }

    private ToggleOperation determineToggleOperation(IDocument document, int startLine, int endLine) throws Exception {
        ToggleOperation op = null;
        int line = startLine;
        do {
            IRegion lineInformation;
            String lineText;
            int x;
            op = (x = (lineText = document.get((lineInformation = document.getLineInformation(line)).getOffset(), lineInformation.getLength())).indexOf("//")) == -1 ? ToggleOperation.comment : (x == 0 ? (op == null || op == ToggleOperation.uncomment ? ToggleOperation.uncomment : op) : (StringUtils.isBlank((CharSequence)lineText.substring(0, x)) ? (op == null || op == ToggleOperation.uncomment ? ToggleOperation.uncomment : op) : ToggleOperation.comment));
        } while (++line <= endLine);
        return op == null ? ToggleOperation.comment : op;
    }

    private static enum ToggleOperation {
        comment,
        uncomment;

    }
}

