/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.fixed;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import miworkplace.ast.rpg.AST;
import miworkplace.ast.rpg.Subroutine;
import miworkplace.ui.editor.rpg.OutlineCategories;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class OutlineContentProvider
implements ITreeContentProvider {
    @Inject
    @Optional
    @Named(value="pepLine")
    private Integer pepline;
    private final Object[] nullElements = new Object[0];
    private AST ast;

    public Object[] getChildren(Object parentElement) {
        if (parentElement == this.ast) {
            return this.composeCategories(this.ast);
        }
        if (parentElement.equals((Object)OutlineCategories.Files)) {
            return this.ast.getFiles().toArray();
        }
        if (parentElement.equals((Object)OutlineCategories.Procedures)) {
            return this.ast.getProcedures();
        }
        if (parentElement.equals((Object)OutlineCategories.Subroutines)) {
            return this.ast.getSubroutines().toArray(new Subroutine[0]);
        }
        if (parentElement.equals((Object)OutlineCategories.Prototypes)) {
            return this.ast.getPrototypes();
        }
        if (parentElement.equals((Object)OutlineCategories.Includes)) {
            return this.ast.getIncludes();
        }
        return this.nullElements;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof AST) {
            this.ast = (AST)newInput;
        }
    }

    private OutlineCategories[] composeCategories(AST ast) {
        ArrayList<OutlineCategories> categories = new ArrayList<OutlineCategories>();
        if (ast.getPrototypes().length > 0) {
            categories.add(OutlineCategories.Prototypes);
        }
        if (ast.getFiles().size() > 0) {
            categories.add(OutlineCategories.Files);
        }
        if (ast.getIncludes().length > 0) {
            categories.add(OutlineCategories.Includes);
        }
        if (ast.getProcedures().length > 0) {
            categories.add(OutlineCategories.Procedures);
        }
        if (!ast.getSubroutines().isEmpty()) {
            categories.add(OutlineCategories.Subroutines);
        }
        if (this.pepline != null) {
            categories.add(OutlineCategories.PEP);
        }
        return categories.toArray(new OutlineCategories[categories.size()]);
    }
}

