/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.contentassist;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import miworkplace.ast.rpg.AST;
import miworkplace.common.Constants;
import miworkplace.common.EditorInputUriUtil;
import miworkplace.ui.editor.AbstractCompletionProposal;
import miworkplace.ui.editor.ColoredStyler;
import miworkplace.ui.editor.CompletionProposalComparator;
import miworkplace.ui.editor.ILEDocsProvider;
import miworkplace.ui.editor.ITemplateService;
import miworkplace.ui.editor.Template;
import miworkplace.ui.editor.TemplateCompletionProposal;
import miworkplace.ui.editor.TemplateContext;
import miworkplace.ui.editor.include.IIncludeService;
import miworkplace.ui.editor.include.IncludeData;
import miworkplace.ui.editor.rpg.ResolvedAst;
import miworkplace.ui.editor.rpg.ast.AbstractVariable;
import miworkplace.ui.editor.rpg.ast.Ast;
import miworkplace.ui.editor.rpg.ast.Constant;
import miworkplace.ui.editor.rpg.ast.DataStructure;
import miworkplace.ui.editor.rpg.ast.Include;
import miworkplace.ui.editor.rpg.ast.Module;
import miworkplace.ui.editor.rpg.ast.Parameter;
import miworkplace.ui.editor.rpg.ast.Procedure;
import miworkplace.ui.editor.rpg.ast.Prototype;
import miworkplace.ui.editor.rpg.ast.Subroutine;
import miworkplace.ui.editor.rpg.ast.Variable;
import miworkplace.ui.editor.rpg.contentassist.CompletionProposalFactory;
import miworkplace.ui.editor.rpg.contentassist.ConstantCompletionProposal;
import miworkplace.ui.editor.rpg.contentassist.FreePrototypeCompletionProposal;
import miworkplace.ui.editor.rpg.contentassist.ProcedureCompletionProposal;
import miworkplace.ui.editor.rpg.contentassist.SubroutineCompletionProposal;
import miworkplace.ui.editor.rpg.contentassist.VariableCompletionProposal;
import miworkplace.ui.editor.rpg.text.DescriptionBuilder;
import miworkplace.ui.themes.Colors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.osgi.service.event.Event;
import org.osgi.service.log.LogService;

public class FreeCompletionProcessor
implements IContentAssistProcessor {
    @Inject
    private LogService logger;
    @Inject
    private ITemplateService templateService;
    @Inject
    private IResourcePool imagePool;
    @Inject
    private TemplateContext templateContext;
    @Inject
    @Named(value="inputUri")
    private String inputUri;
    @Inject
    @Preference(nodePath="miworkplace.application")
    private IEclipsePreferences applicationPreferences;
    @Inject
    private IIncludeService includeService;
    @Inject
    private ILEDocsProvider iledocsProvider;
    @Inject
    private IEclipseContext context;
    private DescriptionBuilder descriptionBuilder = new DescriptionBuilder();
    private CompletionProposalFactory completionProposalFactory;
    private String connectionName;
    private String ifsPath;
    private Image image;
    private StyledString.Styler stylerName;
    private StyledString.Styler stylerDescription;
    private List<AbstractCompletionProposal> templateProposals = new ArrayList<AbstractCompletionProposal>();
    private Image varIcon;
    private Image dsIcon;
    private Image constantIcon;
    private Image subrIcon;
    private Image procIcon;
    private Image protoIcon;
    private Object ast;
    private ResolvedAst resolvedAst;

    @PostConstruct
    private void postConstruct() {
        this.connectionName = EditorInputUriUtil.getConnectionName((String)this.inputUri);
        this.ifsPath = EditorInputUriUtil.getMemberPath((String)this.inputUri);
        this.image = this.imagePool.getImageUnchecked("IMAGE_TEMPLATE");
        this.stylerName = new ColoredStyler(Colors.instance().get(Colors.ColorDefinition.DefaultFont));
        this.stylerDescription = new ColoredStyler(Colors.instance().get(Colors.ColorDefinition.Comment));
        this.varIcon = this.imagePool.getImageUnchecked("IMAGE_OUTLINE_VARIABLE");
        this.dsIcon = this.imagePool.getImageUnchecked("IMAGE_OUTLINE_DATA_STRUCTURE");
        this.constantIcon = this.imagePool.getImageUnchecked("IMAGE_OUTLINE_CONSTANT");
        this.subrIcon = this.imagePool.getImageUnchecked("IMAGE_OUTLINE_SUBROUTINE");
        this.procIcon = this.imagePool.getImageUnchecked("IMAGE_OUTLINE_PROC_PRIVATE");
        this.protoIcon = this.imagePool.getImageUnchecked("IMAGE_OUTLINE_PROTOTYPE");
        this.completionProposalFactory = new CompletionProposalFactory(this.logger, this.determineContentAssistCase());
        IEclipseContext childContext = this.context.createChild();
        childContext.set("ifsPath", (Object)this.ifsPath);
        childContext.set("connection", (Object)this.connectionName);
        this.resolvedAst = (ResolvedAst)((Object)ContextInjectionFactory.make(ResolvedAst.class, (IEclipseContext)childContext));
        this.loadTemplates();
    }

    private Constants.ContentAssistCase determineContentAssistCase() {
        boolean convertCase = this.applicationPreferences.getBoolean("miworkplace.ui.editor.content.assist.convert.case", false);
        if (convertCase) {
            String caCase = this.applicationPreferences.get("miworkplace.ui.editor.content.assist.case", Constants.ContentAssistCase.lowercase.name());
            return Constants.ContentAssistCase.valueOf((String)caCase);
        }
        return null;
    }

    private void loadTemplates() {
        for (Template template : this.templateService.get()) {
            if (!template.getContext().equals("RPG")) continue;
            TemplateCompletionProposal proposal = new TemplateCompletionProposal(template, this.image, this.stylerName, this.stylerDescription, this.templateContext);
            this.templateProposals.add((AbstractCompletionProposal)proposal);
        }
    }

    @Inject
    @Optional
    public void notifiedTemplatesPersisted(@UIEventTopic(value="miworkplace/ui/editor/template/persisted") Event event) {
        this.templateProposals.clear();
        this.loadTemplates();
    }

    @Inject
    @Optional
    public void notifiedAstRebuild(@UIEventTopic(value="miworkplace/editor/reconciled") Event event) {
        if (this.inputUri.equals(event.getProperty("inputUri"))) {
            this.ast = event.getProperty("org.eclipse.e4.data");
            if (this.ast instanceof Ast) {
                this.resolvedAst.setAst((Ast)this.ast);
            } else {
                this.resolvedAst.setAst(null);
            }
        }
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ArrayList<Object> proposals = new ArrayList<Object>();
        String typedValue = this.computeCurrentValue(viewer.getDocument(), offset);
        if (this.ast instanceof Ast) {
            Procedure scope = ((Ast)this.ast).getScope(offset);
            if (typedValue.contains(".") && !typedValue.startsWith(".")) {
                proposals.addAll(this.buildDataStructureProposals(typedValue, this.resolvedAst, scope));
            } else {
                proposals.addAll(this.buildProposals(viewer, offset, typedValue, this.resolvedAst, scope));
            }
        } else {
            for (AbstractCompletionProposal proposal : this.templateProposals) {
                if (!proposal.isValidFor(viewer.getDocument(), offset)) continue;
                proposals.add(proposal);
            }
            proposals.addAll(Arrays.asList(this.completionProposalFactory.getCompletionProposals(this.ast instanceof AST ? (AST)this.ast : null)));
        }
        Collections.sort(proposals, new CompletionProposalComparator());
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private List<ICompletionProposal> buildProposals(ITextViewer viewer, int offset, String typedValue, Ast freeAst, Procedure scope) {
        String description;
        String description2;
        String description3;
        List<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        proposals.addAll(Arrays.asList(this.completionProposalFactory.getCompletionProposals(this.ast instanceof AST ? (AST)this.ast : null)));
        List constants = freeAst.listConstants();
        for (Constant constant : constants) {
            String description4 = this.descriptionBuilder.build(constant, freeAst, scope, this.iledocsProvider.getConstant(this.connectionName, this.ifsPath, constant.name.value, this.getQualifiedIncludePaths(freeAst)));
            proposals.add((ICompletionProposal)new ConstantCompletionProposal(constant, this.constantIcon, description4));
        }
        if (scope != null) {
            List localConstants = scope.listConstants();
            for (Constant constant : localConstants) {
                description3 = this.descriptionBuilder.build(constant, freeAst, scope, this.iledocsProvider.getConstant(this.connectionName, this.ifsPath, constant.name.value, this.getQualifiedIncludePaths(freeAst)));
                proposals.add((ICompletionProposal)new ConstantCompletionProposal(constant, this.constantIcon, description3));
            }
        }
        List variables = freeAst.listVariables();
        for (AbstractVariable variable : variables) {
            if (variable instanceof Variable) {
                description3 = this.descriptionBuilder.build((Variable)variable, freeAst, scope, this.iledocsProvider.getVariable(this.connectionName, this.ifsPath, variable.getName(), this.getQualifiedIncludePaths(freeAst)));
                proposals.add((ICompletionProposal)new VariableCompletionProposal(variable, this.varIcon, null, description3));
                continue;
            }
            if (!(variable instanceof DataStructure)) continue;
            String description32 = this.descriptionBuilder.build((DataStructure)variable, freeAst, scope, this.iledocsProvider.getVariable(this.connectionName, this.ifsPath, variable.getName(), this.getQualifiedIncludePaths(freeAst)));
            proposals.add((ICompletionProposal)new VariableCompletionProposal(variable, this.dsIcon, null, description32));
            if (((DataStructure)variable).isQualified()) continue;
            List<Object> subfields = this.getDataStructureSubfields(freeAst, scope, (DataStructure)variable);
            for (Object subfield : subfields) {
                AbstractVariable subvar = (AbstractVariable)subfield;
                proposals.add((ICompletionProposal)new VariableCompletionProposal(subvar, this.varIcon));
            }
        }
        if (scope != null) {
            List localVariables = scope.listVariables();
            for (AbstractVariable variable : localVariables) {
                if (variable instanceof Variable) {
                    String description22 = this.descriptionBuilder.build((Variable)variable, freeAst, scope, this.iledocsProvider.getVariable(this.connectionName, this.ifsPath, variable.getName(), this.getQualifiedIncludePaths(freeAst)));
                    proposals.add((ICompletionProposal)new VariableCompletionProposal(variable, this.varIcon, null, description22));
                    continue;
                }
                if (!(variable instanceof DataStructure)) continue;
                description2 = this.descriptionBuilder.build((DataStructure)variable, freeAst, scope, this.iledocsProvider.getVariable(this.connectionName, this.ifsPath, variable.getName(), this.getQualifiedIncludePaths(freeAst)));
                proposals.add((ICompletionProposal)new VariableCompletionProposal(variable, this.dsIcon, null, description2));
                if (((DataStructure)variable).isQualified()) continue;
                List<Object> subfields = this.getDataStructureSubfields(freeAst, scope, (DataStructure)variable);
                for (Object e : subfields) {
                    AbstractVariable subvar = (AbstractVariable)e;
                    proposals.add((ICompletionProposal)new VariableCompletionProposal(subvar, this.varIcon));
                }
            }
            for (Parameter parameter : scope.getProcedureInterface().getParameters()) {
                if (!(parameter instanceof AbstractVariable)) continue;
                AbstractVariable variable = (AbstractVariable)parameter;
                if (variable instanceof Variable) {
                    description = this.descriptionBuilder.build((Variable)variable, freeAst, scope, this.iledocsProvider.getVariable(this.connectionName, this.ifsPath, variable.getName(), this.getQualifiedIncludePaths(freeAst)));
                    proposals.add((ICompletionProposal)new VariableCompletionProposal(variable, this.varIcon, null, description));
                    continue;
                }
                if (!(variable instanceof DataStructure)) continue;
                description = this.descriptionBuilder.build((DataStructure)variable, freeAst, scope, this.iledocsProvider.getVariable(this.connectionName, this.ifsPath, variable.getName(), this.getQualifiedIncludePaths(freeAst)));
                proposals.add((ICompletionProposal)new VariableCompletionProposal(variable, this.dsIcon, null, description));
                if (((DataStructure)variable).isQualified()) continue;
                List<Object> list = this.getDataStructureSubfields(freeAst, scope, (DataStructure)variable);
                for (Object subfield : list) {
                    AbstractVariable subvar = (AbstractVariable)subfield;
                    proposals.add((ICompletionProposal)new VariableCompletionProposal(subvar, this.varIcon));
                }
            }
        }
        if (this.ast instanceof Module) {
            List procedures = ((Module)this.ast).listProcedures();
            for (Procedure procedure : procedures) {
                description2 = this.descriptionBuilder.build(procedure, this.iledocsProvider.getProcedure(this.connectionName, this.ifsPath, procedure.getName(), this.getQualifiedIncludePaths(freeAst)));
                proposals.add((ICompletionProposal)new ProcedureCompletionProposal(procedure, this.procIcon, description2));
            }
        }
        if (scope == null) {
            List subroutines = freeAst.listSubroutines();
            for (Subroutine subroutine : subroutines) {
                proposals.add((ICompletionProposal)new SubroutineCompletionProposal(subroutine, this.subrIcon));
            }
        } else {
            List localSubroutines = scope.listSubroutines();
            for (Subroutine subroutine : localSubroutines) {
                proposals.add((ICompletionProposal)new SubroutineCompletionProposal(subroutine, this.subrIcon));
            }
        }
        List prototypes = freeAst.listPrototypes();
        for (Prototype prototype : prototypes) {
            description2 = this.descriptionBuilder.build(prototype, scope, this.iledocsProvider.getProcedure(this.connectionName, this.ifsPath, prototype.getName(), this.getQualifiedIncludePaths(freeAst)));
            proposals.add((ICompletionProposal)new FreePrototypeCompletionProposal(prototype, this.protoIcon, description2));
        }
        if (scope != null) {
            List localPrototypes = scope.listPrototypes();
            for (Prototype prototype : localPrototypes) {
                description = this.descriptionBuilder.build(prototype, scope, this.iledocsProvider.getProcedure(this.connectionName, this.ifsPath, prototype.getName(), this.getQualifiedIncludePaths(freeAst)));
                proposals.add((ICompletionProposal)new FreePrototypeCompletionProposal(prototype, this.protoIcon, description));
            }
        }
        proposals = this.filterProposals(typedValue, proposals);
        for (AbstractCompletionProposal proposal : this.templateProposals) {
            if (!proposal.isValidFor(viewer.getDocument(), offset)) continue;
            proposals.add((ICompletionProposal)proposal);
        }
        return proposals;
    }

    private List<ICompletionProposal> buildDataStructureProposals(String typedValue, Ast freeAst, Procedure scope) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        String[] parts = typedValue.split("\\.");
        String subfieldPrefix = "";
        if (typedValue.endsWith(".")) {
            String cfr_ignored_0 = parts[parts.length - 1];
        } else {
            String cfr_ignored_1 = parts[parts.length - 2];
            subfieldPrefix = parts[parts.length - 1];
        }
        DataStructure ds = null;
        ds = this.resolveDataStructureByName(freeAst, scope, parts, typedValue);
        if (ds != null && this.isDataStrutureQualified(freeAst, scope, ds)) {
            for (Object sf : this.getDataStructureSubfields(freeAst, scope, ds)) {
                AbstractVariable subfield;
                if (!(sf instanceof AbstractVariable) || (subfield = (AbstractVariable)sf).getName() == null || !subfield.getName().toLowerCase().startsWith(subfieldPrefix)) continue;
                if (subfield instanceof Variable) {
                    proposals.add((ICompletionProposal)new VariableCompletionProposal(subfield, this.varIcon, subfieldPrefix));
                    continue;
                }
                if (!(subfield instanceof DataStructure)) continue;
                proposals.add((ICompletionProposal)new VariableCompletionProposal(subfield, this.dsIcon, subfieldPrefix));
            }
        }
        return proposals;
    }

    protected boolean isDataStrutureQualified(Ast ast, Procedure scope, DataStructure ds) {
        DataStructure likeds;
        if (ds.getLike() != null && (likeds = this.resolveDataStructureByName(ast, scope, ds.getLike())) != null) {
            ds = likeds;
        }
        return ds.isQualified();
    }

    protected List<Object> getDataStructureSubfields(Ast ast, Procedure scope, DataStructure ds) {
        DataStructure likeds;
        if (ds.getLike() != null && (likeds = this.resolveDataStructureByName(ast, scope, ds.getLike())) != null) {
            ds = likeds;
        }
        return ds.getSubfields();
    }

    private DataStructure resolveDataStructureByName(Ast freeAst, Procedure procedure, String[] typedParts, String typedValue) {
        DataStructure ds = this.resolveDataStructureByName(freeAst, procedure, typedParts[0]);
        if (ds != null) {
            int length;
            int n = length = typedValue.endsWith(".") ? typedParts.length : typedParts.length - 1;
            if (length <= 1) {
                return ds;
            }
            int i = 1;
            while (i <= length - 1) {
                if ((ds = this.findSubfieldParent(freeAst, procedure, ds, typedParts[i])) == null) break;
                if (i == length - 1) {
                    return ds;
                }
                ++i;
            }
        }
        return null;
    }

    private DataStructure findSubfieldParent(Ast freeAst, Procedure scope, DataStructure ds, String subfieldName) {
        for (Object sf : this.getDataStructureSubfields(freeAst, scope, ds)) {
            AbstractVariable subfield = (AbstractVariable)sf;
            if (!subfieldName.equalsIgnoreCase(subfield.getName()) || !(subfield instanceof DataStructure)) continue;
            ds = (DataStructure)subfield;
            if (ds.getLike() != null) {
                ds = this.resolveDataStructureByName(freeAst, scope, ds.getLike());
            }
            return ds;
        }
        return null;
    }

    private DataStructure resolveDataStructureByName(Ast freeAst, Procedure scope, String dsName) {
        Object symbol = null;
        symbol = scope != null ? scope.getSymbol(dsName) : freeAst.getSymbol(dsName);
        if (symbol == null) {
            for (Include include : freeAst.listIncludes()) {
                IncludeData includeData = this.includeService.getIncludeData(this.connectionName, this.ifsPath, include.getFileUnquoted());
                if (includeData != null && includeData.getAst() != null && includeData.getAst() instanceof Ast && (symbol = ((Ast)includeData.getAst()).getSymbol(dsName)) != null && symbol instanceof DataStructure) break;
            }
        }
        return symbol instanceof DataStructure ? (DataStructure)symbol : null;
    }

    private List<ICompletionProposal> filterProposals(String value, List<ICompletionProposal> allProposals) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (ICompletionProposal proposal : allProposals) {
            if (!proposal.getDisplayString().toLowerCase().startsWith(value)) continue;
            proposals.add(proposal);
        }
        return proposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    private List<String> getQualifiedIncludePaths(Ast ast) {
        if (ast == null) {
            return Collections.emptyList();
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (Include include : ast.listIncludes()) {
            if (!StringUtils.isNotEmpty((CharSequence)include.getQualifiedPath())) continue;
            paths.add(include.getQualifiedPath());
        }
        return paths;
    }

    protected String computeCurrentValue(IDocument document, int offset) {
        LinkedList<Integer> delimiterPositions;
        String line;
        block12: {
            try {
                int lineNumber = document.getLineOfOffset(offset);
                int lineOffset = document.getLineOffset(lineNumber);
                line = document.get(lineOffset, offset - lineOffset);
                delimiterPositions = new LinkedList<Integer>();
                int x = line.lastIndexOf(40);
                if (x >= 0) {
                    delimiterPositions.add(x);
                }
                if ((x = line.lastIndexOf(58)) >= 0) {
                    delimiterPositions.add(x);
                }
                if ((x = line.lastIndexOf(61)) >= 0) {
                    delimiterPositions.add(x);
                }
                if ((x = line.lastIndexOf(43)) >= 0) {
                    delimiterPositions.add(x);
                }
                if ((x = line.lastIndexOf(45)) >= 0) {
                    delimiterPositions.add(x);
                }
                if ((x = line.lastIndexOf(47)) >= 0) {
                    delimiterPositions.add(x);
                }
                if ((x = line.lastIndexOf(42)) >= 0) {
                    delimiterPositions.add(x);
                }
                if ((x = line.lastIndexOf(32)) >= 0) {
                    delimiterPositions.add(x);
                }
                Collections.sort(delimiterPositions);
                if (!delimiterPositions.isEmpty()) break block12;
                if (lineOffset == offset - line.length()) {
                    return line;
                }
                return "";
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        return line.substring((Integer)delimiterPositions.get(delimiterPositions.size() - 1) + 1).toLowerCase();
    }
}

