/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.contentassist;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import miworkplace.ast.rpg.AST;
import miworkplace.ast.rpg.Procedure;
import miworkplace.ast.rpg.Prototype;
import miworkplace.common.Constants;
import miworkplace.ui.editor.rpg.contentassist.BifCompletionProposal;
import miworkplace.ui.editor.rpg.contentassist.KeywordCompletionProposal;
import miworkplace.ui.editor.rpg.contentassist.OpCodeCompletionProposal;
import miworkplace.ui.editor.rpg.contentassist.PrototypeCompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.osgi.service.log.LogService;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CompletionProposalFactory {
    private final LogService logger;
    private Constants.ContentAssistCase caCase;
    private List<ICompletionProposal> bifs = new ArrayList<ICompletionProposal>();
    private List<ICompletionProposal> opcodes = new ArrayList<ICompletionProposal>();
    private List<ICompletionProposal> keywords = new ArrayList<ICompletionProposal>();

    public CompletionProposalFactory(LogService logger, Constants.ContentAssistCase caCase) {
        this.logger = logger;
        this.caCase = caCase;
        this.loadCompletionProposals();
    }

    public ICompletionProposal[] getCompletionProposals(AST ast) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        proposals.addAll(this.bifs);
        proposals.addAll(this.opcodes);
        proposals.addAll(this.keywords);
        if (ast != null) {
            proposals.addAll(this.getPrototypeCompletionProposals(ast));
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    public List<ICompletionProposal> getPrototypeCompletionProposals(AST ast) {
        Prototype[] prototypes;
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        Prototype[] prototypeArray = prototypes = ast.getPrototypes();
        int n = prototypes.length;
        int n2 = 0;
        while (n2 < n) {
            Prototype prototype = prototypeArray[n2];
            if (prototype.isDocumented()) {
                proposals.add((ICompletionProposal)new PrototypeCompletionProposal(prototype, prototype.getDocumentation()));
            } else {
                Procedure procedure = ast.getProcedure(prototype.getName());
                if (procedure != null && procedure.isDocumented()) {
                    proposals.add((ICompletionProposal)new PrototypeCompletionProposal(prototype, procedure.getDocumentation()));
                } else {
                    proposals.add((ICompletionProposal)new PrototypeCompletionProposal(prototype));
                }
            }
            ++n2;
        }
        return proposals;
    }

    private void loadCompletionProposals() {
        this.loadBifsCompletionProposals();
        this.loadOpCodesCompletionProposals();
        this.loadKeywordCompletionProposals();
    }

    private void loadOpCodesCompletionProposals() {
        this.opcodes.clear();
        InputStream in = this.getClass().getResourceAsStream("opcodes.xml");
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(in);
            String name = null;
            String description = null;
            String[] extenders = new String[]{};
            String[] parameters = new String[]{};
            NodeList nodes = document.getElementsByTagName("opcode");
            int i = 0;
            while (i < nodes.getLength()) {
                NodeList bifElements = nodes.item(i).getChildNodes();
                int j = 0;
                while (j < bifElements.getLength()) {
                    Node node = bifElements.item(j);
                    String nodeName = node.getNodeName();
                    if (nodeName.equals("name")) {
                        name = node.getFirstChild().getNodeValue();
                    } else if (nodeName.equals("description")) {
                        StringBuffer buffer = new StringBuffer();
                        NodeList descriptions = node.getChildNodes();
                        int k = 0;
                        while (k < descriptions.getLength()) {
                            buffer.append(descriptions.item(k).getNodeValue());
                            ++k;
                        }
                        description = buffer.toString();
                    } else if (nodeName.equals("extenders")) {
                        extenders = this.buildOpcodeExtenders(node.getChildNodes());
                    } else if (nodeName.equals("parameters")) {
                        parameters = this.buildBifParameters(node.getChildNodes());
                    }
                    ++j;
                }
                if (this.caCase != null) {
                    name = this.caCase == Constants.ContentAssistCase.uppercase ? name.toUpperCase() : name.toLowerCase();
                }
                this.opcodes.add((ICompletionProposal)new OpCodeCompletionProposal(name, extenders, description, parameters));
                name = null;
                description = null;
                extenders = new String[]{};
                parameters = new String[]{};
                ++i;
            }
        }
        catch (Exception e) {
            this.logger.log(1, "Could not generate opcode completion proposals from xml.", (Throwable)e);
        }
    }

    private void loadBifsCompletionProposals() {
        this.bifs.clear();
        InputStream in = this.getClass().getResourceAsStream("bifs.xml");
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(in);
            String name = null;
            String returnValue = null;
            String description = null;
            String[] parameters = new String[]{};
            NodeList nodes = document.getElementsByTagName("bif");
            int i = 0;
            while (i < nodes.getLength()) {
                NodeList bifElements = nodes.item(i).getChildNodes();
                int j = 0;
                while (j < bifElements.getLength()) {
                    Node node = bifElements.item(j);
                    String nodeName = node.getNodeName();
                    if (nodeName.equals("name")) {
                        name = node.getFirstChild().getNodeValue();
                    } else if (nodeName.equals("returnValue")) {
                        if (node.hasChildNodes()) {
                            Node child = node.getFirstChild();
                            returnValue = child.getNodeValue();
                        }
                    } else if (nodeName.equals("description")) {
                        StringBuffer buffer = new StringBuffer();
                        NodeList descriptions = node.getChildNodes();
                        int k = 0;
                        while (k < descriptions.getLength()) {
                            buffer.append(descriptions.item(k).getNodeValue());
                            ++k;
                        }
                        description = buffer.toString();
                    } else if (nodeName.equals("parameters")) {
                        parameters = this.buildBifParameters(node.getChildNodes());
                    }
                    ++j;
                }
                if (this.caCase != null) {
                    name = this.caCase == Constants.ContentAssistCase.uppercase ? name.toUpperCase() : name.toLowerCase();
                }
                this.bifs.add((ICompletionProposal)new BifCompletionProposal(name, returnValue, description, parameters));
                name = null;
                returnValue = null;
                description = null;
                parameters = new String[]{};
                ++i;
            }
        }
        catch (Exception e) {
            this.logger.log(1, "Could not generate bif completion proposals from xml.", (Throwable)e);
        }
    }

    private String[] buildBifParameters(NodeList parameterNodes) {
        ArrayList<String> parameters = new ArrayList<String>();
        int i = 0;
        while (i < parameterNodes.getLength()) {
            Node parameterNode = parameterNodes.item(i);
            parameters.add(parameterNode.getFirstChild().getNodeValue());
            ++i;
        }
        return parameters.toArray(new String[parameters.size()]);
    }

    private String[] buildOpcodeExtenders(NodeList childNodes) {
        ArrayList<String> extenders = new ArrayList<String>();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node extenderNode = childNodes.item(i);
            extenders.add(extenderNode.getFirstChild().getNodeValue());
            ++i;
        }
        return extenders.toArray(new String[extenders.size()]);
    }

    private void loadKeywordCompletionProposals() {
        this.keywords.clear();
        InputStream in = this.getClass().getResourceAsStream("keywords.properties");
        Properties properties = new Properties();
        try {
            String[] keywords;
            properties.load(in);
            String property = properties.getProperty("miworkplace.ui.editor.rpg.keywords");
            String[] stringArray = keywords = property.split(",");
            int n = keywords.length;
            int n2 = 0;
            while (n2 < n) {
                String k = stringArray[n2];
                if (this.caCase != null) {
                    k = this.caCase == Constants.ContentAssistCase.uppercase ? k.toUpperCase() : k.toLowerCase();
                }
                this.keywords.add((ICompletionProposal)new KeywordCompletionProposal(k.trim()));
                ++n2;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

