/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.search;

import com.ibm.as400.access.QSYSObjectPathName;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import miworkplace.services.api.IObjectPropertiesStore;
import miworkplace.services.api.ObjectProperty;
import miworkplace.ui.search.EventFileEntryMatch;
import miworkplace.ui.search.Match;
import miworkplace.ui.search.SearchResult;
import miworkplace.ui.search.SearchResultNode;
import miworkplace.ui.search.SearchResultService;
import miworkplace.ui.search.SearchResultWidget;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.services.help.EHelpService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.osgi.service.event.Event;

public class SearchResultPart {
    public static final String PART_ID = "miworkplace.ui.search.part.result";
    private static final String SEARCH_COMMAND_ID = "miworkplace.ui.search.remote";
    private static final String GOTO_COMMAND_ID = "miworkplace.ui.search.goto";
    private static final String POPUP_MENU_ID = "miworkplace.ui.search.popupmenu";
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private IResourcePool imagePool;
    @Inject
    private SearchResultService searchResultService;
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private IObjectPropertiesStore propertiesStore;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    private EHelpService fHelpService;
    private StackLayout mainLayout;
    private Composite parent;
    private TreeViewer viewer;
    private Composite noSearchResultsPanel;
    private Composite noOpenConnection;
    private SearchResultWidget fViewerPanel;

    @PostConstruct
    public void postConstruct(Composite parent, EMenuService menuService, ESelectionService selectionService, MPart part, IEclipseContext pContext) {
        this.parent = parent;
        this.mainLayout = new StackLayout();
        parent.setLayout((Layout)this.mainLayout);
        this.noSearchResultsPanel = this.buildNoSearchResultLabel(parent);
        this.noOpenConnection = this.buildNoOpenConnectionLabel(parent);
        this.fViewerPanel = this.buildTreeViewer(parent, selectionService, pContext);
        this.showComponents();
        menuService.registerContextMenu((Object)this.viewer.getControl(), POPUP_MENU_ID);
        this.fHelpService.setHelp((Object)parent, "miworkplace.help.MIW: Remote Search Result");
        this.setMenuEnabled(false);
        this.showLastSearchResult();
    }

    private SearchResultWidget buildTreeViewer(Composite parent, final ESelectionService selectionService, IEclipseContext pContext) {
        SearchResultWidget result = (SearchResultWidget)((Object)ContextInjectionFactory.make(SearchResultWidget.class, (IEclipseContext)pContext));
        this.viewer = result.getViewer();
        this.viewer.setUseHashlookup(true);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewerLabelProvider(this.imagePool));
        this.viewer.setContentProvider((IContentProvider)new SearchResultContentProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                selectionService.setSelection((Object)event.getSelection());
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSelection() == null) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                ParameterizedCommand command = SearchResultPart.this.commandService.createCommand(SearchResultPart.GOTO_COMMAND_ID, null);
                SearchResultPart.this.handlerService.executeHandler(command);
            }
        });
        return result;
    }

    public void refresh() {
        this.viewer.refresh();
        this.revealFirstSearchResult();
    }

    private void showComponents() {
        this.mainLayout.topControl = this.viewer.getInput() == null ? (this.isAnyConnectionOpen() ? this.noSearchResultsPanel : this.noOpenConnection) : this.fViewerPanel;
        this.parent.layout();
    }

    private boolean isAnyConnectionOpen() {
        for (IConnection connection : this.connectionManager.list()) {
            if (!connection.isConnected()) continue;
            return true;
        }
        return false;
    }

    private Composite buildNoOpenConnectionLabel(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        RowLayout layout = new RowLayout();
        form.getBody().setLayout((Layout)layout);
        toolkit.createLabel(form.getBody(), Messages.search_part_noopenconn);
        return form;
    }

    private Composite buildNoSearchResultLabel(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        RowLayout layout = new RowLayout();
        form.getBody().setLayout((Layout)layout);
        toolkit.createLabel(form.getBody(), Messages.search_part_noresult);
        Hyperlink link = toolkit.createHyperlink(form.getBody(), Messages.search_part_noresult2, 64);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ParameterizedCommand command = SearchResultPart.this.commandService.createCommand(SearchResultPart.SEARCH_COMMAND_ID, null);
                SearchResultPart.this.handlerService.executeHandler(command);
            }
        });
        toolkit.createLabel(form.getBody(), "...");
        return form;
    }

    private void showLatestSearchResult() {
        if (this.searchResultService.isEmpty()) {
            this.showSearchResult(null);
        } else {
            this.showSearchResult(this.searchResultService.latest());
        }
    }

    private void showLastSearchResult() {
        if (this.searchResultService.isEmpty()) {
            this.showSearchResult(null);
        } else {
            this.showSearchResult(this.searchResultService.last());
        }
    }

    private void showSearchResult(SearchResult searchResult) {
        this.viewer.setInput((Object)searchResult);
        if (searchResult != null) {
            this.fViewerPanel.setText(searchResult.getLabel());
            this.revealFirstSearchResult();
        }
        this.setMenuEnabled(!this.searchResultService.isEmpty());
        this.showComponents();
    }

    private void revealFirstSearchResult() {
        try {
            this.viewer.getTree().setRedraw(false);
            this.viewer.expandAll();
            Object node = null;
            ArrayList<Object> expandedElements = new ArrayList<Object>();
            Object[] objectArray = this.viewer.getExpandedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (node == null) {
                    expandedElements.add(item);
                    SearchResultNode.NodeType type = ((SearchResultNode)item).type;
                    if (type == SearchResultNode.NodeType.member || type == SearchResultNode.NodeType.streamFile) {
                        node = item;
                        break;
                    }
                }
                ++n2;
            }
            TreePath[] paths = new TreePath[expandedElements.size()];
            int i = 0;
            while (i < paths.length) {
                paths[i] = new TreePath(expandedElements.subList(0, i + 1).toArray());
                ++i;
            }
            this.viewer.setExpandedTreePaths(paths);
        }
        finally {
            this.viewer.getTree().setRedraw(true);
        }
    }

    @Inject
    @Optional
    public void notifiedSearchResultRemove(@UIEventTopic(value="miworkplace/ui/search/remove") Event event) {
        if (this.viewer.getInput() != null) {
            SearchResult current = (SearchResult)this.viewer.getInput();
            this.searchResultService.remove(current);
            this.showLatestSearchResult();
        }
    }

    @Inject
    @Optional
    public void notifiedSearchResultRemoveAll(@UIEventTopic(value="miworkplace/ui/search/remove/all") Event event) {
        this.viewer.setInput(null);
        this.searchResultService.removeAll();
        this.showComponents();
    }

    @Inject
    @Optional
    public void notifiedConnection(@UIEventTopic(value="miworkplace/connection/*") Event event) {
        try {
            if (event.getTopic().equals("miworkplace/connection/connected")) {
                this.showComponents();
            } else if (event.getTopic().equals("miworkplace/connection/disconnected")) {
                this.searchResultService.removeByConnection((IConnection)event.getProperty("org.eclipse.e4.data"));
                this.showSearchResult(null);
            }
        }
        catch (SWTException sWTException) {}
    }

    private void setMenuEnabled(boolean enabled) {
    }

    @Inject
    @Optional
    public void notifiedCollapseAll(@UIEventTopic(value="miworkplace/ui/search/collapse") Event event) {
        if (this.viewer.getInput() != null) {
            this.viewer.collapseAll();
        }
    }

    @Inject
    @Optional
    public void notifiedExpandAll(@UIEventTopic(value="miworkplace/ui/search/expand") Event event) {
        if (this.viewer.getInput() != null) {
            this.viewer.expandAll();
        }
    }

    @Inject
    @Optional
    public void notifiedShowSearchResult(@UIEventTopic(value="miworkplace/ui/search/show") Event event) {
        String queryId = event.getProperty("org.eclipse.e4.data").toString();
        SearchResult searchResult = this.searchResultService.getByQueryId(Long.parseLong(queryId));
        this.showSearchResult(searchResult);
    }

    public SearchResult getCurrentSearchResult() {
        return this.viewer.getInput() == null ? null : (SearchResult)this.viewer.getInput();
    }

    public ITreeSelection getSelectedPath() {
        return this.viewer.getInput() == null ? null : (ITreeSelection)this.viewer.getSelection();
    }

    public EventFileEntryMatch selectNextMatch() {
        ISelection selection = this.viewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            return this.selectFirstMatch();
        }
        if (!this.isMatchItemSelected()) {
            TreeItem selectedItem = this.getMatchItemOfSelection();
            if (selectedItem == null) {
                return this.selectFirstMatch();
            }
            this.viewer.getTree().deselectAll();
            this.viewer.getTree().select(selectedItem);
            return (EventFileEntryMatch)selectedItem.getData();
        }
        TreeItem selectedItem = this.getMatchItemOfSelection();
        if (selectedItem == null) {
            return this.selectFirstMatch();
        }
        TreeItem sibling = this.getNextMatchSibling(selectedItem);
        if (sibling == null) {
            return this.selectFirstMatch();
        }
        this.viewer.getTree().deselectAll();
        this.viewer.getTree().select(sibling);
        return (EventFileEntryMatch)sibling.getData();
    }

    public EventFileEntryMatch selectPreviousMatch() {
        TreeItem selectedItem;
        ISelection selection = this.viewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            return this.selectLastMatch();
        }
        if (!this.isMatchItemSelected() && (selectedItem = this.getMatchItemOfSelection()) == null) {
            return this.selectLastMatch();
        }
        selectedItem = this.getMatchItemOfSelection();
        if (selectedItem == null) {
            return this.selectLastMatch();
        }
        TreeItem sibling = this.getPreviousMatchSibling(selectedItem);
        if (sibling == null) {
            return this.selectLastMatch();
        }
        this.viewer.getTree().deselectAll();
        this.viewer.getTree().select(sibling);
        return (EventFileEntryMatch)sibling.getData();
    }

    private boolean isMatchItemSelected() {
        TreeItem[] selection = this.viewer.getTree().getSelection();
        if (selection == null || selection.length == 0) {
            return false;
        }
        TreeItem lastSelectedItem = selection[selection.length - 1];
        Object element = lastSelectedItem.getData();
        return element instanceof EventFileEntryMatch;
    }

    private TreeItem getMatchItemOfSelection() {
        TreeItem[] selection = this.viewer.getTree().getSelection();
        if (selection == null || selection.length == 0) {
            return null;
        }
        TreeItem lastSelectedItem = selection[selection.length - 1];
        Object element = lastSelectedItem.getData();
        if (element instanceof EventFileEntryMatch) {
            return lastSelectedItem;
        }
        lastSelectedItem.setExpanded(true);
        TreeItem[] children = lastSelectedItem.getItems();
        while (children.length > 0) {
            TreeItem parent = children[0];
            if (parent.getData() instanceof EventFileEntryMatch) {
                return parent;
            }
            parent.setExpanded(true);
            children = parent.getItems();
        }
        return null;
    }

    private TreeItem getNextMatchSibling(TreeItem treeItem) {
        TreeItem parent = treeItem.getParentItem();
        TreeItem[] items = parent.getItems();
        int currentItemIndex = this.getTreeItemIndex(items, treeItem);
        if (currentItemIndex + 1 == items.length) {
            TreeItem[] remoteSibling = this.getNextMatchRemoteSiblings(treeItem);
            if (remoteSibling == null || remoteSibling.length == 0) {
                return null;
            }
            return remoteSibling[0];
        }
        return items[currentItemIndex + 1];
    }

    private TreeItem getPreviousMatchSibling(TreeItem treeItem) {
        TreeItem parent = treeItem.getParentItem();
        TreeItem[] items = parent.getItems();
        int currentItemIndex = this.getTreeItemIndex(items, treeItem);
        if (currentItemIndex == 0) {
            TreeItem[] remoteSibling = this.getPreviousMatchRemoteSiblings(treeItem);
            if (remoteSibling == null || remoteSibling.length == 0) {
                return null;
            }
            return remoteSibling[remoteSibling.length - 1];
        }
        return items[currentItemIndex - 1];
    }

    private TreeItem[] getNextMatchRemoteSiblings(TreeItem matchTreeItem) {
        TreeItem memberTreeItem = matchTreeItem.getParentItem();
        TreeItem fileTreeItem = memberTreeItem.getParentItem();
        TreeItem[] memberTreeItems = fileTreeItem.getItems();
        int index = this.getTreeItemIndex(memberTreeItems, memberTreeItem);
        if (index == memberTreeItems.length - 1) {
            TreeItem libraryTreeItem = fileTreeItem.getParentItem();
            TreeItem[] fileTreeItems = libraryTreeItem.getItems();
            index = this.getTreeItemIndex(fileTreeItems, fileTreeItem);
            if (index == fileTreeItems.length - 1) {
                return null;
            }
            fileTreeItems[index + 1].setExpanded(true);
            TreeItem[] newMemberItems = fileTreeItems[index + 1].getItems();
            return newMemberItems[0].getItems();
        }
        memberTreeItems[index + 1].setExpanded(true);
        return memberTreeItems[index + 1].getItems();
    }

    private TreeItem[] getPreviousMatchRemoteSiblings(TreeItem matchTreeItem) {
        TreeItem memberTreeItem = matchTreeItem.getParentItem();
        TreeItem fileTreeItem = memberTreeItem.getParentItem();
        TreeItem[] memberTreeItems = fileTreeItem.getItems();
        int index = this.getTreeItemIndex(memberTreeItems, memberTreeItem);
        if (index == 0) {
            TreeItem libraryTreeItem = fileTreeItem.getParentItem();
            TreeItem[] fileTreeItems = libraryTreeItem.getItems();
            index = this.getTreeItemIndex(fileTreeItems, fileTreeItem);
            if (index == 0) {
                return null;
            }
            fileTreeItems[index - 1].setExpanded(true);
            TreeItem[] newMemberItems = fileTreeItems[index - 1].getItems();
            return newMemberItems[newMemberItems.length - 1].getItems();
        }
        memberTreeItems[index - 1].setExpanded(true);
        return memberTreeItems[index - 1].getItems();
    }

    private int getTreeItemIndex(TreeItem[] items, TreeItem searchedItem) {
        int index = -1;
        int i = 0;
        while (i < items.length) {
            if (items[i] == searchedItem) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    private EventFileEntryMatch selectFirstMatch() {
        TreeItem[] fileNodes;
        TreeItem[] treeItems = this.viewer.getTree().getItems();
        if (treeItems.length == 0) {
            return null;
        }
        TreeItem topItem = treeItems[0];
        if (!topItem.getExpanded()) {
            topItem.setExpanded(true);
        }
        if ((fileNodes = topItem.getItems()).length > 0) {
            fileNodes[0].setExpanded(true);
            TreeItem[] memberNodes = fileNodes[0].getItems();
            if (memberNodes.length > 0) {
                memberNodes[0].setExpanded(true);
                TreeItem[] matchNodes = memberNodes[0].getItems();
                if (matchNodes.length > 0) {
                    this.viewer.getTree().deselectAll();
                    this.viewer.getTree().select(matchNodes[0]);
                    return (EventFileEntryMatch)matchNodes[0].getData();
                }
            }
        }
        return null;
    }

    private EventFileEntryMatch selectLastMatch() {
        TreeItem[] fileNodes;
        TreeItem[] treeItems = this.viewer.getTree().getItems();
        if (treeItems.length == 0) {
            return null;
        }
        TreeItem topItem = treeItems[treeItems.length - 1];
        if (!topItem.getExpanded()) {
            topItem.setExpanded(true);
        }
        if ((fileNodes = topItem.getItems()).length > 0) {
            fileNodes[fileNodes.length - 1].setExpanded(true);
            TreeItem[] memberNodes = fileNodes[fileNodes.length - 1].getItems();
            if (memberNodes.length > 0) {
                memberNodes[memberNodes.length - 1].setExpanded(true);
                TreeItem[] matchNodes = memberNodes[memberNodes.length - 1].getItems();
                if (matchNodes.length > 0) {
                    this.viewer.getTree().deselectAll();
                    this.viewer.getTree().select(matchNodes[matchNodes.length - 1]);
                    return (EventFileEntryMatch)matchNodes[matchNodes.length - 1].getData();
                }
            }
        }
        return null;
    }

    private List<SearchResultNode> getDistinctLocations(SearchResult searchResult) {
        if (searchResult.getQuery().isSearchDirectory()) {
            return this.getDistinctDirectories(searchResult);
        }
        return this.getDistinctLibraries(searchResult);
    }

    private List<SearchResultNode> getDistinctLibraries(SearchResult searchResult) {
        LinkedList<SearchResultNode> nodes = new LinkedList<SearchResultNode>();
        HashSet<String> libraryNames = new HashSet<String>();
        for (String ifsPath : searchResult.getIfsPaths()) {
            String libraryName = new QSYSObjectPathName(ifsPath).getLibraryName();
            if (libraryNames.contains(libraryName)) continue;
            SearchResultNode n = new SearchResultNode();
            n.type = SearchResultNode.NodeType.library;
            n.ifsPath = ifsPath;
            n.name = libraryName;
            nodes.add(n);
            libraryNames.add(libraryName);
        }
        return nodes;
    }

    private List<SearchResultNode> getDistinctDirectories(SearchResult searchResult) {
        LinkedList<SearchResultNode> nodes = new LinkedList<SearchResultNode>();
        HashSet<String> directories = new HashSet<String>();
        for (String ifsPath : searchResult.getIfsPaths()) {
            String dir = Path.fromOSString((String)ifsPath).removeLastSegments(1).toString();
            if (directories.contains(dir)) continue;
            SearchResultNode n = new SearchResultNode();
            n.type = SearchResultNode.NodeType.dir;
            n.ifsPath = ifsPath;
            n.name = dir;
            nodes.add(n);
            directories.add(dir);
        }
        return nodes;
    }

    private SearchResultNode[] getDistinctFiles(SearchResult searchResult, SearchResultNode library) {
        LinkedList<SearchResultNode> nodes = new LinkedList<SearchResultNode>();
        HashSet<String> names = new HashSet<String>();
        for (String ifsPath : searchResult.getIfsPaths()) {
            QSYSObjectPathName path = new QSYSObjectPathName(ifsPath);
            if (!path.getLibraryName().equals(library.name) || names.contains(path.getObjectName())) continue;
            SearchResultNode n = new SearchResultNode();
            n.ifsPath = ifsPath;
            n.name = path.getObjectName();
            n.type = SearchResultNode.NodeType.file;
            nodes.add(n);
            names.add(path.getObjectName());
        }
        return nodes.toArray(new SearchResultNode[nodes.size()]);
    }

    private SearchResultNode[] getDistinctStreamFiles(SearchResult searchResult, SearchResultNode directory) {
        LinkedList<SearchResultNode> nodes = new LinkedList<SearchResultNode>();
        HashSet<String> names = new HashSet<String>();
        for (String ifsPath : searchResult.getIfsPaths()) {
            Path path = new Path(ifsPath);
            if (!path.removeLastSegments(1).toString().equals(directory.name) || names.contains(path.toString())) continue;
            SearchResultNode n = new SearchResultNode();
            n.ifsPath = ifsPath;
            n.name = path.lastSegment();
            n.type = SearchResultNode.NodeType.streamFile;
            nodes.add(n);
            names.add(path.lastSegment());
        }
        return nodes.toArray(new SearchResultNode[nodes.size()]);
    }

    private SearchResultNode[] getDistinctMembers(SearchResult searchResult, SearchResultNode file) {
        QSYSObjectPathName parentPath = new QSYSObjectPathName(file.ifsPath);
        String parentLibraryName = parentPath.getLibraryName();
        String parentFileName = file.name;
        LinkedList<SearchResultNode> nodes = new LinkedList<SearchResultNode>();
        HashSet<String> names = new HashSet<String>();
        for (String ifsPath : searchResult.getIfsPaths()) {
            QSYSObjectPathName path = new QSYSObjectPathName(ifsPath);
            if (!path.getLibraryName().equals(parentLibraryName) || !path.getObjectName().equals(parentFileName) || names.contains(path.getObjectName())) continue;
            SearchResultNode n = new SearchResultNode();
            n.ifsPath = ifsPath;
            n.name = path.getMemberName();
            n.description = this.getMemberDescription(ifsPath);
            n.type = SearchResultNode.NodeType.member;
            nodes.add(n);
            names.add(path.getMemberName());
        }
        return nodes.toArray(new SearchResultNode[nodes.size()]);
    }

    private String getMemberDescription(String ifsPath) {
        Map properties;
        SearchResult searchResult = (SearchResult)this.viewer.getInput();
        IRemoteObject member = this.workspaceStore.get(searchResult.getConnection(), ifsPath);
        if (member != null && (properties = this.propertiesStore.get(member)) != null) {
            return properties.get(ObjectProperty.textdescription).toString();
        }
        return null;
    }

    class SearchResultContentProvider
    implements ITreeContentProvider {
        SearchResultContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof SearchResult) {
                return SearchResultPart.this.getDistinctLocations((SearchResult)parentElement).toArray();
            }
            if (parentElement instanceof SearchResultNode) {
                SearchResultNode node = (SearchResultNode)parentElement;
                switch (node.type) {
                    case library: {
                        return SearchResultPart.this.getDistinctFiles((SearchResult)SearchResultPart.this.viewer.getInput(), node);
                    }
                    case dir: {
                        return SearchResultPart.this.getDistinctStreamFiles((SearchResult)SearchResultPart.this.viewer.getInput(), node);
                    }
                    case file: {
                        return SearchResultPart.this.getDistinctMembers((SearchResult)SearchResultPart.this.viewer.getInput(), node);
                    }
                    case member: {
                        SearchResult searchResult = (SearchResult)SearchResultPart.this.viewer.getInput();
                        Object[] matches = searchResult.getMatches(node.ifsPath);
                        return matches;
                    }
                    case streamFile: {
                        SearchResult searchResult = (SearchResult)SearchResultPart.this.viewer.getInput();
                        Object[] matches = searchResult.getMatches(node.ifsPath);
                        return matches;
                    }
                }
                return new Object[0];
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }

    class TreeSorter
    extends ViewerSorter {
        TreeSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof EventFileEntryMatch && e2 instanceof EventFileEntryMatch) {
                Integer e1Line = ((EventFileEntryMatch)e1).getLine();
                Integer e2Line = ((EventFileEntryMatch)e2).getLine();
                return e1Line.compareTo(e2Line);
            }
            return e1.toString().compareTo(e2.toString());
        }
    }

    class ViewerLabelProvider
    extends StyledCellLabelProvider {
        private final IResourcePool imagePool;

        public ViewerLabelProvider(IResourcePool imagePool) {
            this.imagePool = imagePool;
        }

        public void update(ViewerCell cell) {
            StringBuilder text = new StringBuilder();
            LinkedList<StyleRange> styleRanges = new LinkedList<StyleRange>();
            Object element = cell.getElement();
            if (element instanceof SearchResultNode) {
                SearchResultNode node = (SearchResultNode)element;
                if (node.type == SearchResultNode.NodeType.member) {
                    text.append(element.toString());
                    String styledText = " " + String.format(Messages.search_part_matches, ((SearchResult)SearchResultPart.this.viewer.getInput()).getMatchCount(node.ifsPath));
                    StyleRange range = new StyleRange();
                    range.start = text.length();
                    range.length = styledText.length();
                    range.fontStyle = 1;
                    styleRanges.add(range);
                    text.append(styledText);
                } else {
                    text.append(element.toString());
                }
            } else if (element instanceof Match) {
                text.append(element.toString());
                SearchResult searchResult = (SearchResult)SearchResultPart.this.viewer.getInput();
                String searchString = searchResult.getQuery().getSearchString();
                Match match = (Match)element;
                StyleRange range = new StyleRange();
                range.start = match.getOffset() - 1;
                range.length = searchString.length();
                range.foreground = SearchResultPart.this.parent.getDisplay().getSystemColor(27);
                range.background = SearchResultPart.this.parent.getDisplay().getSystemColor(26);
                styleRanges.add(range);
            } else {
                text.append(element.toString());
            }
            cell.setImage(this.getImage(element));
            cell.setText(text.toString());
            cell.setStyleRanges(styleRanges.toArray(new StyleRange[styleRanges.size()]));
            super.update(cell);
        }

        public Image getImage(Object obj) {
            if (obj instanceof SearchResultNode) {
                SearchResultNode node = (SearchResultNode)obj;
                if (node.type == SearchResultNode.NodeType.library) {
                    return this.imagePool.getImageUnchecked("IMAGE_LIBRARY");
                }
                if (node.type == SearchResultNode.NodeType.file) {
                    return this.imagePool.getImageUnchecked("IMAGE_FILE_SOURCE");
                }
                if (node.type == SearchResultNode.NodeType.member) {
                    return this.imagePool.getImageUnchecked("IMAGE_FILE_MEMBER");
                }
            } else if (obj instanceof Match) {
                return this.imagePool.getImageUnchecked("IMAGE_SEARCH_OBJECT");
            }
            return this.imagePool.getImageUnchecked("IMAGE_DEFAULT");
        }
    }
}

