/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.search;

import java.util.Dictionary;
import java.util.Hashtable;
import miworkplace.ui.search.RemoteSearchJob;
import miworkplace.ui.search.SearchResult;
import miworkplace.ui.search.SearchResultService;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.log.LogService;

public class SearchResultJobListener
extends JobChangeAdapter {
    private LogService logger;
    private SearchResultService searchResultService;
    private EventAdmin eventBroker;

    public SearchResultJobListener() {
        Job.getJobManager().addJobChangeListener((IJobChangeListener)this);
    }

    public void bindSearchResultService(SearchResultService service) {
        this.searchResultService = service;
    }

    public void unbindSearchResultService(SearchResultService service) {
        this.searchResultService = null;
    }

    public void bindLogService(LogService logger) {
        this.logger = logger;
    }

    public void unbindLogService(LogService logger) {
        this.logger = null;
    }

    public void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventBroker = eventAdmin;
    }

    public void unbindEventAdmin(EventAdmin eventAdmin) {
        this.eventBroker = null;
    }

    protected void activate() {
        this.logger.log(3, "Started listener for SearchResult jobs.");
    }

    public void done(IJobChangeEvent event) {
        if (event.getJob() instanceof RemoteSearchJob) {
            if (event.getResult().isOK()) {
                SearchResult searchResult = ((RemoteSearchJob)event.getJob()).getSearchResult();
                this.searchResultService.add(searchResult);
                this.logger.log(4, "Search result added for query " + searchResult.getQuery().getSearchString());
                Hashtable<String, Long> map = new Hashtable<String, Long>();
                ((Dictionary)map).put("org.eclipse.e4.data", searchResult.getQuery().getId());
                this.eventBroker.postEvent(new Event("miworkplace/ui/search/show", map));
            } else {
                this.logger.log(1, event.getJob().getResult().getMessage());
            }
        }
    }
}

