/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.SourceMember;
import miworkplace.i18n.Messages;
import miworkplace.ui.api.EventFileEntry;
import miworkplace.ui.search.Match;
import miworkplace.ui.search.RemoteSearchQuery;
import org.apache.commons.collections.map.MultiValueMap;

public class SearchResult {
    public RemoteSearchQuery query;
    private MultiValueMap memberMatches = new MultiValueMap();

    public SearchResult(RemoteSearchQuery query) {
        this.query = query;
    }

    public String getLabel() {
        return this.query.getLabel();
    }

    public RemoteSearchQuery getQuery() {
        return this.query;
    }

    public String getTooltip() {
        return Messages.search_result;
    }

    public IConnection getConnection() {
        return this.query.getConnection();
    }

    public void addMatch(Match match) {
        this.internalAddMatch(match);
    }

    public void removeAll() {
        this.memberMatches.clear();
    }

    public List<String> getIfsPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        for (Object key : this.memberMatches.keySet()) {
            String s = key.toString();
            if (paths.contains(s)) continue;
            paths.add(s);
        }
        return paths;
    }

    public Match[] getMatches(SourceMember member) {
        Collection matches = this.memberMatches.getCollection((Object)member.getPath());
        return matches.toArray(new Match[matches.size()]);
    }

    public Match[] getMatches(String memberPath) {
        Collection matches = this.memberMatches.getCollection((Object)memberPath);
        return matches.toArray(new Match[matches.size()]);
    }

    private void internalAddMatch(Match match) {
        if (match.getElement() instanceof EventFileEntry) {
            EventFileEntry entry = (EventFileEntry)match.getElement();
            this.memberMatches.put((Object)entry.getQsysPath(), (Object)match);
        }
    }

    public int getMatchCount() {
        int size = 0;
        for (Object key : this.memberMatches.keySet()) {
            size += this.memberMatches.getCollection(key).size();
        }
        return size;
    }

    public int getMatchCount(String memberPath) {
        return this.memberMatches.getCollection((Object)memberPath).size();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.memberMatches == null ? 0 : this.memberMatches.hashCode());
        result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchResult other = (SearchResult)obj;
        if (this.memberMatches == null ? other.memberMatches != null : !this.memberMatches.equals((Object)other.memberMatches)) {
            return false;
        }
        return !(this.query == null ? other.query != null : !this.query.equals(other.query));
    }
}

