/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.search;

import java.text.MessageFormat;
import miworkplace.i18n.Messages;
import miworkplace.ui.api.ConnectionRule;
import miworkplace.ui.search.RemoteSearchQuery;
import miworkplace.ui.search.SearchResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class RemoteSearchJob
extends Job {
    private RemoteSearchQuery query;

    public RemoteSearchJob(RemoteSearchQuery query) {
        super(RemoteSearchJob.getJobName(query));
        this.query = query;
        this.setRule((ISchedulingRule)new ConnectionRule(query.getConnection().getName()));
        this.setPriority(20);
    }

    private static String getJobName(RemoteSearchQuery query) {
        return query.isSearchDirectory() ? MessageFormat.format(Messages.search_job_title_dir, query.getSearchString(), query.getSearchDirectory()) : MessageFormat.format(Messages.search_job_title_srcf, query.getSearchString(), query.getSearchLibrary(), query.getSearchFile(), query.getSearchMember());
    }

    protected IStatus run(IProgressMonitor monitor) {
        return this.query.run(monitor);
    }

    public SearchResult getSearchResult() {
        return this.query.getSearchResult();
    }
}

