/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.search;

import jakarta.inject.Inject;
import java.util.HashMap;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.search.RemoteSearchDialog;
import miworkplace.ui.search.RemoteSearchJob;
import miworkplace.ui.search.RemoteSearchQuery;
import miworkplace.ui.search.handler.ShowSearchResultHandler;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class RemoteSearchHandler {
    @Inject
    private IConnectionManager connectionManager;
    Debug logger = Debug.getInstance();

    @CanExecute
    public boolean canExecute() {
        return this.isAnyConnected();
    }

    private boolean isAnyConnected() {
        for (IConnection connection : this.connectionManager.list()) {
            if (!connection.isConnected()) continue;
            return true;
        }
        return false;
    }

    @Execute
    public void execute(IEclipseContext context, UISynchronize sync, EModelService modelService, ECommandService commandService, MApplication application, IWorkspaceStore pStore) {
        if (this.connectionManager.list().isEmpty()) {
            Notifier.info((String)Messages.search_dialog_title, (String)Messages.search_dialog_noconn);
            return;
        }
        boolean active = false;
        for (IConnection conn : this.connectionManager.list()) {
            if (!conn.isConnected()) continue;
            active = true;
        }
        if (!active) {
            Notifier.info((String)Messages.search_dialog_title, (String)Messages.search_dialog_nopenconn);
            return;
        }
        RemoteSearchDialog dialog = (RemoteSearchDialog)((Object)ContextInjectionFactory.make(RemoteSearchDialog.class, (IEclipseContext)context));
        if (dialog.open() == 0) {
            RemoteSearchQuery query = dialog.getQuery();
            this.addLibrary(query, pStore);
            this.scheduleSearchJob(context, sync, commandService, query);
        }
    }

    private void addLibrary(RemoteSearchQuery pQuery, IWorkspaceStore pStore) {
        IRemoteObject library;
        if (!pQuery.isSearchDirectory() && !pQuery.getSearchLibrary().contains("*") && (library = pStore.getLibrary(pQuery.getConnection(), pQuery.getSearchLibrary())) == null) {
            pStore.addLibrary(pQuery.getConnection(), pQuery.getSearchLibrary());
        }
    }

    private void scheduleSearchJob(final IEclipseContext context, final UISynchronize sync, final ECommandService commandService, RemoteSearchQuery query) {
        final RemoteSearchJob searchJob = new RemoteSearchJob(query);
        searchJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent pEvent) {
                if (pEvent.getResult().isOK()) {
                    sync.syncExec(() -> {
                        HashMap<String, String> parameters = new HashMap<String, String>();
                        parameters.put("miworkplace.ui.search.show.query.id", String.valueOf(searchJob.getSearchResult().getQuery().getId()));
                        ParameterizedCommand pcommand = commandService.createCommand("miworkplace.ui.search.show", parameters);
                        ShowSearchResultHandler handler = (ShowSearchResultHandler)ContextInjectionFactory.make(ShowSearchResultHandler.class, (IEclipseContext)context);
                        try {
                            handler.execute(pcommand);
                        }
                        catch (Exception e) {
                            RemoteSearchHandler.this.logger.error(e.getMessage(), (Throwable)e);
                            e.printStackTrace();
                        }
                    });
                }
                super.done(pEvent);
            }
        });
        searchJob.setUser(true);
        searchJob.schedule();
    }
}

