/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.ddm;

import com.ibm.jtopenlite.ddm.DDMCallbackEvent;
import com.ibm.jtopenlite.ddm.DDMDataBuffer;
import com.ibm.jtopenlite.ddm.DDMFile;
import com.ibm.jtopenlite.ddm.DDMReadCallback;
import com.ibm.jtopenlite.ddm.DDMReaderRunner;
import com.ibm.jtopenlite.ddm.DDMRecordFormat;

public abstract class DDMThreadedReader
implements DDMReadCallback {
    private final DDMFile file_;
    private final DDMReaderRunner[] runners_;
    private final Thread[] threads_;
    private boolean done_;
    private long sequence_;

    public DDMThreadedReader(DDMRecordFormat dDMRecordFormat, DDMFile dDMFile, int n) {
        this.file_ = dDMFile;
        this.done_ = false;
        int n2 = dDMFile.getBufferCount();
        if (n > n2) {
            n = n2;
        }
        this.runners_ = new DDMReaderRunner[n];
        this.threads_ = new Thread[n];
        for (int i = 0; i < n; ++i) {
            this.runners_[i] = new DDMReaderRunner(this, dDMRecordFormat, i, n, n2);
            this.threads_[i] = new Thread((Runnable)this.runners_[i], "DDMThreadedReader-" + i);
            this.threads_[i].start();
        }
    }

    final DDMDataBuffer getDataBuffer(int n) {
        return this.file_.getDataBuffer(n);
    }

    public final void newRecord(DDMCallbackEvent dDMCallbackEvent, DDMDataBuffer dDMDataBuffer) {
        dDMDataBuffer.startProcessing();
        DDMFile dDMFile = dDMCallbackEvent.getFile();
        if (dDMFile == this.file_) {
            DDMDataBuffer dDMDataBuffer2 = dDMFile.getNextDataBuffer();
            while (dDMDataBuffer2.isProcessing()) {
                dDMFile.nextBuffer();
                dDMDataBuffer2 = dDMFile.getNextDataBuffer();
            }
        }
    }

    public final void recordNotFound(DDMCallbackEvent dDMCallbackEvent) {
        this.finish();
    }

    public final void endOfFile(DDMCallbackEvent dDMCallbackEvent) {
        this.finish();
    }

    public final boolean isDone() {
        return this.done_;
    }

    private final void finish() {
        int n;
        for (n = 0; n < this.file_.getBufferCount(); ++n) {
            while (this.file_.getDataBuffer(n).isProcessing()) {
            }
        }
        for (n = 0; n < this.runners_.length; ++n) {
            this.runners_[n].done();
        }
        for (n = 0; n < this.threads_.length; ++n) {
            try {
                this.threads_[n].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.done_ = true;
    }

    public abstract void process(DDMRecordFormat var1, DDMDataBuffer var2);
}

