/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.command.program.workmgmt;

import com.ibm.jtopenlite.Conv;
import com.ibm.jtopenlite.command.Program;
import com.ibm.jtopenlite.command.program.workmgmt.JobKeyDataListener;
import com.ibm.jtopenlite.command.program.workmgmt.RetrieveCurrentAttributesASPGroupListener;
import com.ibm.jtopenlite.command.program.workmgmt.RetrieveCurrentAttributesLibraryListener;
import com.ibm.jtopenlite.command.program.workmgmt.Util;

public class RetrieveCurrentAttributes
implements Program {
    private static final byte[] ZERO = new byte[4];
    public static final int FORMAT_RTVC0100 = 0;
    public static final int FORMAT_RTVC0200 = 1;
    public static final int FORMAT_RTVC0300 = 2;
    private int inputFormat_;
    private int inputLength_;
    private int[] attributesToReturn_;
    private int numberOfAttributesReturned_;
    private int bytesReturned_;
    private int bytesAvailable_;
    private int numberOfLibrariesInSYSLIBL_;
    private int numberOfProductLibraries_;
    private boolean currentLibraryExistence_;
    private int numberOfLibrariesInUSRLIBL_;
    private int numberOfASPGroups_;
    private JobKeyDataListener keyDataListener_;
    private RetrieveCurrentAttributesLibraryListener libraryListener_;
    private RetrieveCurrentAttributesASPGroupListener aspGroupListener_;
    private byte[] tempData_;

    public RetrieveCurrentAttributes(int n, int n2, int[] nArray) {
        this.inputFormat_ = n;
        this.inputLength_ = n2 <= 0 ? 1 : n2;
        this.attributesToReturn_ = nArray == null ? new int[]{} : nArray;
    }

    public final byte[] getTempDataBuffer() {
        int n = 0;
        for (int i = 0; i < this.getNumberOfParameters(); ++i) {
            int n2 = this.getParameterOutputLength(i);
            if (n2 > n) {
                n = n2;
            }
            if ((n2 = this.getParameterInputLength(i)) <= n) continue;
            n = n2;
        }
        if (this.tempData_ == null || this.tempData_.length < n) {
            this.tempData_ = new byte[n];
        }
        return this.tempData_;
    }

    public String getProgramName() {
        return "QWCRTVCA";
    }

    public String getProgramLibrary() {
        return "QSYS";
    }

    public int getNumberOfParameters() {
        return 6;
    }

    public void newCall() {
        this.numberOfAttributesReturned_ = 0;
        this.bytesReturned_ = 0;
        this.bytesAvailable_ = 0;
        this.numberOfLibrariesInSYSLIBL_ = 0;
        this.numberOfProductLibraries_ = 0;
        this.currentLibraryExistence_ = false;
        this.numberOfLibrariesInUSRLIBL_ = 0;
        this.numberOfASPGroups_ = 0;
    }

    public void setFormat(int n) {
        this.inputFormat_ = n;
    }

    public int getFormat() {
        return this.inputFormat_;
    }

    public int getLengthOfReceiverVariable() {
        return this.inputLength_;
    }

    public void setLengthOfReceiverVariable(int n) {
        this.inputLength_ = n <= 0 ? 1 : n;
    }

    public int[] getAttributesToReturn() {
        return this.attributesToReturn_;
    }

    public void setAttributesToReturn(int[] nArray) {
        this.attributesToReturn_ = nArray == null ? new int[]{} : nArray;
    }

    public int getNumberOfAttributesReturned() {
        return this.numberOfAttributesReturned_;
    }

    public int getBytesAvailable() {
        return this.bytesAvailable_;
    }

    public int getBytesReturned() {
        return this.bytesReturned_;
    }

    public int getNumberOfSystemLibraries() {
        return this.numberOfLibrariesInSYSLIBL_;
    }

    public int getNumberOfProductLibraries() {
        return this.numberOfProductLibraries_;
    }

    public boolean hasCurrentLibrary() {
        return this.currentLibraryExistence_;
    }

    public int getNumberOfUserLibraries() {
        return this.numberOfLibrariesInUSRLIBL_;
    }

    public int getNumberOfASPGroups() {
        return this.numberOfASPGroups_;
    }

    public int getParameterInputLength(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 4 * this.attributesToReturn_.length;
            }
            case 5: {
                return 4;
            }
        }
        return 0;
    }

    public int getParameterOutputLength(int n) {
        switch (n) {
            case 0: {
                return this.inputLength_;
            }
            case 5: {
                return 4;
            }
        }
        return 0;
    }

    private String getFormatName() {
        switch (this.inputFormat_) {
            case 0: {
                return "RTVC0100";
            }
            case 1: {
                return "RTVC0200";
            }
            case 2: {
                return "RTVC0300";
            }
        }
        return null;
    }

    public int getParameterType(int n) {
        switch (n) {
            case 0: {
                return 2;
            }
            case 5: {
                return 3;
            }
        }
        return 1;
    }

    public byte[] getParameterInputData(int n) {
        byte[] byArray = this.getTempDataBuffer();
        switch (n) {
            case 1: {
                Conv.intToByteArray(this.inputLength_, byArray, 0);
                return byArray;
            }
            case 2: {
                Conv.stringToEBCDICByteArray37(this.getFormatName(), byArray, 0);
                return byArray;
            }
            case 3: {
                Conv.intToByteArray(this.attributesToReturn_.length, byArray, 0);
                return byArray;
            }
            case 4: {
                for (int i = 0; i < this.attributesToReturn_.length; ++i) {
                    Conv.intToByteArray(this.attributesToReturn_[i], byArray, i * 4);
                }
                return byArray;
            }
            case 5: {
                return ZERO;
            }
        }
        return null;
    }

    public void setKeyDataListener(JobKeyDataListener jobKeyDataListener) {
        this.keyDataListener_ = jobKeyDataListener;
    }

    public void setLibraryListener(RetrieveCurrentAttributesLibraryListener retrieveCurrentAttributesLibraryListener) {
        this.libraryListener_ = retrieveCurrentAttributesLibraryListener;
    }

    public void setASPGroupListener(RetrieveCurrentAttributesASPGroupListener retrieveCurrentAttributesASPGroupListener) {
        this.aspGroupListener_ = retrieveCurrentAttributesASPGroupListener;
    }

    public void setParameterOutputData(int n, byte[] byArray, int n2) {
        block24: {
            char[] cArray = new char[20];
            block0 : switch (n) {
                case 0: {
                    int n3 = 0;
                    switch (this.inputFormat_) {
                        case 0: {
                            if (n2 >= 4) {
                                this.numberOfAttributesReturned_ = Conv.byteArrayToInt(byArray, n3);
                                n3 += 4;
                            }
                            if (this.keyDataListener_ != null) {
                                for (int i = 0; i < this.numberOfAttributesReturned_ && n3 + 16 <= n2; ++i) {
                                    int n4 = Conv.byteArrayToInt(byArray, n3);
                                    int n5 = Conv.byteArrayToInt(byArray, n3 += 4);
                                    int n6 = byArray[n3 += 4] & 0xFF;
                                    boolean bl = n6 == 194;
                                    int n7 = Conv.byteArrayToInt(byArray, n3 += 4);
                                    if ((n3 += 4) + n7 <= n2) {
                                        Util.readKeyData(byArray, n3, n5, n7, bl, this.keyDataListener_, cArray);
                                        int n8 = n4 - 16 - n7;
                                        if ((n3 += n7) + n8 <= n2) {
                                            n3 += n8;
                                            continue;
                                        }
                                        n3 = n2;
                                        continue;
                                    }
                                    n3 = n2;
                                }
                                break block0;
                            }
                            break block24;
                        }
                        case 1: {
                            if (n2 >= 8) {
                                this.bytesReturned_ = Conv.byteArrayToInt(byArray, 0);
                                this.bytesAvailable_ = Conv.byteArrayToInt(byArray, 4);
                                n3 += 8;
                            }
                            if (n2 < 24) break block24;
                            this.numberOfLibrariesInSYSLIBL_ = Conv.byteArrayToInt(byArray, n3);
                            this.numberOfProductLibraries_ = Conv.byteArrayToInt(byArray, n3 += 4);
                            this.currentLibraryExistence_ = Conv.byteArrayToInt(byArray, n3 += 4) == 1;
                            this.numberOfLibrariesInUSRLIBL_ = Conv.byteArrayToInt(byArray, n3 += 4);
                            n3 += 4;
                            if (this.libraryListener_ != null) {
                                String string;
                                int n9;
                                for (n9 = 0; n9 < this.numberOfLibrariesInSYSLIBL_ && n3 + 11 <= n2; ++n9) {
                                    string = Conv.ebcdicByteArrayToString(byArray, n3, 11, cArray);
                                    n3 += 11;
                                    this.libraryListener_.newSystemLibrary(string);
                                }
                                for (n9 = 0; n9 < this.numberOfProductLibraries_ && n3 + 11 <= n2; ++n9) {
                                    string = Conv.ebcdicByteArrayToString(byArray, n3, 11, cArray);
                                    n3 += 11;
                                    this.libraryListener_.newProductLibrary(string);
                                }
                                if (this.currentLibraryExistence_ && n3 + 11 <= n2) {
                                    String string2 = Conv.ebcdicByteArrayToString(byArray, n3, 11, cArray);
                                    n3 += 11;
                                    this.libraryListener_.currentLibrary(string2);
                                }
                                for (int i = 0; i < this.numberOfLibrariesInUSRLIBL_ && n3 + 11 <= n2; ++i) {
                                    string = Conv.ebcdicByteArrayToString(byArray, n3, 11, cArray);
                                    n3 += 11;
                                    this.libraryListener_.newUserLibrary(string);
                                }
                                break block0;
                            }
                            break block24;
                        }
                        case 2: {
                            if (n2 >= 8) {
                                this.bytesReturned_ = Conv.byteArrayToInt(byArray, 0);
                                this.bytesAvailable_ = Conv.byteArrayToInt(byArray, 4);
                                n3 += 8;
                            }
                            if (n2 >= 20) {
                                int n10;
                                int n11 = Conv.byteArrayToInt(byArray, n3);
                                this.numberOfASPGroups_ = Conv.byteArrayToInt(byArray, n3 += 4);
                                int n12 = Conv.byteArrayToInt(byArray, n3 += 4);
                                if (this.aspGroupListener_ != null && (n3 += 8) + (n10 = n11 - 20) <= n2) {
                                    n3 += n10;
                                    for (int i = 0; i < this.numberOfASPGroups_ && n3 + 10 <= n2; ++i) {
                                        String string = Conv.ebcdicByteArrayToString(byArray, n3, 10, cArray);
                                        this.aspGroupListener_.newASPGroup(string);
                                        n10 = n12 - 10;
                                        if (n3 + n10 <= n2) {
                                            n3 += n10;
                                            continue;
                                        }
                                        n3 = n2;
                                    }
                                } else {
                                    break;
                                }
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
            }
        }
    }
}

