/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite;

import com.ibm.jtopenlite.Conv;
import com.ibm.jtopenlite.DataStreamException;
import com.ibm.jtopenlite.HostServerConnection;
import com.ibm.jtopenlite.SystemInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.net.ssl.SSLSocketFactory;

public class SignonConnection
extends HostServerConnection {
    public static final int DEFAULT_SIGNON_SERVER_PORT = 8476;
    public static final int DEFAULT_SSL_SIGNON_SERVER_PORT = 9476;

    private SignonConnection(SystemInfo systemInfo, Socket socket, HostServerConnection.HostInputStream hostInputStream, HostServerConnection.HostOutputStream hostOutputStream, String string) {
        super(systemInfo, string, systemInfo.getSignonJobName(), socket, hostInputStream, hostOutputStream);
    }

    protected void sendEndJobRequest() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate(String string, String string2) throws IOException {
        int n;
        if (this.isClosed()) {
            throw new IOException("Connection closed");
        }
        Object[] objectArray = SignonConnection.getInfo(true, this.getInfo().getSystem(), this.out_, this.in_);
        byte[] byArray = (byte[])objectArray[1];
        byte[] byArray2 = (byte[])objectArray[2];
        byte[] byArray3 = SignonConnection.getUserBytes(string, this.getInfo().getPasswordLevel());
        byte[] byArray4 = SignonConnection.getPasswordBytes(string2, this.getInfo().getPasswordLevel());
        string2 = null;
        byte[] byArray5 = SignonConnection.getEncryptedPassword(byArray3, byArray4, byArray, byArray2, this.getInfo().getPasswordLevel());
        byte[] byArray6 = this.getInfo().getPasswordLevel() < 2 ? byArray3 : SignonConnection.getUserBytes(string, 0);
        SignonConnection.sendSignonInfoRequest(this.out_, this.getInfo(), byArray6, byArray5);
        this.out_.flush();
        int n2 = this.in_.readInt();
        if (n2 < 20) {
            throw DataStreamException.badLength("signonInfo", n2);
        }
        this.in_.skipBytes(16);
        int n3 = this.in_.readInt();
        try {
            int n4;
            if (n3 != 0) {
                String string3 = "Bad return code from signon info: 0x" + Integer.toHexString(n3);
                switch (n3) {
                    case 131073: {
                        string3 = "User ID is not known.";
                        break;
                    }
                    case 196619: {
                        string3 = "Password is incorrect.";
                    }
                }
                throw new IOException(string3);
            }
            int n5 = 0;
            boolean bl = false;
            for (n = 24; n < n2 && !bl; n += n4) {
                n4 = this.in_.readInt();
                int n6 = this.in_.readShort();
                int n7 = 0;
                switch (n6) {
                    case 4372: {
                        n5 = this.in_.readInt();
                        n7 = 4;
                        bl = true;
                    }
                }
                this.in_.skipBytes(n4 - 6 - n7);
            }
            if (bl) {
                this.getInfo().setServerCCSID(n5);
            }
        }
        finally {
            this.in_.skipBytes(n2 - n);
            this.in_.end();
        }
    }

    private static Object[] getInfo(boolean bl, String string, HostServerConnection.HostOutputStream hostOutputStream, HostServerConnection.HostInputStream hostInputStream) throws IOException {
        Object[] objectArray = new Object[3];
        long l = SignonConnection.sendSignonExchangeAttributeRequest(hostOutputStream);
        if (bl) {
            byte[] byArray = Conv.longToByteArray(l);
            objectArray[1] = byArray;
        }
        hostOutputStream.flush();
        int n = hostInputStream.readInt();
        if (n < 20) {
            throw DataStreamException.badLength("signonExchangeAttributes", n);
        }
        hostInputStream.skipBytes(16);
        int n2 = hostInputStream.readInt();
        if (n2 != 0) {
            hostInputStream.skipBytes(n - 24);
            throw DataStreamException.badReturnCode("signonExchangeAttributes", n2);
        }
        int n3 = 24;
        int n4 = -1;
        boolean bl2 = false;
        int n5 = -1;
        boolean bl3 = false;
        boolean bl4 = false;
        int n6 = -1;
        boolean bl5 = false;
        String string2 = null;
        while (!(n3 >= n || bl2 && bl3 && bl5 && bl && (!bl || bl4))) {
            int n7;
            int n8 = n3;
            int n9 = hostInputStream.readInt();
            int n10 = hostInputStream.readShort();
            n3 += 6;
            switch (n10) {
                case 4353: {
                    n4 = hostInputStream.readInt();
                    n3 += 4;
                    bl2 = true;
                    break;
                }
                case 4354: {
                    n5 = hostInputStream.readShort();
                    n3 += 2;
                    bl3 = true;
                    break;
                }
                case 4355: {
                    if (bl) {
                        byte[] byArray = new byte[n9 - 6];
                        hostInputStream.readFully(byArray);
                        objectArray[2] = byArray;
                        n3 += n9 - 6;
                        bl4 = true;
                        break;
                    }
                    hostInputStream.skipBytes(n9 - 6);
                    n3 += n9 - 6;
                    break;
                }
                case 4377: {
                    n6 = hostInputStream.read();
                    ++n3;
                    bl5 = true;
                    break;
                }
                case 4383: {
                    hostInputStream.skipBytes(4);
                    n3 += 4;
                    byte[] byArray = new byte[n9 - 10];
                    hostInputStream.readFully(byArray);
                    string2 = Conv.ebcdicByteArrayToString(byArray, 0, byArray.length);
                    n3 += n9 - 10;
                    break;
                }
                default: {
                    hostInputStream.skipBytes(n9 - 6);
                    n3 += n9 - 6;
                }
            }
            if ((n7 = n9 - (n3 - n8)) <= 0) continue;
            hostInputStream.skipBytes(n7);
        }
        hostInputStream.skipBytes(n - n3);
        hostInputStream.end();
        objectArray[0] = new SystemInfo(string, n4, n5, n6, string2);
        return objectArray;
    }

    public static SignonConnection getConnection(String string, String string2, String string3) throws IOException {
        return SignonConnection.getConnection(false, string, string2, string3);
    }

    public static SignonConnection getConnection(boolean bl, String string, String string2, String string3) throws IOException {
        return SignonConnection.getConnection(bl, string, string2, string3, bl ? 9476 : 8476);
    }

    public static SignonConnection getConnection(String string, String string2, String string3, int n) throws IOException {
        return SignonConnection.getConnection(false, string, string2, string3, n);
    }

    public static SignonConnection getConnection(boolean bl, String string, String string2, String string3, int n) throws IOException {
        if (n > 0 && n < 65536) {
            Socket socket = bl ? SSLSocketFactory.getDefault().createSocket(string, n) : new Socket(string, n);
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            HostServerConnection.HostOutputStream hostOutputStream = new HostServerConnection.HostOutputStream(new BufferedOutputStream(outputStream));
            HostServerConnection.HostInputStream hostInputStream = new HostServerConnection.HostInputStream(new BufferedInputStream(inputStream));
            SystemInfo systemInfo = (SystemInfo)SignonConnection.getInfo(false, string, hostOutputStream, hostInputStream)[0];
            SignonConnection signonConnection = new SignonConnection(systemInfo, socket, hostInputStream, hostOutputStream, string2);
            signonConnection.authenticate(string2, string3);
            return signonConnection;
        }
        throw new IOException("Bad port number: " + n);
    }

    private static long sendSignonExchangeAttributeRequest(HostServerConnection.HostOutputStream hostOutputStream) throws IOException {
        hostOutputStream.writeInt(52);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(57353);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(28675);
        hostOutputStream.writeInt(10);
        hostOutputStream.writeShort(4353);
        hostOutputStream.writeInt(1);
        hostOutputStream.writeInt(8);
        hostOutputStream.writeShort(4354);
        hostOutputStream.writeShort(2);
        hostOutputStream.writeInt(14);
        hostOutputStream.writeShort(4355);
        long l = System.currentTimeMillis();
        hostOutputStream.writeLong(l);
        return l;
    }

    private static void sendSignonInfoRequest(HostServerConnection.HostOutputStream hostOutputStream, SystemInfo systemInfo, byte[] byArray, byte[] byArray2) throws IOException {
        boolean bl;
        int n = 37 + byArray2.length + 16;
        boolean bl2 = bl = systemInfo.getServerLevel() >= 5;
        if (bl) {
            n += 7;
        }
        hostOutputStream.writeInt(n);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(57353);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeShort(1);
        hostOutputStream.writeShort(28676);
        hostOutputStream.writeByte(byArray2.length == 8 ? 1 : 3);
        hostOutputStream.writeInt(10);
        hostOutputStream.writeShort(4371);
        hostOutputStream.writeInt(1200);
        hostOutputStream.writeInt(6 + byArray2.length);
        hostOutputStream.writeShort(4357);
        hostOutputStream.write(byArray2);
        hostOutputStream.writeInt(16);
        hostOutputStream.writeShort(4356);
        hostOutputStream.write(byArray);
        if (bl) {
            hostOutputStream.writeInt(7);
            hostOutputStream.writeShort(4392);
            hostOutputStream.writeByte(1);
        }
    }
}

