/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.cl.text;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.HashMap;
import miworkplace.ui.editor.cl.ast.Ast;
import miworkplace.ui.editor.cl.ast.Parser;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.osgi.service.log.LogService;

public class SourceModelReconcileStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private IDocument document;
    @Inject
    @Named(value="inputUri")
    private String inputUri;
    @Inject
    @Named(value="memberPath")
    private String memberPath;
    @Inject
    private LogService logger;
    @Inject
    private IEventBroker eventBroker;
    private Parser parser = new Parser();

    public void reconcile(DirtyRegion dirtyRegion, IRegion region) {
    }

    public void reconcile(IRegion region) {
        this.logger.log(4, "Building AST for " + this.memberPath);
        try {
            Ast ast = this.parser.parse(this.document.get());
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("org.eclipse.e4.data", ast);
            data.put("memberPath", this.memberPath);
            data.put("inputUri", this.inputUri);
            data.put("content", this.document.get());
            this.eventBroker.post("miworkplace/editor/reconciled", data);
        }
        catch (Exception e) {
            this.logger.log(1, "Could not build AST for " + this.memberPath + ". Error: " + e.getMessage(), (Throwable)e);
        }
    }

    public void setDocument(IDocument document) {
        this.document = document;
        this.logger.log(4, "Document set for " + this.memberPath + " with " + document.getLength() + " characters");
    }

    public void initialReconcile() {
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }
}

