/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.cl.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.ui.api.IFindReplaceSupport;
import miworkplace.ui.editor.ISourceCodeReceiver;
import miworkplace.ui.editor.cl.IClEditor;
import miworkplace.ui.editor.text.TextBlock;
import miworkplace.ui.util.Prompter;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;

public class CommandPromptHandler {
    private static final int INDENT = Integer.valueOf(System.getProperty("miworkplace.cl.indent", "13"));
    private static final int MARGIN = Integer.valueOf(System.getProperty("miworkplace.cl.margin", "11"));
    private static final String EMPTYSTRING = "";
    private static final String SPACE = " ";
    private static final String CONTINUATION = "+";
    private Debug logger = Debug.getInstance();
    @Inject
    IConnectionManager fConManager;
    private static Pattern fCommentPattern = Pattern.compile(".*?(\\s*\\/\\*.*\\*\\/\\s*)$");
    private static Pattern fLabelPattern = Pattern.compile("^(\\s*[A-Za-z][A-Za-z0-9\\@\\$\\#\\_]{0,9}\\:\\s*)[^\\s]*.*$");

    public static void main(String[] args) {
        CommandPromptHandler.parseCommand(" OMQCHGFI ACTC(*ADD) APPL(&APPL) FIX(&FIXNUMBER) FIXT(&FIXNUMBER) RLS(&FIXNUMBER) PTH(&FIXNUMBER) PRIC(&FIXNUMBER) PGMR(&FIXNUMBER) ESDT('&FIX') EDDT('&FIX') ECDT('&FIX') EHR(&FIXNUMBER) SHFD('this is a     very long text and it contains all sorts') FREE(&FIXNUMBER) EOPI(*NO) MSGI(*NO)");
        TextBlock b = new TextBlock().setEndLine(1).setStartLine(2).setRegion((IRegion)new Region(1, 100));
        TextBlock insertBlock = CommandPromptHandler.formatCommand("OMQCHGFI ACTC(*ADD) APPL(&APPL) FIX(&FIXNUMBER) FIXT(&FIXNUMBER) RLS(&FIXNUMBER) PTH(&FIXNUMBER) PRIC(&FIXNUMBER) PGMR(&FIXNUMBER) ESDT('&FIX') EDDT('&FIX') ECDT('&FIX') EHR(&FIXNUMBER) SHFD('      very long text and it containss all sorts  ;') FREE(&FIXNUMBER) EOPI(*NO) MSGI(*NO)", "HELLO:", "/* comment */", 80, b);
        for (String line : insertBlock.getLines()) {
            System.out.println(line);
        }
    }

    @CanExecute
    public boolean canExecute(@Named(value="e4ActivePart") MPart part) {
        Class<?>[] interfaces;
        Class<?>[] classArray = interfaces = part.getObject().getClass().getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            if (clazz == IClEditor.class) {
                return true;
            }
            ++n2;
        }
        this.logger.debug((Option)miworkplace.ui.editor.debug.Option.editors, "Prompting only works for CL");
        return false;
    }

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part) {
        ISourceCodeReceiver receiver = (ISourceCodeReceiver)part.getObject();
        IFindReplaceSupport findReplaceSupportingObject = (IFindReplaceSupport)part.getObject();
        IDocument document = findReplaceSupportingObject.getDocument();
        int startOffset = 0;
        Point selectedRange = findReplaceSupportingObject.getViewer().getSelectedRange();
        try {
            if (selectedRange != null && selectedRange.x >= 0) {
                startOffset = selectedRange.x;
                int lineNumber = document.getLineOfOffset(startOffset);
                TextBlock oldBlock = this.getBlock(document, lineNumber);
                List lines = oldBlock.getLines();
                String command = this.unifyCommand(lines);
                String label = this.getLabel(command);
                String comment = this.getComment(command);
                if (!(command = command.replaceFirst(label, EMPTYSTRING)).trim().isEmpty()) {
                    command = command.substring(0, command.length() - comment.length());
                    String connectionName = (String)part.getPersistedState().get("miworkplace.editor.connection");
                    String prompt = Prompter.prompt((IConnection)this.fConManager.get(connectionName), (String)command);
                    if (prompt == null) {
                        return;
                    }
                    this.logger.debug((Option)miworkplace.ui.editor.debug.Option.editors, MessageFormat.format("Parsing label: {0} command: {1} comment: {2}", label, prompt, comment));
                    TextBlock insertBlock = CommandPromptHandler.formatCommand(prompt.trim(), label.trim(), comment.trim(), receiver.getRecordLength(), oldBlock);
                    if (insertBlock.getLines().size() == 1) {
                        document.replace(oldBlock.getRegion().getOffset(), oldBlock.getRegion().getLength(), (String)insertBlock.getLines().get(0));
                    } else {
                        Object newText = EMPTYSTRING;
                        lines = insertBlock.getLines();
                        int i = 0;
                        while (i < lines.size()) {
                            String line = (String)lines.get(i);
                            newText = (String)newText + line + (i == lines.size() - 1 ? EMPTYSTRING : "\n");
                            ++i;
                        }
                        document.replace(oldBlock.getRegion().getOffset(), oldBlock.getRegion().getLength(), (String)newText);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static TextBlock formatCommand(String command, String label, String comment, int pRecordLength, TextBlock pOldBlock) {
        int recordLen = pRecordLength - MARGIN;
        List<String> tokens = CommandPromptHandler.parseCommand(command);
        tokens.add(comment);
        tokens.add(EMPTYSTRING);
        ArrayList<String> lines = new ArrayList<String>();
        Object line = label.isEmpty() ? EMPTYSTRING : SPACE + label.toUpperCase();
        int indent = INDENT - (label.isEmpty() ? 0 : label.length() + 1);
        line = (String)line + SPACE.repeat(indent > 0 ? indent : 1);
        int i = 0;
        while (i < tokens.size()) {
            line = (String)line + tokens.get(i);
            line = i == 0 && tokens.size() > 2 ? (String)line + SPACE.repeat(11 - tokens.get(0).length()) : (String)line + SPACE;
            if (((String)line).length() > recordLen) {
                Object split = ((String)line).substring(0, recordLen);
                if (!((String)split).endsWith(SPACE) && ((String)line).substring(recordLen, recordLen + 1).endsWith(SPACE)) {
                    split = ((String)line).substring(0, recordLen + 1);
                }
                split = (String)split + CONTINUATION;
                lines.add(((String)split).stripTrailing());
                line = SPACE.repeat(INDENT * 2) + ((String)line).substring(((String)split).length() - 1, ((String)line).length());
            } else if (((String)line).length() + tokens.get(i + 1).length() + 1 > recordLen) {
                if (((String)line).endsWith(")")) {
                    if (!tokens.get(i + 1).equals(EMPTYSTRING)) {
                        line = (String)line + " +";
                    }
                } else if (!tokens.get(i + 1).equals(EMPTYSTRING)) {
                    line = (String)line + CONTINUATION;
                }
                lines.add(((String)line).stripTrailing());
                line = SPACE.repeat(INDENT * 2);
            }
            if (tokens.get(i + 1).equals(EMPTYSTRING)) {
                lines.add(((String)line).stripTrailing());
                break;
            }
            ++i;
        }
        TextBlock result = new TextBlock();
        result.setLines(lines).setStartLine(pOldBlock.getStartLine()).setEndLine(pOldBlock.getEndLine());
        return result;
    }

    private static List<String> parseCommand(String pCommand) {
        ArrayList<String> tokens = new ArrayList<String>();
        String[] split = pCommand.trim().split("\\s");
        tokens.add(split[0]);
        Object token = EMPTYSTRING;
        int i = 1;
        while (i < split.length) {
            if (((String)(token = (String)token + split[i])).endsWith(")")) {
                tokens.add((String)token);
                token = EMPTYSTRING;
            } else {
                token = (String)token + SPACE;
            }
            ++i;
        }
        return tokens;
    }

    private String getLabel(String pCommand) {
        String command = pCommand;
        Matcher m = fLabelPattern.matcher(command);
        if (m.matches()) {
            return m.group(1);
        }
        return EMPTYSTRING;
    }

    private String getComment(String pCommand) {
        String command = pCommand;
        Matcher m = fCommentPattern.matcher(command);
        if (m.matches()) {
            return m.group(1);
        }
        return EMPTYSTRING;
    }

    private String unifyCommand(List<String> lines) {
        Object result = EMPTYSTRING;
        int i = 0;
        while (i < lines.size()) {
            String line = lines.get(i);
            result = i == 0 ? (line.trim().endsWith(" +") ? (String)result + line.substring(0, line.stripTrailing().length() - 1) + SPACE : (line.trim().endsWith(CONTINUATION) ? (String)result + line.substring(0, line.stripTrailing().length() - 1) : (String)result + line)) : (line.trim().endsWith(" +") ? (String)result + line.trim().substring(0, line.trim().length() - 1) + SPACE : (line.trim().endsWith(CONTINUATION) ? (String)result + line.trim().substring(0, line.trim().length() - 1) : (String)result + line.stripLeading()));
            ++i;
        }
        return ((String)result).trim();
    }

    private TextBlock getBlock(IDocument document, int lineNumber) throws BadLocationException {
        TextBlock result = new TextBlock();
        ArrayList<String> lines = new ArrayList<String>();
        result.setLines(lines);
        int firstLineNumber = lineNumber;
        String line = null;
        while (firstLineNumber > 0) {
            IRegion firstLineRegion;
            if ((line = document.get((firstLineRegion = document.getLineInformation(--firstLineNumber)).getOffset(), firstLineRegion.getLength())).trim().endsWith(CONTINUATION)) continue;
            result.setStartLine(++firstLineNumber);
            break;
        }
        IRegion startRegion = document.getLineInformation(firstLineNumber);
        IRegion workRegion = null;
        line = document.get(startRegion.getOffset(), startRegion.getLength());
        lines.add(line);
        while (line.trim().endsWith(CONTINUATION)) {
            try {
                workRegion = document.getLineInformation(++firstLineNumber);
                line = document.get(workRegion.getOffset(), workRegion.getLength());
                lines.add(line);
                continue;
            }
            catch (BadLocationException badLocationException) {}
            break;
        }
        if (workRegion == null) {
            workRegion = startRegion;
        }
        workRegion = new Region(startRegion.getOffset(), workRegion.getOffset() + workRegion.getLength() - startRegion.getOffset());
        result.setRegion(workRegion);
        result.setEndLine(result.getStartLine() + lines.size() - 1);
        return result;
    }
}

