/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.cl;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import miworkplace.common.model.Tasklist;
import miworkplace.ui.api.IOutlinePageProvider;
import miworkplace.ui.editor.IAstProvider;
import miworkplace.ui.editor.RemoteEditor;
import miworkplace.ui.editor.cl.ClOutlinePage;
import miworkplace.ui.editor.cl.ClSourceViewerConfiguration;
import miworkplace.ui.editor.cl.IClEditor;
import miworkplace.ui.editor.cl.TasklistAdapter;
import miworkplace.ui.editor.cl.ast.AbstractToken;
import miworkplace.ui.editor.cl.ast.Ast;
import miworkplace.ui.editor.cl.ast.File;
import miworkplace.ui.editor.cl.ast.Subroutine;
import miworkplace.ui.editor.cl.ast.Variable;
import miworkplace.ui.editor.cl.text.ClPartitionScanner;
import miworkplace.ui.editor.cl.text.ClPartitionTypes;
import miworkplace.ui.editor.cl.text.SourceModelReconcileStrategy;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.osgi.service.event.Event;

public class ClEditor
extends RemoteEditor
implements IOutlinePageProvider,
IClEditor {
    private Ast ast;
    private ClOutlinePage outlinePage;
    private TasklistAdapter tasklistAdapter;

    @Inject
    public ClEditor(MPart part, IResourcePool imagePool) {
        super(part, imagePool);
    }

    @PostConstruct
    public void initialize() {
        this.createTaskListAdapter();
    }

    protected void createTaskListAdapter() {
        IEclipseContext additionalContext = EclipseContextFactory.create((String)this.memberPath);
        additionalContext.set("memberPath", (Object)this.memberPath);
        additionalContext.set("inputUri", (Object)this.inputUri);
        this.tasklistAdapter = (TasklistAdapter)ContextInjectionFactory.make(TasklistAdapter.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext);
    }

    protected SourceViewerConfiguration createSourceViewerConfiguration() {
        IEclipseContext additionalContext = EclipseContextFactory.create((String)this.memberPath);
        additionalContext.set("memberPath", (Object)this.memberPath);
        additionalContext.set("inputUri", (Object)this.inputUri);
        SourceModelReconcileStrategy strategy = (SourceModelReconcileStrategy)ContextInjectionFactory.make(SourceModelReconcileStrategy.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext);
        IEclipseContext sourceViewerContext = this.context.createChild();
        sourceViewerContext.set(SourceModelReconcileStrategy.class, (Object)strategy);
        return (SourceViewerConfiguration)ContextInjectionFactory.make(ClSourceViewerConfiguration.class, (IEclipseContext)sourceViewerContext);
    }

    protected IDocumentPartitioner createDocumentPartitioner() {
        ClPartitionScanner scanner = new ClPartitionScanner();
        return new FastPartitioner((IPartitionTokenScanner)scanner, ClPartitionTypes.PARTITION_TYPES);
    }

    protected boolean supportFormatLines() {
        return false;
    }

    protected void registerContextMenu() {
        this.menuService.registerContextMenu((Object)this.getViewer().getTextWidget(), "miworkplace.ui.editor.cl.popupmenu");
    }

    public Control getOutlinePage(Composite parent) {
        if (this.outlinePage == null) {
            this.buildOutlinePage(parent);
        }
        return this.outlinePage.getControl();
    }

    private void buildOutlinePage(Composite parent) {
        IEclipseContext pageContext = this.context.createChild();
        pageContext.set(Composite.class, (Object)parent);
        pageContext.set("connection", (Object)this.connectionName);
        this.outlinePage = (ClOutlinePage)ContextInjectionFactory.make(ClOutlinePage.class, (IEclipseContext)pageContext);
    }

    public void toggleComment() throws BadLocationException {
    }

    private boolean toggleCommentOn(IDocument document, ITextSelection selection) throws BadLocationException {
        boolean toggleOn = false;
        int startLine = selection.getStartLine();
        int endLine = selection.getEndLine();
        int i = startLine;
        while (i <= endLine) {
            ++i;
        }
        return toggleOn;
    }

    public Ast getAst() {
        return this.ast;
    }

    public Object getAdapter(Class adapter) {
        if (adapter != null && adapter == Tasklist.class) {
            return this.tasklistAdapter.getAdapter(adapter);
        }
        if (adapter == IAstProvider.class) {
            return this.ast;
        }
        Object adaptedObject = super.getAdapter(adapter);
        if (adaptedObject != null) {
            return adaptedObject;
        }
        return null;
    }

    @Inject
    @Optional
    public void notifiedAstRebuild(@UIEventTopic(value="miworkplace/editor/reconciled") Event event) {
        if (event.containsProperty("inputUri")) {
            String astInputUri = event.getProperty("inputUri").toString();
            Object eventData = event.getProperty("org.eclipse.e4.data");
            if (this.inputUri.equals(astInputUri)) {
                this.ast = eventData != null && eventData instanceof Ast ? (Ast)eventData : null;
            }
        }
    }

    @Override
    public void highlight(Object obj) {
        int startLine = 0;
        int endLine = 0;
        if (obj instanceof Variable) {
            Variable v = (Variable)obj;
            startLine = endLine = v.getName().line;
        } else if (obj instanceof Subroutine) {
            Subroutine sub = (Subroutine)obj;
            startLine = endLine = sub.getStart().line;
        } else if (obj instanceof File) {
            File f = (File)obj;
            startLine = endLine = f.getFileToken().line;
        } else if (obj instanceof AbstractToken) {
            startLine = endLine = ((AbstractToken)obj).line;
        } else {
            return;
        }
        IDocument document = this.getDocument();
        try {
            int startLineOffset = document.getLineOffset(startLine);
            int endLineOffset = document.getLineOffset(endLine);
            if (startLineOffset == endLineOffset) {
                int lineLength = document.getLineLength(startLine);
                this.highlightCodeRange(startLineOffset, lineLength);
            } else {
                int endLineLength = document.getLineLength(endLine);
                int endLineEndOffset = endLineOffset + endLineLength;
                int selectionLength = endLineEndOffset - startLineOffset;
                this.highlightCodeRange(startLineOffset, selectionLength);
            }
        }
        catch (BadLocationException e) {
            this.logger.error("Could not determine code range for highlighting procedure.", (Throwable)e);
        }
    }
}

