/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.jackson.core;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class Root {
    private final String apiURL;
    private String fEncodedAuthorization;
    private final ObjectMapper MAPPER = new ObjectMapper();
    private String system;

    public Root(String apiURL, String system) {
        this.system = system;
        while (apiURL.endsWith("/")) {
            apiURL = apiURL.substring(0, apiURL.length() - 1);
        }
        this.apiURL = apiURL;
        this.configureMapper();
    }

    public String getEncodedAuthorization() {
        return this.fEncodedAuthorization;
    }

    public Root setEncodedAuthorization(String pEncodedAuthorization) {
        this.fEncodedAuthorization = pEncodedAuthorization;
        return this;
    }

    public String getSystemName() {
        return this.system;
    }

    public Root configureMapper() {
        this.MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.MAPPER.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        this.MAPPER.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        return this;
    }

    public URL getApiURL(String pPath) throws MalformedURLException {
        return new URL(String.valueOf(this.apiURL) + "/" + pPath);
    }

    public ObjectMapper getMapper() {
        return this.MAPPER;
    }
}

