/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.ui.framework.java.DataBean;
import com.ibm.as400.ui.framework.java.DisplayManagerException;
import com.ibm.as400.ui.framework.java.EventHandler;
import com.ibm.as400.ui.framework.java.HelpViewer;
import com.ibm.as400.ui.framework.java.PanelManager;
import com.ibm.as400.ui.framework.java.WindowManager;
import com.ibm.as400.ui.util.MessagesBean;
import com.ibm.as400.ui.util.ResourceLoader;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;

public class DetailButtonHandler
extends EventHandler
implements ActionListener {
    private boolean m_initialActivation;
    MessagesBean msgBean;
    static ResourceLoader m_loader = new ResourceLoader();
    private PanelManager m_pm = null;

    public DetailButtonHandler(PanelManager panelManager) {
        super(panelManager);
        this.m_pm = panelManager;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.m_initialActivation = !(actionEvent.getSource() instanceof JButton);
        DataBean[] dataBeanArray = this.panelManager.getDataBeans();
        if (dataBeanArray != null) {
            Object object;
            this.msgBean = null;
            for (int i = 0; i < dataBeanArray.length; ++i) {
                object = dataBeanArray[i];
                if (!(object instanceof MessagesBean)) continue;
                this.msgBean = (MessagesBean)object;
                break;
            }
            if (this.msgBean != null) {
                JList jList = (JList)this.panelManager.getComponent("IDC_CM_MESSAGE_DISPLAY");
                if (jList.isSelectionEmpty()) {
                    object = m_loader.getString("detailButtonError_Title");
                    String string = m_loader.getString("detailButtonError_SelectMessageFirst");
                    JOptionPane.showMessageDialog(this.panelManager.getContainer(), string, (String)object, 2);
                } else {
                    this.msgBean.setSelection(jList.getSelectedIndex());
                    object = jList.getSelectedValue();
                    if (object != null) {
                        int n = this.msgBean.getSelectedMessageDetailType();
                        if (n == 1 || n == 4) {
                            DataBean[] dataBeanArray2 = new DataBean[]{this.msgBean};
                            JFrame jFrame = new JFrame();
                            PanelManager panelManager = null;
                            try {
                                panelManager = new PanelManager("com.ibm.as400.ui.util.MessageViewerPanels", "IDD_CM_MESSAGE_DETAILS", dataBeanArray2, (Frame)jFrame);
                            }
                            catch (DisplayManagerException displayManagerException) {
                                displayManagerException.displayUserMessage(null);
                                return;
                            }
                            JLabel jLabel = (JLabel)panelManager.getComponent("IDC_CM_DETAILS_MESSAGE_ID");
                            jLabel.setText(this.msgBean.getSelectedMessageID());
                            if (this.m_pm != null) {
                                panelManager.setModalRelativeTo((WindowManager)this.m_pm);
                            }
                            panelManager.setVisible(true);
                        } else if (n == 2) {
                            if (this.msgBean.getHelpSet() == null) {
                                HelpViewer helpViewer = new HelpViewer(this.msgBean.getSelectedMessageURL());
                                helpViewer.setParentWindow(this.panelManager.getWindow());
                                helpViewer.showPage(this.msgBean.getSelectedMessageURL());
                            } else {
                                HelpViewer helpViewer = new HelpViewer();
                                helpViewer.setParentWindow(this.panelManager.getWindow());
                                helpViewer.showPage(this.msgBean.getSelectedMessageURL(), this.msgBean.getHelpSet());
                            }
                        } else if (n == 3) {
                            HelpViewer helpViewer = new HelpViewer();
                            helpViewer.setParentWindow(this.panelManager.getWindow());
                            helpViewer.showHTML(this.msgBean.getSelectedMessageDetail(), this.msgBean.getSelectedMessageAnchor());
                        }
                    }
                }
            } else {
                String string = m_loader.getString("detailButtonError_Title");
                object = m_loader.getString("detailButtonError_DataBeanNotAvailable");
                JOptionPane.showMessageDialog(this.panelManager.getContainer(), object, string, 2);
            }
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    static {
        m_loader.setResourceName("com.ibm.as400.ui.util.UTMRI");
    }
}

