/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.pref;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import miworkplace.i18n.Messages;
import miworkplace.ui.pref.api.IPreferenceNode;
import miworkplace.ui.pref.api.IPreferencesService;
import miworkplace.ui.pref.api.PreferencePage;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;

public class PreferenceDialog
extends TitleAreaDialog {
    private static final int RESTORE_DEFAULTS = 100;
    private IPreferencesService preferenceService;
    private Composite contentArea;
    private IEclipsePreferences eclipsePreferences;
    private Map<String, PreferencePage> preferencePages = new HashMap<String, PreferencePage>();
    private PreferencePage fCurrentPage;
    private IStylingEngine stylingEngine;

    public PreferenceDialog(Shell shell, IPreferencesService preferenceService, IEclipsePreferences eclipsePreferences, IStylingEngine stylingEngine) {
        super(shell);
        this.preferenceService = preferenceService;
        this.eclipsePreferences = eclipsePreferences;
        this.stylingEngine = stylingEngine;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setSize(700, 600);
    }

    public void create() {
        super.create();
        this.setTitle(Messages.pref_dialog_title);
        this.setMessage(Messages.pref_dialog_desc);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.stylingEngine.setId((Object)composite, "miworkplace-preference-dialog");
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        SashForm sashForm = new SashForm(composite, 256);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        sashForm.setSashWidth(2);
        this.createTreeAreaContents((Composite)sashForm);
        this.contentArea = this.createPageContainer((Composite)sashForm);
        sashForm.setWeights(new int[]{3, 8});
        parent.setBackground(this.contentArea.getBackground());
        return sashForm;
    }

    private TreeViewer createTreeAreaContents(Composite parent) {
        TreeViewer treeViewer = this.createTreeViewer(parent);
        treeViewer.setInput((Object)this.preferenceService);
        return treeViewer;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, 2048);
        this.addListeners(viewer);
        viewer.setLabelProvider((IBaseLabelProvider)new PreferenceLabelProvider());
        viewer.setContentProvider((IContentProvider)new PreferenceContentProvider());
        return viewer;
    }

    protected void addListeners(TreeViewer viewer) {
        viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){
            private String currentPageId;

            public void selectionChanged(SelectionChangedEvent event) {
                final IPreferenceNode selection = PreferenceDialog.this.getSingleSelection(event.getSelection());
                if (selection != null && selection instanceof IPreferenceNode) {
                    BusyIndicator.showWhile((Display)PreferenceDialog.this.getShell().getDisplay(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            this.showPreferencePage((IPreferenceNode)selection);
                        }

                        private void showPreferencePage(IPreferenceNode selection2) {
                            if (!selection2.getId().equals(currentPageId)) {
                                if ((this).PreferenceDialog.this.preferencePages.containsKey(selection2.getId())) {
                                    (this).PreferenceDialog.this.fCurrentPage = (this).PreferenceDialog.this.preferencePages.get(selection2.getId());
                                    ((StackLayout)(this).PreferenceDialog.this.contentArea.getLayout()).topControl = (this).PreferenceDialog.this.fCurrentPage;
                                    this.enableRestoreButton();
                                } else {
                                    selection2.setPreferenceStore((this).PreferenceDialog.this.eclipsePreferences);
                                    (this).PreferenceDialog.this.fCurrentPage = selection2.buildPage((this).PreferenceDialog.this.contentArea);
                                    ((StackLayout)(this).PreferenceDialog.this.contentArea.getLayout()).topControl = (this).PreferenceDialog.this.fCurrentPage;
                                    (this).PreferenceDialog.this.preferencePages.put(selection2.getId(), (this).PreferenceDialog.this.fCurrentPage);
                                    this.enableRestoreButton();
                                }
                                ((PreferencePage)((StackLayout)(this).PreferenceDialog.this.contentArea.getLayout()).topControl).preShow();
                                (this).PreferenceDialog.this.contentArea.layout();
                            }
                        }

                        private void enableRestoreButton() {
                            PreferenceDialog.this.getButton(100).setEnabled(false);
                            if ((this).PreferenceDialog.this.fCurrentPage.canRestore()) {
                                PreferenceDialog.this.getButton(100).setEnabled(true);
                            }
                        }
                    });
                }
            }
        });
    }

    private IPreferenceNode getSingleSelection(ISelection selection) {
        IStructuredSelection structured;
        if (!selection.isEmpty() && (structured = (IStructuredSelection)selection).getFirstElement() instanceof IPreferenceNode) {
            return (IPreferenceNode)structured.getFirstElement();
        }
        return null;
    }

    protected Composite createPageContainer(Composite parent) {
        Composite outer = new Composite(parent, 2048);
        GridData outerData = new GridData(1808);
        outerData.horizontalIndent = 7;
        outer.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        outer.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        ScrolledComposite scrolled = new ScrolledComposite(outer, 768);
        scrolled.setShowFocusedControl(true);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        GridData scrolledData = new GridData(1808);
        scrolled.setLayoutData((Object)scrolledData);
        Composite contentArea = new Composite((Composite)scrolled, 0);
        contentArea.setLayout((Layout)new StackLayout());
        scrolled.setContent((Control)contentArea);
        parent.setBackground(scrolled.getBackground());
        return contentArea;
    }

    protected Control createButtonBar(Composite pParent) {
        Control bar = super.createButtonBar(pParent);
        bar.setBackground(pParent.getBackground());
        return bar;
    }

    protected void createButtonsForButtonBar(Composite pParent) {
        this.createButton(pParent, 100, "Restore Defaults", true);
        super.createButtonsForButtonBar(pParent);
    }

    protected Layout getPageLayout() {
        return new GridLayout();
    }

    protected void buttonPressed(int pButtonId) {
        if (pButtonId == 100) {
            this.fCurrentPage.restore();
            return;
        }
        super.buttonPressed(pButtonId);
    }

    protected void okPressed() {
        if (this.isValid()) {
            for (PreferencePage page : this.preferencePages.values()) {
                page.save(this.eclipsePreferences);
            }
            try {
                this.eclipsePreferences.flush();
            }
            catch (BackingStoreException e) {
                throw new RuntimeException(Messages.pref_dialog_save_error, e);
            }
            super.okPressed();
        }
    }

    private boolean isValid() {
        for (PreferencePage page : this.preferencePages.values()) {
            if (page.isValid()) continue;
            return false;
        }
        return true;
    }

    class PreferenceContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private final Object[] NO_OBJECTS = new Object[0];

        PreferenceContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement == PreferenceDialog.this.preferenceService) {
                return this.getTopLevelNodes();
            }
            if (parentElement instanceof IPreferenceNode) {
                return this.getChildNodesByParentId(((IPreferenceNode)parentElement).getId());
            }
            return this.NO_OBJECTS;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        private Object[] getChildNodesByParentId(String parentId) {
            LinkedList<IPreferenceNode> nodes = null;
            for (IPreferenceNode node : PreferenceDialog.this.preferenceService.getPreferenceNodes()) {
                if (!parentId.equals(node.getParentId())) continue;
                if (nodes == null) {
                    nodes = new LinkedList<IPreferenceNode>();
                }
                nodes.add(node);
            }
            if (nodes == null) {
                return this.NO_OBJECTS;
            }
            Collections.sort(nodes, new Comparator<IPreferenceNode>(){

                @Override
                public int compare(IPreferenceNode n1, IPreferenceNode n2) {
                    return n1.getName().compareTo(n2.getName());
                }
            });
            return nodes.toArray(new IPreferenceNode[nodes.size()]);
        }

        private Object[] getTopLevelNodes() {
            LinkedList<IPreferenceNode> nodes = new LinkedList<IPreferenceNode>();
            for (IPreferenceNode node : PreferenceDialog.this.preferenceService.getPreferenceNodes()) {
                if (node.getParentId() != null) continue;
                nodes.add(node);
            }
            Collections.sort(nodes, new Comparator<IPreferenceNode>(){

                @Override
                public int compare(IPreferenceNode n1, IPreferenceNode n2) {
                    int result = Integer.valueOf(n1.getOrder()).compareTo(n2.getOrder());
                    return result == 0 ? n1.getName().compareTo(n2.getName()) : result;
                }
            });
            return nodes.toArray(new IPreferenceNode[nodes.size()]);
        }
    }

    class PreferenceLabelProvider
    extends LabelProvider {
        PreferenceLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IPreferenceNode) {
                return ((IPreferenceNode)element).getName();
            }
            return element.toString();
        }
    }
}

