/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.util;

import com.remainsoftware.common.util.StringUtils;
import com.remainsoftware.common.util.Validate;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APITypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinRegistryUtils {
    protected static final Logger logger = LoggerFactory.getLogger(WinRegistryUtils.class);
    static String HIVEKEY_CURRENT_USER = "HKEY_CURRENT_USER";
    static String HIVEKEY_LOCAL_MACHINE_KEY = "HKEY_LOCAL_MACHINE";

    public static String registryLookup(String regKey) throws Exception {
        return WinRegistryUtils.registryLookup(regKey, true);
    }

    public static String registryLookup(String regKey, boolean isWin32) throws Exception {
        String[] subs;
        int keyCount;
        Validate.isNotEmpty(regKey);
        if (regKey.endsWith("/")) {
            regKey = regKey.substring(0, regKey.length() - 1);
        }
        if ((keyCount = (subs = StringUtils.parseIntoSubstrings(regKey, "/")).length) < 3) {
            throw new IllegalArgumentException("Unable to process registry key: '" + regKey + "', reason = malformed key, must be root/sub-path/key");
        }
        int subKeyCount = keyCount - 2;
        String hive = subs[0];
        String subk = StringUtils.concatenateIntoString(subs, 1, subKeyCount, "\\");
        String keyName = subs[subs.length - 1];
        WinReg.HKEY rootKey = null;
        if (hive.equalsIgnoreCase(HIVEKEY_LOCAL_MACHINE_KEY)) {
            rootKey = WinReg.HKEY_LOCAL_MACHINE;
        } else if (hive.equalsIgnoreCase(HIVEKEY_CURRENT_USER)) {
            rootKey = WinReg.HKEY_CURRENT_USER;
        }
        if (rootKey == null) {
            throw new IllegalArgumentException("Unable to process registry root key: '" + hive + "', reason = unsupported root key, must be " + HIVEKEY_LOCAL_MACHINE_KEY + " or " + HIVEKEY_CURRENT_USER);
        }
        try {
            int samDesired = 131097;
            if (isWin32) {
                samDesired |= 0x200;
            }
            String value = WinRegistryUtils.registryGetStringValue(rootKey, subk, keyName, samDesired);
            return value;
        }
        catch (Exception e) {
            if (e instanceof Win32Exception && ((Win32Exception)((Object)e)).getErrorCode() == 2) {
                return null;
            }
            throw new Exception("failed to retrieve value for registry key: " + regKey + ", reason = " + StringUtils.extractMessage(e), e);
        }
    }

    public static String getComputerName() throws Exception {
        try {
            return Kernel32Util.getComputerName();
        }
        catch (Win32Exception ex) {
            logger.warn("Kernel32Util.GetComputerName error code: " + ex.getHR().intValue());
            String env = System.getenv("COMPUTERNAME");
            if (env != null) {
                return env;
            }
            throw new Exception("error calling 'GetComputerName()' function, rc=" + ex.getHR().intValue());
        }
    }

    public static boolean registryKeyExists(WinReg.HKEY root, String key) throws Win32Exception {
        return WinRegistryUtils.registryKeyExists(root, key, 0);
    }

    public static boolean registryKeyExists(WinReg.HKEY root, String key, int samDesiredExtra) throws Win32Exception {
        WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
        int rc = Advapi32.INSTANCE.RegOpenKeyEx(root, key, 0, 0x20019 | samDesiredExtra, phkKey);
        switch (rc) {
            case 0: {
                Advapi32.INSTANCE.RegCloseKey(phkKey.getValue());
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new Win32Exception(rc);
    }

    public static boolean registryValueExists(WinReg.HKEY root, String key, String value) throws Win32Exception {
        return WinRegistryUtils.registryValueExists(root, key, value, 0);
    }

    public static boolean registryValueExists(WinReg.HKEY root, String key, String value, int samDesiredExtra) throws Win32Exception {
        WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
        int rc = Advapi32.INSTANCE.RegOpenKeyEx(root, key, 0, 0x20019 | samDesiredExtra, phkKey);
        switch (rc) {
            case 0: {
                break;
            }
            case 2: {
                return false;
            }
            default: {
                throw new Win32Exception(rc);
            }
        }
        try {
            IntByReference lpcbData = new IntByReference();
            IntByReference lpType = new IntByReference();
            rc = Advapi32.INSTANCE.RegQueryValueEx(phkKey.getValue(), value, 0, lpType, null, lpcbData);
            switch (rc) {
                case 0: 
                case 122: 
                case 234: {
                    return true;
                }
                case 2: {
                    return false;
                }
            }
            throw new Win32Exception(rc);
        }
        finally {
            if (phkKey.getValue() != WinBase.INVALID_HANDLE_VALUE && (rc = Advapi32.INSTANCE.RegCloseKey(phkKey.getValue())) != 0) {
                logger.warn("failed to close registry key: " + phkKey.getValue() + ", reason = Windows rc: " + rc);
            }
        }
    }

    public static String registryGetStringValue(WinReg.HKEY root, String key, String value) throws Exception {
        return WinRegistryUtils.registryGetStringValue(root, key, value, 0);
    }

    public static String registryGetStringValue(WinReg.HKEY root, String key, String value, int samDesiredExtra) throws Exception {
        WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
        int rc = Advapi32.INSTANCE.RegOpenKeyEx(root, key, 0, 0x20019 | samDesiredExtra, phkKey);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            String string = WinRegistryUtils.registryGetStringValue(phkKey.getValue(), value);
            return string;
        }
        finally {
            rc = Advapi32.INSTANCE.RegCloseKey(phkKey.getValue());
            if (rc != 0) {
                logger.warn("failed to close registry key: " + phkKey.getValue() + ", reason = Windows rc: " + rc);
            }
        }
    }

    public static String registryGetStringValue(WinReg.HKEY hKey, String value) throws Exception {
        IntByReference lpType = new IntByReference();
        IntByReference lpcbData = new IntByReference();
        int rc = Advapi32.INSTANCE.RegQueryValueEx(hKey, value, 0, lpType, null, lpcbData);
        if (rc != 0 && rc != 122) {
            throw new Win32Exception(rc);
        }
        if (lpType.getValue() != 1 && lpType.getValue() != 2) {
            throw new Exception("Unexpected registry type " + lpType.getValue() + ", expected REG_SZ or REG_EXPAND_SZ");
        }
        if (lpcbData.getValue() == 0) {
            return "";
        }
        Memory mem = new Memory((long)(lpcbData.getValue() + Native.WCHAR_SIZE));
        mem.clear();
        rc = Advapi32.INSTANCE.RegQueryValueEx(hKey, value, 0, lpType, (Pointer)mem, lpcbData);
        if (rc != 0 && rc != 122) {
            throw new Win32Exception(rc);
        }
        if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
            return mem.getWideString(0L);
        }
        return mem.getString(0L);
    }

    public static void main(String[] args) {
        String baseKey = "HKEY_LOCAL_MACHINE/SOFTWARE/LANSA/C:%5CPROGRAM%20FILES%20(X86)%5CLANSA/";
        String majorVer = "LX_VersionMajor/";
        String minorVer = "LX_VersionMinor";
        String lansaVersionMajor = null;
        String lansaVersionMinor = null;
        try {
            lansaVersionMajor = WinRegistryUtils.registryLookup(String.valueOf(baseKey) + majorVer);
            lansaVersionMinor = WinRegistryUtils.registryLookup(String.valueOf(baseKey) + minorVer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("lansa version: " + lansaVersionMajor + "." + lansaVersionMinor);
    }
}

