/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.util;

import com.ibm.misc.BASE64Decoder;
import com.ibm.misc.BASE64Encoder;
import com.remainsoftware.common.util.IcingException;
import com.remainsoftware.common.util.StringUtils;
import com.remainsoftware.common.util.Validate;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringIcing {
    private String chenc;
    private Cipher enc;
    private Cipher dec;
    public static final String PASSABLE = "PBE";
    public static final String CHIPPING = "MD5";
    public static final String PREF_ICING = "DES";
    public static String ICING = "PBEWithMD5AndDES";
    public static final String PROPERTY_ENC_PREFIX = "enc{";
    public static final String PROPERTY_ENC_POSTFIX = "}";
    public static final String PROPERTY_IENC_PREFIX = "ienc(";
    public static final String PROPERTY_IENC_POSTFIX = ")";
    private static final Logger logger = LoggerFactory.getLogger(StringIcing.class);
    private static String password = "qsysopr";

    private StringIcing(String pass, byte[] fuzz, int iter, String chenc) throws IcingException {
        Validate.isTrue(!pass.isEmpty(), "Password is empty.");
        Validate.isNotNull(fuzz);
        Validate.isTrue(iter > 0);
        Validate.isTrue(!chenc.isEmpty());
        try {
            PBEParameterSpec params = new PBEParameterSpec(fuzz, iter);
            PBEKeySpec keySpec = new PBEKeySpec(pass.toCharArray());
            SecretKey key = SecretKeyFactory.getInstance(ICING).generateSecret(keySpec);
            this.chenc = chenc;
            this.enc = Cipher.getInstance(ICING);
            this.enc.init(1, (Key)key, params);
            this.dec = Cipher.getInstance(ICING);
            this.dec.init(2, (Key)key, params);
        }
        catch (Exception e) {
            String excptMsg = e.getMessage();
            if (excptMsg == null) {
                excptMsg = e.getClass().getName();
            }
            logger.error(StringUtils.extractMessage(e), (Throwable)e);
            throw new IcingException("Failed to cipher string, cause = " + excptMsg, e);
        }
    }

    private synchronized byte[] icing(String arg) throws IcingException {
        Validate.isNotNull(arg);
        try {
            byte[] dsChars = arg.getBytes(this.chenc);
            return this.enc.doFinal(dsChars);
        }
        catch (Exception e) {
            String excptMsg = e.getMessage();
            if (excptMsg == null) {
                excptMsg = e.getClass().getName();
            }
            logger.error(StringUtils.extractMessage(e), (Throwable)e);
            throw new IcingException("Failed to cipher string, cause = " + excptMsg, e);
        }
    }

    private synchronized String dicing(byte[] arg) throws IcingException {
        Validate.isNotNull(arg);
        try {
            byte[] dsChars = this.dec.doFinal(arg);
            return new String(dsChars, this.chenc);
        }
        catch (Exception e) {
            String excptMsg = e.getMessage();
            if (excptMsg == null) {
                excptMsg = e.getClass().getName();
            }
            throw new IcingException("Failed to decipher string, cause = " + excptMsg, e);
        }
    }

    public static String genForIcing(String arg) throws IcingException {
        Validate.isTrue(!arg.isEmpty());
        try {
            byte[] salt = new byte[]{-89, -58, 34, -3, 52, -27, -74, 7};
            StringIcing dsEnc = new StringIcing(arg, salt, 121, "UTF-8");
            byte[] encBytes = dsEnc.icing(arg);
            BASE64Encoder base64Encoder = new BASE64Encoder();
            return base64Encoder.encode(encBytes).trim();
        }
        catch (Exception e) {
            String excptMsg = e.getMessage();
            if (excptMsg == null) {
                excptMsg = e.getClass().getName();
            }
            logger.error(StringUtils.extractMessage(e), (Throwable)e);
            throw new IcingException("Failed on generate for string cipher, cause = " + excptMsg, e);
        }
    }

    public static String iceToBase64String(String arg, String pass) throws IcingException {
        Validate.isNotNull(arg);
        Validate.isNotNull(pass);
        String iced = "";
        try {
            byte[] salt = new byte[]{-89, -58, 34, -3, 52, -27, -74, 7};
            StringIcing dsEnc = new StringIcing(pass, salt, 21, "UTF-8");
            byte[] ice = dsEnc.icing(arg);
            BASE64Encoder encoder = new BASE64Encoder();
            iced = encoder.encodeBuffer(ice).trim();
        }
        catch (Exception e) {
            String excptMsg = e.getMessage();
            if (excptMsg == null) {
                excptMsg = e.getClass().getName();
            }
            logger.error(StringUtils.extractMessage(e), (Throwable)e);
            throw new IcingException("Failed to create printable cipher, cause = " + excptMsg, e);
        }
        return iced;
    }

    public static String diceFromBase64String(String arg, String pass) throws IcingException {
        Validate.isNotNull(arg);
        Validate.isNotNull(pass);
        String diced = "";
        try {
            byte[] salt = new byte[]{-89, -58, 34, -3, 52, -27, -74, 7};
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] dice = decoder.decodeBuffer(arg);
            StringIcing dsEnc = new StringIcing(pass, salt, 21, "UTF-8");
            diced = dsEnc.dicing(dice);
        }
        catch (Exception e) {
            logger.error(StringUtils.extractMessage(e), (Throwable)e);
            throw new IcingException("Failed to convert string for deciphering", e);
        }
        return diced;
    }

    public static String iceToHexBase64String(String arg, String pass) throws IcingException {
        return StringUtils.convertAsciiToHex(StringIcing.iceToBase64String(arg, pass));
    }

    public static String diceFromHexBase64String(String arg, String pass) throws IcingException {
        String ascii;
        try {
            ascii = StringUtils.convertHexToAscii(arg);
        }
        catch (Exception e) {
            throw new IcingException(e);
        }
        return StringIcing.diceFromBase64String(ascii, pass);
    }

    public static String iceToPropertyString(String arg, String pass) throws IcingException {
        if (arg == null || arg.startsWith(PROPERTY_ENC_PREFIX) || arg.startsWith(PROPERTY_IENC_PREFIX)) {
            return arg;
        }
        String iced = StringUtils.convertAsciiToHex(StringIcing.iceToBase64String(arg, pass));
        return PROPERTY_IENC_PREFIX + iced + PROPERTY_IENC_POSTFIX;
    }

    public static String diceFromPropertyString(String arg, String pass) throws IcingException {
        String ascii;
        if (arg != null && arg.startsWith(PROPERTY_ENC_PREFIX) && arg.endsWith(PROPERTY_ENC_POSTFIX)) {
            arg = arg.substring(PROPERTY_ENC_PREFIX.length());
            arg = arg.substring(0, arg.length() - 1);
        } else if (arg != null && arg.startsWith(PROPERTY_IENC_PREFIX) && arg.endsWith(PROPERTY_IENC_POSTFIX)) {
            arg = arg.substring(PROPERTY_IENC_PREFIX.length());
            arg = arg.substring(0, arg.length() - 1);
        } else {
            return arg;
        }
        try {
            ascii = StringUtils.convertHexToAscii(arg);
        }
        catch (Exception e) {
            throw new IcingException(e);
        }
        return StringIcing.diceFromBase64String(ascii, pass);
    }

    public static boolean isIcedPropertyString(String arg) {
        if (arg == null) {
            return false;
        }
        return (arg = arg.trim()).startsWith(PROPERTY_ENC_PREFIX) && arg.endsWith(PROPERTY_ENC_POSTFIX) || arg.startsWith(PROPERTY_IENC_PREFIX) && arg.endsWith(PROPERTY_IENC_POSTFIX);
    }

    public static String getValueDicedPropertyString(String arg) {
        if (arg != null && arg.startsWith(PROPERTY_ENC_PREFIX) && arg.endsWith(PROPERTY_ENC_POSTFIX)) {
            arg = arg.substring(PROPERTY_ENC_PREFIX.length());
            arg = arg.substring(0, arg.length() - 1);
        } else if (arg != null && arg.startsWith(PROPERTY_IENC_PREFIX) && arg.endsWith(PROPERTY_IENC_POSTFIX)) {
            arg = arg.substring(PROPERTY_IENC_PREFIX.length());
            arg = arg.substring(0, arg.length() - 1);
        }
        return arg;
    }

    public static void main(String[] args) {
        String value = "s3cr3tpassw0rd";
        System.out.println("Original Value : " + value);
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        encryptor.setPassword(password);
        String encryptedPassword = encryptor.encrypt(value);
        System.out.println(encryptedPassword);
        StandardPBEStringEncryptor decryptor = new StandardPBEStringEncryptor();
        decryptor.setPassword(password);
        System.out.println(decryptor.decrypt(encryptedPassword));
    }
}

