/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.util;

import com.remainsoftware.common.util.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobFunction;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public abstract class StatusJob
extends Job {
    private IStatus fStatus;
    private JobPriority fPriority = JobPriority.LONG;
    private boolean fIsUserTriggered;
    private boolean fIsSystem;
    private long fDelay;

    public static StatusJob createStatusJob(Runnable runnable) {
        return StatusJob.createStatusJob(null, runnable);
    }

    public static StatusJob createStatusJob(String name, final Runnable runnable) {
        return new StatusJob(StringUtils.isNotEmpty(name) ? name : ""){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    runnable.run();
                }
                catch (Throwable e) {
                    return new Status(4, StatusJob.class.getPackage().getName(), StringUtils.extractMessage(e), e);
                }
                return Status.OK_STATUS;
            }
        };
    }

    public static StatusJob createStatusJob(ICoreRunnable runnable) {
        return StatusJob.createStatusJob(null, runnable);
    }

    public static StatusJob createStatusJob(String name, final ICoreRunnable runnable) {
        return new StatusJob(StringUtils.isNotEmpty(name) ? name : ""){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        runnable.run(monitor);
                    }
                    catch (CoreException e) {
                        IStatus iStatus = e.getStatus();
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
    }

    public static StatusJob createStatusJob(IJobFunction jobFunction) {
        return StatusJob.createStatusJob(null, jobFunction);
    }

    public static StatusJob createStatusJob(String name, final IJobFunction jobFunction) {
        return new StatusJob(StringUtils.isNotEmpty(name) ? name : ""){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IStatus iStatus = jobFunction.run(monitor);
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
    }

    public StatusJob(String name) {
        super(name);
        this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                StatusJob.this.fStatus = event.getResult();
            }
        });
    }

    public final <T> T start() {
        this.fStatus = null;
        this.setUser(this.fIsUserTriggered);
        this.setSystem(this.fIsSystem);
        this.setPriority(this.fPriority.getPriority());
        this.schedule(this.fDelay);
        return (T)((Object)this);
    }

    public final <T> T start(boolean isUserTriggered, boolean isSystem, JobPriority priority, long delay) {
        this.fStatus = null;
        this.fIsUserTriggered = isUserTriggered;
        this.fIsSystem = isSystem;
        this.fPriority = priority;
        this.fDelay = delay;
        this.setUser(this.fIsUserTriggered);
        this.setSystem(this.fIsSystem);
        this.setPriority(this.fPriority.getPriority());
        this.schedule(this.fDelay);
        return (T)((Object)this);
    }

    public final boolean isJobDone() {
        return this.fStatus != null;
    }

    public final IStatus getStatus() {
        return this.fStatus;
    }

    public static enum JobPriority {
        INTERACTIVE(10),
        SHORT(20),
        LONG(30),
        BUILD(40),
        DECORATE(50);

        private int fPriority;

        private JobPriority(int priority) {
            this.fPriority = priority;
        }

        public int getPriority() {
            return this.fPriority;
        }
    }
}

