/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class NetworkController {
    private ProxySelector proxySelector;
    private Properties props;
    private String defaultProxy;
    private String proxyType;
    private String proxyServer;
    private int proxyPort;
    public static final String SYSTEM_PROXY = "system";
    public static final String MANUAL_PROXY = "manual";

    public NetworkController(Properties sysProps) {
        Properties properties = this.props = sysProps != null ? sysProps : new Properties();
        if (!Boolean.parseBoolean(this.props.getProperty("network.proxy.internal.disableJvmUseSystemProxy"))) {
            System.setProperty("java.net.useSystemProxies", "true");
        }
        this.proxySelector = ProxySelector.getDefault();
        this.defaultProxy = this.props.getProperty("network.proxy", SYSTEM_PROXY);
        this.proxyType = this.props.getProperty("network.proxy.type", "HTTP");
        this.proxyServer = this.props.getProperty("network.proxy.server", "127.0.0.1");
        String port = this.props.getProperty("network.proxy.port");
        this.proxyPort = StringUtils.isNotBlank((String)port) ? Integer.parseInt(port) : 80;
    }

    public Proxy getProxy(String uri) throws URISyntaxException {
        Proxy proxy;
        if (SYSTEM_PROXY.equalsIgnoreCase(this.defaultProxy)) {
            List<Proxy> proxyList = this.proxySelector.select(new URI(uri));
            proxy = proxyList.get(0);
            if (proxy.address() == null) {
                proxy = Proxy.NO_PROXY;
            }
        } else if (MANUAL_PROXY.equalsIgnoreCase(this.defaultProxy)) {
            InetSocketAddress sa = InetSocketAddress.createUnresolved(this.proxyServer, this.proxyPort);
            Proxy.Type type = Proxy.Type.HTTP.name().equalsIgnoreCase(this.proxyType) ? Proxy.Type.HTTP : (Proxy.Type.SOCKS.name().equalsIgnoreCase(this.proxyType) ? Proxy.Type.SOCKS : Proxy.Type.DIRECT);
            proxy = new Proxy(type, sa);
        } else {
            proxy = Proxy.NO_PROXY;
        }
        return proxy;
    }

    public InputStream openStream(String uri) throws URISyntaxException, IOException {
        URL url = new URL(uri);
        URLConnection conn = url.openConnection(this.getProxy(uri));
        return conn.getInputStream();
    }

    public InputStream openStream(String uri, int timeout) throws URISyntaxException, IOException {
        URL url = new URL(uri);
        URLConnection conn = url.openConnection(this.getProxy(uri));
        conn.setReadTimeout(timeout);
        conn.setUseCaches(true);
        return conn.getInputStream();
    }
}

