/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.util;

import com.remainsoftware.common.util.CommonConstants;
import com.remainsoftware.common.util.StringUtils;
import com.remainsoftware.common.util.Validate;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Emailer {
    private static Logger logger = LoggerFactory.getLogger(Emailer.class);
    private static final String TOADDRESS_MUST_BE_SET = "to-address must be set";
    private static final String FROMADDRESS_MUST_BE_SET = "from-address must be set";
    private static final String EMPTY_STRING = "";
    private static final String SMTP = "smtp";
    private static final String MAIL_SMTP_DESC = "mail.smtp";
    private static final String UTF_8_DESC = StandardCharsets.UTF_8.toString();
    private final String fHost;
    private final int fPort;
    private final String fUser;
    private final String fPassword;
    private final boolean isEnableAuth;
    private final boolean isEnableOauth2;
    private String fSubject = null;
    private String fMessage = null;
    private int fConnectTimeout = -1;
    private int fWriteTimeout = -1;
    private boolean fIsUseSsl = false;
    private boolean fIsUseTls = false;
    private boolean fIsTlsRequired = false;
    private String fSslProtocols = "";
    private boolean fIsCheckServerIdentity = false;
    private String fTrustedServers = "";
    private String fFromAddress = "";
    private String fFromName = "";
    private String[] fToAddresses = new String[0];
    private String fCharSet = UTF_8_DESC;
    private String fProxyHost = "";
    private int fProxyPort = -1;
    private String fProxyUser = "";
    private String fProxyPassword = "";
    private boolean fIsDebug = false;

    public Emailer(String host, int port, String user, String password, boolean passwordIsOauthToken) {
        Validate.isNotEmpty(host, "mail server host must be set");
        Validate.isNumberBetweenEqual(port, 1, 65535, "mail server port must be greater than zero end less than 65535");
        this.fHost = host;
        this.fPort = port;
        if (!StringUtils.isEmpty(user) && !StringUtils.isEmpty(password)) {
            this.isEnableAuth = true;
            this.isEnableOauth2 = passwordIsOauthToken;
            this.fUser = user;
            this.fPassword = password;
        } else {
            this.isEnableAuth = false;
            this.isEnableOauth2 = false;
            this.fUser = EMPTY_STRING;
            this.fPassword = EMPTY_STRING;
        }
    }

    public void sendMessage(String subject, String message) throws MessagingException {
        if (this.fToAddresses.length == 0 || this.fFromAddress.isEmpty()) {
            throw new MessagingException(String.format("a required mail field is empty; from-address: %s, to-addresses: [%s]", this.fFromAddress, String.join((CharSequence)",", this.fToAddresses)));
        }
        this.setupTextMessage(this.fToAddresses, this.fFromAddress, subject, message).send();
    }

    public Emailer setSubject(String subject) {
        if (subject == null) {
            subject = EMPTY_STRING;
        }
        this.fSubject = subject;
        return this;
    }

    public Emailer setMessage(String message) {
        if (message == null || message.length() == 0) {
            message = " ";
        }
        this.fMessage = message;
        return this;
    }

    public Emailer setupTextMessage(String[] toAddresses, String fromAddress, String subject, String message) {
        Validate.isNotNull(toAddresses, TOADDRESS_MUST_BE_SET);
        Validate.isTrue(toAddresses.length > 0, TOADDRESS_MUST_BE_SET);
        Validate.isNotEmpty(toAddresses[0], TOADDRESS_MUST_BE_SET);
        Validate.isNotEmpty(fromAddress, FROMADDRESS_MUST_BE_SET);
        this.fToAddresses = toAddresses;
        this.fFromAddress = fromAddress;
        this.fSubject = subject;
        this.fMessage = message;
        return this;
    }

    public void send() throws MessagingException {
        Properties properties = new Properties();
        properties.setProperty("mail.smtp.host", this.getHost());
        properties.setProperty("mail.smtp.port", EMPTY_STRING + this.getPort());
        properties.setProperty("mail.smtp.auth", Boolean.toString(this.isEnableAuth));
        if (this.isEnableOauth2) {
            properties.put("mail.smtp.auth.mechanisms", "XOAUTH2");
            properties.setProperty("mail.smtp.auth.login.disable", CommonConstants.TRUE);
            if (this.fIsDebug) {
                properties.put("mail.debug.auth", CommonConstants.TRUE);
            } else {
                properties.put("mail.debug.auth", CommonConstants.FALSE);
            }
        }
        this.setTimeoutProperties(properties);
        this.setMailSslTlsProperties(properties);
        this.setProxyProperties(properties);
        Session mailSession = Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(Emailer.this.fUser, Emailer.this.fPassword);
            }
        });
        if (this.fIsDebug) {
            mailSession.setDebug(true);
        }
        MimeMessage mimeMessage = new MimeMessage(mailSession);
        InternetAddress fromAddress = null;
        if (StringUtils.isEmpty(this.fFromName)) {
            try {
                fromAddress = new InternetAddress(this.fFromAddress, this.fFromName, this.fCharSet);
            }
            catch (UnsupportedEncodingException e) {
                logger.warn(String.format("failed to use from-name: %s, reason = %s", this.fFromName, StringUtils.extractMessage(e)));
                fromAddress = InternetAddress.parse((String)this.fFromAddress, (boolean)false)[0];
            }
        } else {
            fromAddress = InternetAddress.parse((String)this.fFromAddress, (boolean)false)[0];
        }
        mimeMessage.setFrom((Address)fromAddress);
        mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)String.join((CharSequence)" ", this.fToAddresses), (boolean)false));
        mimeMessage.setSubject(this.fSubject != null ? this.fSubject : " ", this.fCharSet);
        mimeMessage.setText(this.fMessage != null && this.fMessage.length() > 0 ? this.fMessage : " ", this.fCharSet);
        mimeMessage.setSentDate(new Date());
        Transport.send((Message)mimeMessage);
    }

    private void setTimeoutProperties(Properties properties) {
        if (this.fConnectTimeout > 0) {
            properties.setProperty("mail.smtp.connectiontimeout", EMPTY_STRING + this.getConnectTimeout());
        }
        if (this.fWriteTimeout > 0) {
            properties.setProperty("mail.smtp.writetimeout", EMPTY_STRING + this.getWriteTimeout());
        }
    }

    private void setProxyProperties(Properties properties) {
        if (StringUtils.isNotEmpty(this.fProxyHost)) {
            properties.setProperty("mail.smtp.proxy.host", this.fProxyHost);
            properties.setProperty("mail.smtp.proxy.port", EMPTY_STRING + this.fProxyPort);
            if (StringUtils.isNotEmpty(this.fProxyUser)) {
                properties.setProperty("mail.smtp.proxy.user", this.fProxyUser);
                properties.setProperty("mail.smtp.proxy.password", this.fProxyPassword);
            }
        }
    }

    private void setMailSslTlsProperties(Properties properties) {
        properties.setProperty("mail.smtp.sasl.enable", CommonConstants.FALSE);
        if (this.fIsUseTls) {
            properties.setProperty("mail.smtp.ssl.enable", CommonConstants.FALSE);
            properties.setProperty("mail.smtp.starttls.enable", CommonConstants.TRUE);
            properties.setProperty("mail.smtp.starttls.required", Boolean.toString(this.fIsTlsRequired));
        } else if (this.fIsUseSsl) {
            properties.setProperty("mail.smtp.ssl.enable", CommonConstants.TRUE);
            properties.setProperty("mail.smtp.starttls.enable", CommonConstants.FALSE);
            properties.setProperty("mail.smtp.starttls.required", CommonConstants.FALSE);
            properties.setProperty("mail.smtp.socketFactory.class", SSLSocketFactory.class.getName());
        } else {
            properties.setProperty("mail.smtp.auth.plain.disable", CommonConstants.FALSE);
            properties.setProperty("mail.smtp.ssl.enable", CommonConstants.FALSE);
            properties.setProperty("mail.smtp.starttls.enable", CommonConstants.FALSE);
            properties.setProperty("mail.smtp.starttls.required", CommonConstants.FALSE);
        }
        if (this.fIsUseTls || this.fIsUseSsl) {
            properties.setProperty("mail.smtp.auth.plain.disable", CommonConstants.TRUE);
            properties.setProperty("mail.smtp.auth.ntlm.disable", CommonConstants.TRUE);
            properties.setProperty("mail.smtp.auth.gssapi.disable", CommonConstants.TRUE);
            if (StringUtils.isNotEmpty(this.fTrustedServers)) {
                properties.put("mail.smtp.ssl.trust", this.fTrustedServers);
            }
            properties.setProperty("mail.smtp.ssl.checkserveridentity", Boolean.toString(this.fIsCheckServerIdentity));
            if (StringUtils.isNotEmpty(this.fSslProtocols)) {
                properties.setProperty("mail.smtp.ssl.protocols", this.fSslProtocols);
            }
        }
    }

    public String getHost() {
        return this.fHost;
    }

    public int getPort() {
        return this.fPort;
    }

    public int getConnectTimeout() {
        return this.fConnectTimeout;
    }

    public Emailer setConnectTimeout(int connectTimeout) {
        if (connectTimeout > 0) {
            this.fConnectTimeout = connectTimeout;
        }
        return this;
    }

    public int getWriteTimeout() {
        return this.fWriteTimeout;
    }

    public Emailer setWriteTimeout(int writeTimeout) {
        if (writeTimeout > 0) {
            this.fWriteTimeout = writeTimeout;
        }
        return this;
    }

    public boolean isUseSsl() {
        return this.fIsUseSsl;
    }

    public Emailer setUseSsl(boolean isUseSsl) {
        this.fIsUseSsl = isUseSsl;
        this.fIsUseTls = false;
        return this;
    }

    public boolean isUseTls() {
        return this.fIsUseTls;
    }

    public Emailer setUseTls(boolean isUseTls) {
        this.fIsUseTls = isUseTls;
        this.fIsUseSsl = false;
        return this;
    }

    public boolean isTlsRequired() {
        return this.fIsTlsRequired;
    }

    public Emailer setTlsRequired(boolean isTlsRequired) {
        this.fIsTlsRequired = isTlsRequired;
        return this;
    }

    public String getSslProtocolsProtocol() {
        return this.fSslProtocols;
    }

    public Emailer setSslProtocols(String sslProtocols) {
        this.fSslProtocols = sslProtocols;
        return this;
    }

    public boolean isCheckServerIdentity() {
        return this.fIsCheckServerIdentity;
    }

    public Emailer setCheckServerIdentity(boolean isCheckServerIdentity) {
        this.fIsCheckServerIdentity = isCheckServerIdentity;
        return this;
    }

    public String getTrustedServers() {
        return this.fTrustedServers;
    }

    public Emailer setTrustedServers(String trustedServers) {
        if (StringUtils.isNotEmpty(trustedServers)) {
            this.fTrustedServers = trustedServers;
        }
        return this;
    }

    public String getFromAddress() {
        return this.fFromAddress;
    }

    public Emailer setFromAddress(String fromAddress) {
        if (StringUtils.isNotEmpty(fromAddress)) {
            this.fFromAddress = fromAddress;
        }
        return this;
    }

    public String getFromName() {
        return this.fFromName;
    }

    public Emailer setFromName(String fromName) {
        if (StringUtils.isNotEmpty(fromName)) {
            this.fFromName = fromName;
        }
        return this;
    }

    public String[] getToAddresses() {
        return this.fToAddresses;
    }

    public Emailer setToAddresses(String[] toAddresses) {
        Validate.isNotNull(toAddresses, TOADDRESS_MUST_BE_SET);
        Validate.isTrue(toAddresses.length > 0, TOADDRESS_MUST_BE_SET);
        Validate.isNotEmpty(toAddresses[0], TOADDRESS_MUST_BE_SET);
        this.fToAddresses = toAddresses;
        return this;
    }

    public String getCharSet() {
        return this.fCharSet;
    }

    public Emailer setCharSet(String charSet) {
        Validate.isNotEmpty(charSet);
        if (Charset.availableCharsets().keySet().contains(charSet)) {
            this.fCharSet = charSet;
        } else {
            logger.warn(String.format("unsupported value provided for charset: %s", charSet));
        }
        return this;
    }

    public String getProxyHost() {
        return this.fProxyHost;
    }

    public Emailer setProxyHost(String proxyHost) {
        if (!StringUtils.isEmpty(proxyHost)) {
            this.fProxyHost = proxyHost;
        }
        return this;
    }

    public int getProxyPort() {
        return this.fProxyPort;
    }

    public Emailer setProxyPort(int proxyPort) {
        if (proxyPort >= 0) {
            this.fProxyPort = proxyPort;
        }
        return this;
    }

    public String getProxyUser() {
        return this.fProxyUser;
    }

    public Emailer setProxyUser(String proxyUser) {
        if (StringUtils.isEmpty(proxyUser)) {
            proxyUser = EMPTY_STRING;
        }
        this.fProxyUser = proxyUser;
        return this;
    }

    public String getProxyPassword() {
        return this.fProxyPassword;
    }

    public Emailer setProxyPassword(String proxyPassword) {
        if (StringUtils.isEmpty(proxyPassword)) {
            this.fProxyUser = EMPTY_STRING;
        }
        this.fProxyPassword = proxyPassword;
        return this;
    }

    public Emailer setDebug(boolean isDebug) {
        this.fIsDebug = isDebug;
        return this;
    }

    public static void main(String[] args) {
        Emailer.sendMailThruRemainOutlookProtected();
    }

    static void sendMailThruGmailWithToken() {
        String mailServerName = "smtp.gmail.com";
        int mailServerPort = 587;
        String mailServerUser = "walter.ridderhof@gmail.com";
        String mailServerPswd = "ya29.a0AeTM1idE0Ll76YKhC2Go_rxNioO2SfYE0_dyVyTcNfDuUy232ttLGOtmM8UC-Ov1s38kmTsPN2vyJGWU2uvLjzpFwfNe2stzWC-7V4Jk-5KN5cX0GeRl7iqaJWTDsPVf6vPfloTmPuUeyszvcKfoJbh0Sn0oaCgYKAYYSARMSFQHWtWOmgYS3Pni6NMl_ADaEGAcSxQ0163";
        Emailer emailer = new Emailer(mailServerName, mailServerPort, mailServerUser, mailServerPswd, true);
        emailer.setConnectTimeout(10000);
        emailer.setWriteTimeout(10000);
        emailer.setUseTls(true);
        emailer.setTlsRequired(true);
        emailer.setSslProtocols("TLSv1.1 TLSv1.2");
        emailer.setDebug(true);
        try {
            emailer.setupTextMessage(new String[]{"walter.ridderhof@gmail.com"}, "walter.ridderhof@gmail.com", "test emailer subject", "test emailer message using Gmail (OAuth)").setFromName("Walter").send();
            System.out.println("successfully sent a message to walter.ridderhof@gmail.com through " + mailServerName);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }

    static void sendMailThruOutlookWithToken() {
        String mailServerName = "smtp.office365.com";
        int mailServerPort = 587;
        String mailServerUser = "walter.ridderhof@remainsoftware.com";
        String mailServerPswd = "EwBAAl3BAAUFFpUAo7J3Ve0bjLBWZWCclRC3EoAA";
        Emailer emailer = new Emailer(mailServerName, mailServerPort, mailServerUser, mailServerPswd, true);
        emailer.setConnectTimeout(10000);
        emailer.setWriteTimeout(10000);
        emailer.setUseTls(true);
        emailer.setTlsRequired(true);
        emailer.setSslProtocols("TLSv1.1 TLSv1.2");
        emailer.setDebug(true);
        try {
            emailer.setupTextMessage(new String[]{"walter.ridderhof@gmail.com"}, "walter.ridderhof@remainsoftware.com", "test emailer subject", "test emailer message using Outlook (OAuth").send();
            System.out.println("successfully sent a message to walter.ridderhof@gmail.com through " + mailServerName);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }

    static void sendMailThruOutlook() {
        String mailServerName = "smtp.office365.com";
        int mailServerPort = 587;
        String mailServerUser = "walter.ridderhof@remainsoftware.com";
        String mailServerPswd = "secret";
        Emailer emailer = new Emailer(mailServerName, mailServerPort, mailServerUser, mailServerPswd, false);
        emailer.setConnectTimeout(10000);
        emailer.setWriteTimeout(10000);
        emailer.setUseTls(true);
        emailer.setTlsRequired(true);
        emailer.setSslProtocols("TLSv1.1 TLSv1.2");
        emailer.setDebug(true);
        try {
            emailer.setupTextMessage(new String[]{"walter.ridderhof@gmail.com"}, "walter.ridderhof@remainsoftware.com", "test emailer subject", "test emailer message using Outlook (credentials)").send();
            System.out.println("successfully sent a message to walter.ridderhof@gmail.com through " + mailServerName);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }

    static void sendMailThruRemainOutlookProtected() {
        String mailServerName = "remainsoftware-com.mail.protection.outlook.com";
        int mailServerPort = 25;
        String mailServerUser = EMPTY_STRING;
        String mailServerPswd = EMPTY_STRING;
        Emailer emailer = new Emailer(mailServerName, mailServerPort, mailServerUser, mailServerPswd, false);
        emailer.setConnectTimeout(10000);
        emailer.setWriteTimeout(10000);
        emailer.setDebug(true);
        try {
            emailer.setupTextMessage(new String[]{"walter.ridderhof@remainsoftware.com"}, "walter.ridderhof@remainsoftware.com", "test emailer subject", "test emailer message using Domino (no authentication)");
            emailer.send();
            System.out.println(String.format("sent an email message to %s through %s:%d", emailer.getToAddresses()[0], emailer.getHost(), mailServerPort));
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }
}

