/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.dds;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import miworkplace.i18n.Messages;
import miworkplace.ui.editor.dds.ast.Ast;
import miworkplace.ui.editor.dds.ast.RecordFormat;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.service.event.Event;
import org.osgi.service.log.LogService;

public class DdsOutlinePage {
    @Inject
    private LogService logger;
    @Inject
    private IEventBroker eventBroker;
    private IResourcePool imagePool;
    private TreeViewer viewer;
    private ArrayList<Categories> categories = new ArrayList();
    private StackLayout defaultLayout;
    private Composite noOutline;
    private String inputUri;
    private Ast ast;
    private Composite defaultComposite;

    @Inject
    public DdsOutlinePage(Composite parent, final @Named(value="inputUri") String inputUri, IResourcePool imagePool) {
        this.imagePool = imagePool;
        this.inputUri = inputUri;
        this.defaultComposite = new Composite(parent, 0);
        this.defaultLayout = new StackLayout();
        this.defaultComposite.setLayout((Layout)this.defaultLayout);
        this.noOutline = this.buildNoOutline(this.defaultComposite);
        this.viewer = new TreeViewer(this.defaultComposite, 768);
        this.viewer.setContentProvider((IContentProvider)new OutlineContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new OutlineLabelProvider());
        this.viewer.setComparator((ViewerComparator)new DdsOutlineSorter());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    return;
                }
                ITreeSelection selection = (ITreeSelection)event.getSelection();
                Object element = selection.getFirstElement();
                if (element == null) {
                    return;
                }
                if (element instanceof RecordFormat && ((RecordFormat)element).line > 0) {
                    int line = ((RecordFormat)element).line;
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("inputUri", inputUri);
                    data.put("line", line);
                    DdsOutlinePage.this.eventBroker.send("miworkplace/editor/highlight/line", data);
                }
            }
        });
    }

    private Composite buildNoOutline(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        RowLayout layout = new RowLayout();
        form.getBody().setLayout((Layout)layout);
        toolkit.createLabel(form.getBody(), Messages.common_outline_none);
        return form;
    }

    private void buildCategories(Ast ast) {
        this.categories.clear();
        if (!ast.listRecordFormats().isEmpty()) {
            this.categories.add(Categories.RecordFormat);
        }
    }

    public Control getControl() {
        return this.defaultComposite;
    }

    @Inject
    @Optional
    public void notifiedAstRebuild(@UIEventTopic(value="miworkplace/editor/reconciled") Event event) {
        if (event.containsProperty("inputUri")) {
            String astInputUri = event.getProperty("inputUri").toString();
            String astMemberPath = event.getProperty("memberPath").toString();
            this.logger.log(4, "Receiving event for rebuilt AST for " + astMemberPath);
            Object eventData = event.getProperty("org.eclipse.e4.data");
            if (this.inputUri.equals(astInputUri)) {
                this.ast = eventData != null && eventData instanceof Ast ? (Ast)eventData : null;
                this.viewer.setInput((Object)this.ast);
                if (this.ast != null) {
                    this.viewer.expandAll();
                }
            }
        }
    }

    private static enum Categories {
        RecordFormat;

    }

    class DdsOutlineSorter
    extends ViewerComparator {
        DdsOutlineSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof RecordFormat && e2 instanceof RecordFormat) {
                return ((RecordFormat)e1).name.compareToIgnoreCase(((RecordFormat)e2).name);
            }
            return super.compare(viewer, e1, e2);
        }
    }

    class OutlineContentProvider
    implements ITreeContentProvider {
        private final Object[] nullElements = new Object[0];

        OutlineContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Ast) {
                return DdsOutlinePage.this.categories.toArray(new Categories[DdsOutlinePage.this.categories.size()]);
            }
            if (parentElement == Categories.RecordFormat) {
                List<RecordFormat> recordFormats = DdsOutlinePage.this.ast.listRecordFormats();
                return recordFormats.toArray(new RecordFormat[recordFormats.size()]);
            }
            return this.nullElements;
        }

        public Object getParent(Object element) {
            if (element instanceof Categories) {
                return DdsOutlinePage.this.ast;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null) {
                DdsOutlinePage.this.defaultLayout.topControl = DdsOutlinePage.this.noOutline;
            } else if (newInput instanceof Ast) {
                DdsOutlinePage.this.buildCategories((Ast)newInput);
                DdsOutlinePage.this.defaultLayout.topControl = DdsOutlinePage.this.categories.isEmpty() ? DdsOutlinePage.this.noOutline : viewer.getControl();
                DdsOutlinePage.this.defaultComposite.layout(true);
            }
        }
    }

    class OutlineLabelProvider
    extends StyledCellLabelProvider {
        OutlineLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object obj = cell.getElement();
            if (obj == Categories.RecordFormat) {
                cell.setText(Messages.common_recordformats);
            } else if (obj instanceof RecordFormat) {
                cell.setText(((RecordFormat)obj).name);
            }
        }

        public Image getImage(Object obj) {
            if (obj instanceof RecordFormat) {
                return DdsOutlinePage.this.imagePool.getImageUnchecked("IMAGE_RECORDFORMAT");
            }
            if (obj == Categories.RecordFormat) {
                return DdsOutlinePage.this.imagePool.getImageUnchecked("IMAGE_RECORDFORMAT");
            }
            return null;
        }
    }
}

